/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.testfiles;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.schematron.testfiles.SchematronTestFile;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import javax.annotation.Nonnull;

public final class SchematronTestHelper {
    private static final ICommonsList<SchematronTestFile> s_aSCHs = SchematronTestHelper._readDI((IReadableResource)new ClassPathResource("test-sch/dirindex.xml"));
    private static final ICommonsList<SchematronTestFile> s_aSVRLs = SchematronTestHelper._readDI((IReadableResource)new ClassPathResource("test-svrl/dirindex.xml"));
    private static final ICommonsList<SchematronTestFile> s_aXMLs = SchematronTestHelper._readDI((IReadableResource)new ClassPathResource("test-xml/dirindex.xml"));

    @Nonnull
    private static ICommonsList<SchematronTestFile> _readDI(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        ValueEnforcer.isTrue((boolean)iReadableResource.exists(), () -> "Resource " + iReadableResource + " does not exist!");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((IReadableResource)iReadableResource);
        if (iMicroDocument == null) {
            throw new IllegalArgumentException("Failed to open/parse " + iReadableResource + " as XML");
        }
        String string = null;
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements()) {
            if (iMicroElement.getTagName().equals("directory")) {
                string = iMicroElement.getAttributeValue("basename");
                continue;
            }
            if (iMicroElement.getTagName().equals("file")) {
                commonsArrayList.add((Object)new SchematronTestFile(string, (IReadableResource)new ClassPathResource(iMicroElement.getAttributeValue("name")), iMicroElement.getAttributeValue("basename")));
                continue;
            }
            throw new IllegalArgumentException("Cannot handle " + iMicroElement);
        }
        return commonsArrayList;
    }

    private SchematronTestHelper() {
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IReadableResource> getAllValidSchematronFiles() {
        return s_aSCHs.getAllMapped(schematronTestFile -> !schematronTestFile.getFileBaseName().startsWith("invalid") && !schematronTestFile.getParentDirBaseName().equals("include"), SchematronTestFile::getResource);
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IReadableResource> getAllInvalidSchematronFiles() {
        return s_aSCHs.getAllMapped(schematronTestFile -> schematronTestFile.getFileBaseName().startsWith("invalid") && !schematronTestFile.getParentDirBaseName().equals("include"), SchematronTestFile::getResource);
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IReadableResource> getAllValidSVRLFiles() {
        return s_aSVRLs.getAllMapped(schematronTestFile -> !schematronTestFile.getFileBaseName().startsWith("invalid"), SchematronTestFile::getResource);
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IReadableResource> getAllInvalidSVRLFiles() {
        return s_aSVRLs.getAllMapped(schematronTestFile -> schematronTestFile.getFileBaseName().startsWith("invalid"), SchematronTestFile::getResource);
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IReadableResource> getAllValidXMLFiles() {
        return s_aXMLs.getAllMapped(schematronTestFile -> !schematronTestFile.getFileBaseName().startsWith("invalid"), SchematronTestFile::getResource);
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IReadableResource> getAllInvalidXMLFiles() {
        return s_aXMLs.getAllMapped(schematronTestFile -> schematronTestFile.getFileBaseName().startsWith("invalid"), SchematronTestFile::getResource);
    }
}

