/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.sort;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.commons.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.commons.id.IHasID;
import com.helger.tree.IBasicTree;
import com.helger.tree.IBasicTreeItem;
import com.helger.tree.util.TreeVisitor;
import com.helger.tree.withid.ITreeItemWithID;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeWithIDSorter {
    private static final TreeWithIDSorter s_aInstance = new TreeWithIDSorter();

    private TreeWithIDSorter() {
    }

    private static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void _sort(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, final @Nonnull Comparator<? super ITEMTYPE> comparator) {
        ValueEnforcer.notNull(iBasicTree, (String)"Tree");
        ValueEnforcer.notNull(comparator, (String)"Comparator");
        ((ITreeItemWithID)iBasicTree.getRootItem()).reorderChildrenByItems(comparator);
        TreeVisitor.visitTree(iBasicTree, new DefaultHierarchyVisitorCallback<ITEMTYPE>(){

            public EHierarchyVisitorReturn onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    ITEMTYPE.reorderChildrenByItems(comparator);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
    }

    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void sortByID(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super KEYTYPE> comparator) {
        TreeWithIDSorter._sort(iBasicTree, Comparator.comparing(IHasID::getID, comparator));
    }

    public static <KEYTYPE extends Comparable<? super KEYTYPE>, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void sortByID(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree) {
        TreeWithIDSorter._sort(iBasicTree, IHasID.getComparatorID());
    }

    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void sortByValue(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super DATATYPE> comparator) {
        TreeWithIDSorter._sort(iBasicTree, Comparator.comparing(IBasicTreeItem::getData, comparator));
    }

    public static <KEYTYPE, DATATYPE extends Comparable<? super DATATYPE>, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void sortByValue(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree) {
        TreeWithIDSorter._sort(iBasicTree, (iTreeItemWithID, iTreeItemWithID2) -> ((Comparable)iTreeItemWithID.getData()).compareTo(iTreeItemWithID2.getData()));
    }
}

