/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.functional.IFunction;
import com.helger.commons.hierarchy.ChildrenProviderHasChildren;
import com.helger.commons.hierarchy.IChildrenProvider;
import com.helger.commons.hierarchy.visit.ChildrenProviderHierarchyVisitor;
import com.helger.commons.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.commons.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.commons.hierarchy.visit.IHierarchyVisitorCallback;
import com.helger.tree.IBasicTree;
import com.helger.tree.IBasicTreeItem;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeVisitor {
    private static final TreeVisitor s_aInstance = new TreeVisitor();

    private TreeVisitor() {
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTree(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull IHierarchyVisitorCallback<? super ITEMTYPE> iHierarchyVisitorCallback) {
        TreeVisitor.visitTree(iBasicTree, new ChildrenProviderHasChildren(), iHierarchyVisitorCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTree(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull IChildrenProvider<ITEMTYPE> iChildrenProvider, @Nonnull IHierarchyVisitorCallback<? super ITEMTYPE> iHierarchyVisitorCallback) {
        ValueEnforcer.notNull(iBasicTree, (String)"Tree");
        TreeVisitor.visitTreeItem(iBasicTree.getRootItem(), iChildrenProvider, iHierarchyVisitorCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTreeData(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull IHierarchyVisitorCallback<? super DATATYPE> iHierarchyVisitorCallback) {
        TreeVisitor.visitTreeData(iBasicTree, new ChildrenProviderHasChildren(), iHierarchyVisitorCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTreeData(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull IChildrenProvider<ITEMTYPE> iChildrenProvider, @Nonnull IHierarchyVisitorCallback<? super DATATYPE> iHierarchyVisitorCallback) {
        ValueEnforcer.notNull(iBasicTree, (String)"Tree");
        TreeVisitor.visitTreeItemData(iBasicTree.getRootItem(), iChildrenProvider, iHierarchyVisitorCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTreeItem(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull IHierarchyVisitorCallback<? super ITEMTYPE> iHierarchyVisitorCallback) {
        ValueEnforcer.notNull(ITEMTYPE, (String)"TreeItem");
        ChildrenProviderHierarchyVisitor.visitFrom(ITEMTYPE, iHierarchyVisitorCallback, (boolean)false);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTreeItem(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull IChildrenProvider<ITEMTYPE> iChildrenProvider, @Nonnull IHierarchyVisitorCallback<? super ITEMTYPE> iHierarchyVisitorCallback) {
        ValueEnforcer.notNull(ITEMTYPE, (String)"TreeItem");
        ChildrenProviderHierarchyVisitor.visitFrom(ITEMTYPE, iChildrenProvider, iHierarchyVisitorCallback, (boolean)false);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTreeItemData(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull IHierarchyVisitorCallback<? super DATATYPE> iHierarchyVisitorCallback) {
        TreeVisitor.visitTreeItemData(ITEMTYPE, new ChildrenProviderHasChildren(), iHierarchyVisitorCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTreeItemData(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull IChildrenProvider<ITEMTYPE> iChildrenProvider, @Nonnull IHierarchyVisitorCallback<? super DATATYPE> iHierarchyVisitorCallback) {
        ValueEnforcer.notNull(iHierarchyVisitorCallback, (String)"DataCallback");
        TreeVisitor.visitTreeItem(ITEMTYPE, iChildrenProvider, new HierarchyVisitorCallbackWithConversion(iHierarchyVisitorCallback, IBasicTreeItem::getData));
    }

    public static class HierarchyVisitorCallbackWithConversion<ITEMTYPE, DATATYPE>
    extends DefaultHierarchyVisitorCallback<ITEMTYPE> {
        private final IHierarchyVisitorCallback<? super DATATYPE> m_aDataCallback;
        private final IFunction<? super ITEMTYPE, ? extends DATATYPE> m_aConverter;

        public HierarchyVisitorCallbackWithConversion(@Nonnull IHierarchyVisitorCallback<? super DATATYPE> iHierarchyVisitorCallback, @Nonnull IFunction<? super ITEMTYPE, ? extends DATATYPE> iFunction) {
            this.m_aDataCallback = (IHierarchyVisitorCallback)ValueEnforcer.notNull(iHierarchyVisitorCallback, (String)"DataCallback");
            this.m_aConverter = (IFunction)ValueEnforcer.notNull(iFunction, (String)"Converter");
        }

        public void begin() {
            super.begin();
            this.m_aDataCallback.begin();
        }

        public void onLevelDown() {
            super.onLevelDown();
            this.m_aDataCallback.onLevelDown();
        }

        public void onLevelUp() {
            this.m_aDataCallback.onLevelUp();
            super.onLevelUp();
        }

        @Nonnull
        public EHierarchyVisitorReturn onItemBeforeChildren(@Nonnull ITEMTYPE ITEMTYPE) {
            Object object = this.m_aConverter.apply(ITEMTYPE);
            return this.m_aDataCallback.onItemBeforeChildren(object);
        }

        @Nonnull
        public EHierarchyVisitorReturn onItemAfterChildren(@Nonnull ITEMTYPE ITEMTYPE) {
            Object object = this.m_aConverter.apply(ITEMTYPE);
            return this.m_aDataCallback.onItemAfterChildren(object);
        }

        public void end() {
            this.m_aDataCallback.end();
            super.end();
        }
    }
}

