
package com.helger.xsds.bdxr.smp2.ac;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.bdxr.smp2.bc.ActivationDateType;
import com.helger.xsds.bdxr.smp2.bc.ContentBinaryObjectType;
import com.helger.xsds.bdxr.smp2.bc.DescriptionType;
import com.helger.xsds.bdxr.smp2.bc.ExpirationDateType;
import com.helger.xsds.bdxr.smp2.bc.TypeCodeType;
import com.helger.xsds.bdxr.smp2.ec.SMPExtensionsType;


/**
 * <p>Java class for CertificateType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CertificateType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/ExtensionComponents}SMPExtensions" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents}TypeCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents}Description" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents}ActivationDate" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents}ExpirationDate" minOccurs="0"/&gt;
 *         &lt;element ref="{http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents}ContentBinaryObject"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CertificateType", propOrder = {
    "smpExtensions",
    "typeCode",
    "description",
    "activationDate",
    "expirationDate",
    "contentBinaryObject"
})
@CodingStyleguideUnaware
public class CertificateType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "SMPExtensions", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/ExtensionComponents")
    private SMPExtensionsType smpExtensions;
    @XmlElement(name = "TypeCode", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private TypeCodeType typeCode;
    @XmlElement(name = "Description", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private DescriptionType description;
    @XmlElement(name = "ActivationDate", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private ActivationDateType activationDate;
    @XmlElement(name = "ExpirationDate", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private ExpirationDateType expirationDate;
    @XmlElement(name = "ContentBinaryObject", namespace = "http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents", required = true)
    private ContentBinaryObjectType contentBinaryObject;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CertificateType() {
    }

    /**
     * Gets the value of the smpExtensions property.
     * 
     * @return
     *     possible object is
     *     {@link SMPExtensionsType }
     *     
     */
    @Nullable
    public SMPExtensionsType getSMPExtensions() {
        return smpExtensions;
    }

    /**
     * Sets the value of the smpExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link SMPExtensionsType }
     *     
     */
    public void setSMPExtensions(
        @Nullable
        SMPExtensionsType value) {
        this.smpExtensions = value;
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link TypeCodeType }
     *     
     */
    @Nullable
    public TypeCodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TypeCodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        TypeCodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link DescriptionType }
     *     
     */
    @Nullable
    public DescriptionType getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link DescriptionType }
     *     
     */
    public void setDescription(
        @Nullable
        DescriptionType value) {
        this.description = value;
    }

    /**
     * Gets the value of the activationDate property.
     * 
     * @return
     *     possible object is
     *     {@link ActivationDateType }
     *     
     */
    @Nullable
    public ActivationDateType getActivationDate() {
        return activationDate;
    }

    /**
     * Sets the value of the activationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ActivationDateType }
     *     
     */
    public void setActivationDate(
        @Nullable
        ActivationDateType value) {
        this.activationDate = value;
    }

    /**
     * Gets the value of the expirationDate property.
     * 
     * @return
     *     possible object is
     *     {@link ExpirationDateType }
     *     
     */
    @Nullable
    public ExpirationDateType getExpirationDate() {
        return expirationDate;
    }

    /**
     * Sets the value of the expirationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExpirationDateType }
     *     
     */
    public void setExpirationDate(
        @Nullable
        ExpirationDateType value) {
        this.expirationDate = value;
    }

    /**
     * Gets the value of the contentBinaryObject property.
     * 
     * @return
     *     possible object is
     *     {@link ContentBinaryObjectType }
     *     
     */
    @Nullable
    public ContentBinaryObjectType getContentBinaryObject() {
        return contentBinaryObject;
    }

    /**
     * Sets the value of the contentBinaryObject property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContentBinaryObjectType }
     *     
     */
    public void setContentBinaryObject(
        @Nullable
        ContentBinaryObjectType value) {
        this.contentBinaryObject = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CertificateType rhs = ((CertificateType) o);
        if (!EqualsHelper.equals(activationDate, rhs.activationDate)) {
            return false;
        }
        if (!EqualsHelper.equals(contentBinaryObject, rhs.contentBinaryObject)) {
            return false;
        }
        if (!EqualsHelper.equals(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(expirationDate, rhs.expirationDate)) {
            return false;
        }
        if (!EqualsHelper.equals(smpExtensions, rhs.smpExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(smpExtensions).append(typeCode).append(description).append(activationDate).append(expirationDate).append(contentBinaryObject).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("smpExtensions", smpExtensions).append("typeCode", typeCode).append("description", description).append("activationDate", activationDate).append("expirationDate", expirationDate).append("contentBinaryObject", contentBinaryObject).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CertificateType ret) {
        ret.activationDate = ((activationDate == null)?null:activationDate.clone());
        ret.contentBinaryObject = ((contentBinaryObject == null)?null:contentBinaryObject.clone());
        ret.description = ((description == null)?null:description.clone());
        ret.expirationDate = ((expirationDate == null)?null:expirationDate.clone());
        ret.smpExtensions = ((smpExtensions == null)?null:smpExtensions.clone());
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CertificateType clone() {
        CertificateType ret = new CertificateType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type byte[]<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ContentBinaryObjectType and never <code>null</code>
     */
    @Nonnull
    public ContentBinaryObjectType setContentBinaryObject(
        @Nullable
        final byte[] valueParam) {
        ContentBinaryObjectType aObj = getContentBinaryObject();
        if (aObj == null) {
            aObj = new ContentBinaryObjectType(valueParam);
            setContentBinaryObject(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TypeCodeType and never <code>null</code>
     */
    @Nonnull
    public TypeCodeType setTypeCode(
        @Nullable
        final String valueParam) {
        TypeCodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new TypeCodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLGregorianCalendar<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ActivationDateType and never <code>null</code>
     */
    @Nonnull
    public ActivationDateType setActivationDate(
        @Nullable
        final XMLGregorianCalendar valueParam) {
        ActivationDateType aObj = getActivationDate();
        if (aObj == null) {
            aObj = new ActivationDateType(valueParam);
            setActivationDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLGregorianCalendar<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ExpirationDateType and never <code>null</code>
     */
    @Nonnull
    public ExpirationDateType setExpirationDate(
        @Nullable
        final XMLGregorianCalendar valueParam) {
        ExpirationDateType aObj = getExpirationDate();
        if (aObj == null) {
            aObj = new ExpirationDateType(valueParam);
            setExpirationDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DescriptionType and never <code>null</code>
     */
    @Nonnull
    public DescriptionType setDescription(
        @Nullable
        final String valueParam) {
        DescriptionType aObj = getDescription();
        if (aObj == null) {
            aObj = new DescriptionType(valueParam);
            setDescription(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained TypeCodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        TypeCodeType aObj = getTypeCode();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained DescriptionType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DescriptionType object or <code>null</code>
     */
    @Nullable
    public String getDescriptionValue() {
        DescriptionType aObj = getDescription();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained ActivationDateType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ActivationDateType object or <code>null</code>
     */
    @Nullable
    public XMLGregorianCalendar getActivationDateValue() {
        ActivationDateType aObj = getActivationDate();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained ExpirationDateType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ExpirationDateType object or <code>null</code>
     */
    @Nullable
    public XMLGregorianCalendar getExpirationDateValue() {
        ExpirationDateType aObj = getExpirationDate();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained ContentBinaryObjectType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ContentBinaryObjectType object or <code>null</code>
     */
    @Nullable
    public byte[] getContentBinaryObjectValue() {
        ContentBinaryObjectType aObj = getContentBinaryObject();
        return ((aObj == null)?null:aObj.getValue());
    }

}
