/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.profile.cef;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.crypto.ECryptoAlgorithmCrypt;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.EMEP;
import com.helger.phase4.model.EMEPBinding;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.PModePayloadService;
import com.helger.phase4.model.pmode.PModeValidationException;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.leg.PModeLegProtocol;
import com.helger.phase4.profile.IAS4ProfileValidator;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.wss.EWSSVersion;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CEFCompatibilityValidator
implements IAS4ProfileValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CEFCompatibilityValidator.class);

    @Nonnull
    private static IError _createError(@Nonnull String string) {
        return ((SingleError.SingleErrorBuilder)SingleError.builderError().setErrorText(string)).build();
    }

    public void validatePMode(@Nonnull IPMode iPMode, @Nonnull ErrorList errorList) {
        PModeLeg pModeLeg;
        assert (errorList.isEmpty()) : "Errors in global PMode validation: " + errorList.toString();
        try {
            MetaAS4Manager.getPModeMgr().validatePMode(iPMode);
        }
        catch (PModeValidationException pModeValidationException) {
            errorList.add((Object)CEFCompatibilityValidator._createError(pModeValidationException.getMessage()));
        }
        EMEP eMEP = iPMode.getMEP();
        EMEPBinding eMEPBinding = iPMode.getMEPBinding();
        if (!(eMEP == EMEP.ONE_WAY && eMEPBinding == EMEPBinding.PUSH || eMEP == EMEP.TWO_WAY && eMEPBinding == EMEPBinding.PUSH_PUSH)) {
            errorList.add((Object)CEFCompatibilityValidator._createError("An invalid combination of PMode MEP (" + eMEP + ") and MEP binding (" + eMEPBinding + ") was specified, valid are only one-way/push and two-way/push-push."));
        }
        if ((pModeLeg = iPMode.getLeg1()) == null) {
            errorList.add((Object)CEFCompatibilityValidator._createError("PMode is missing Leg 1"));
        } else {
            this._checkIfLegIsValid(iPMode, errorList, pModeLeg);
            if (eMEP.isTwoWay()) {
                PModeLeg pModeLeg2 = iPMode.getLeg2();
                if (pModeLeg2 == null) {
                    errorList.add((Object)CEFCompatibilityValidator._createError("PMode is missing Leg 2 and is specified as TWO-WAY"));
                } else {
                    this._checkIfLegIsValid(iPMode, errorList, pModeLeg2);
                }
            }
        }
    }

    private void _checkIfLegIsValid(@Nonnull IPMode iPMode, @Nonnull ErrorList errorList, @Nonnull PModeLeg pModeLeg) {
        EAS4CompressionMode eAS4CompressionMode;
        PModePayloadService pModePayloadService;
        ESoapVersion eSoapVersion;
        String string;
        PModeLegProtocol pModeLegProtocol = pModeLeg.getProtocol();
        if (pModeLegProtocol == null) {
            errorList.add((Object)CEFCompatibilityValidator._createError("PMode Leg 1 is missing Protocol"));
        } else {
            string = pModeLegProtocol.getAddressProtocol();
            if (!(string == null || string.equalsIgnoreCase("https") || string.equalsIgnoreCase("http") && GlobalDebug.isDebugMode())) {
                errorList.add((Object)CEFCompatibilityValidator._createError("PMode Leg1 uses a non-standard AddressProtocol: " + string));
            }
            if (!(eSoapVersion = pModeLegProtocol.getSoapVersion()).isAS4Default()) {
                errorList.add((Object)CEFCompatibilityValidator._createError("PMode Leg1 uses a non-standard SOAP version: " + eSoapVersion.getVersion()));
            }
        }
        string = pModeLeg.getSecurity();
        if (string != null) {
            if (string.getX509SignatureAlgorithm() == null) {
                errorList.add((Object)CEFCompatibilityValidator._createError("No signature algorithm is specified but is required"));
            } else if (!string.getX509SignatureAlgorithm().equals((Object)ECryptoAlgorithmSign.RSA_SHA_256)) {
                errorList.add((Object)CEFCompatibilityValidator._createError("AS4 Profile only allows " + ECryptoAlgorithmSign.RSA_SHA_256.getID() + " as signing algorithm"));
            }
            if (string.getX509SignatureHashFunction() == null) {
                errorList.add((Object)CEFCompatibilityValidator._createError("No hash function (Digest Algorithm) is specified but is required"));
            } else if (!string.getX509SignatureHashFunction().equals((Object)ECryptoAlgorithmSignDigest.DIGEST_SHA_256)) {
                errorList.add((Object)CEFCompatibilityValidator._createError("AS4 Profile only allows " + ECryptoAlgorithmSignDigest.DIGEST_SHA_256.getID() + " as hash function"));
            }
            if (string.getX509EncryptionAlgorithm() == null) {
                errorList.add((Object)CEFCompatibilityValidator._createError("No encryption algorithm is specified but is required"));
            } else if (!string.getX509EncryptionAlgorithm().equals((Object)ECryptoAlgorithmCrypt.AES_128_GCM)) {
                errorList.add((Object)CEFCompatibilityValidator._createError("AS4 Profile only allows " + ECryptoAlgorithmCrypt.AES_128_GCM.getID() + " as encryption algorithm"));
            }
            if (string.getWSSVersion() != null && !string.getWSSVersion().equals((Object)EWSSVersion.WSS_111)) {
                errorList.add((Object)CEFCompatibilityValidator._createError("Wrong WSS Version " + string.getWSSVersion() + " only " + EWSSVersion.WSS_111 + " is allowed."));
            }
            if (string.isPModeAuthorizeDefined()) {
                if (string.isPModeAuthorize()) {
                    errorList.add((Object)CEFCompatibilityValidator._createError("PMode Authorize has to be set to false"));
                }
            } else {
                errorList.add((Object)CEFCompatibilityValidator._createError("PMode Authorize is a mandatory parameter"));
            }
            if (string.isSendReceiptDefined() && string.isSendReceipt() && string.getSendReceiptReplyPattern() != EPModeSendReceiptReplyPattern.RESPONSE) {
                errorList.add((Object)CEFCompatibilityValidator._createError("Only response is allowed as pattern"));
            }
        }
        if ((eSoapVersion = pModeLeg.getErrorHandling()) != null) {
            if (eSoapVersion.isReportAsResponseDefined()) {
                if (!eSoapVersion.isReportAsResponse()) {
                    errorList.add((Object)CEFCompatibilityValidator._createError("PMode ReportAsResponse has to be True"));
                }
            } else {
                errorList.add((Object)CEFCompatibilityValidator._createError("ReportAsResponse is a mandatory PMode parameter"));
            }
            if (eSoapVersion.isReportProcessErrorNotifyConsumerDefined()) {
                if (!eSoapVersion.isReportProcessErrorNotifyConsumer()) {
                    errorList.add((Object)CEFCompatibilityValidator._createError("PMode ReportProcessErrorNotifyConsumer has to be True"));
                }
            } else {
                errorList.add((Object)CEFCompatibilityValidator._createError("ReportProcessErrorNotifyConsumer is a mandatory PMode parameter"));
            }
            if (eSoapVersion.isReportDeliveryFailuresNotifyProducerDefined()) {
                if (!eSoapVersion.isReportDeliveryFailuresNotifyProducer()) {
                    errorList.add((Object)CEFCompatibilityValidator._createError("PMode ReportDeliveryFailuresNotifyProducer has to be True"));
                }
            } else {
                errorList.add((Object)CEFCompatibilityValidator._createError("ReportDeliveryFailuresNotifyProducer is a mandatory PMode parameter"));
            }
        } else {
            errorList.add((Object)CEFCompatibilityValidator._createError("No ErrorHandling Parameter present but they are mandatory"));
        }
        if ((pModePayloadService = iPMode.getPayloadService()) != null && (eAS4CompressionMode = pModePayloadService.getCompressionMode()) != null && !eAS4CompressionMode.equals((Object)EAS4CompressionMode.GZIP)) {
            errorList.add((Object)CEFCompatibilityValidator._createError("Only GZIP Compression is allowed"));
        }
    }

    public void validateUserMessage(@Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull ErrorList errorList) {
        ValueEnforcer.notNull((Object)ebms3UserMessage, (String)"UserMsg");
        if (ebms3UserMessage.getMessageInfo() != null) {
            if (StringHelper.hasNoText((String)ebms3UserMessage.getMessageInfo().getMessageId())) {
                errorList.add((Object)CEFCompatibilityValidator._createError("MessageID is missing but is mandatory!"));
            }
        } else {
            errorList.add((Object)CEFCompatibilityValidator._createError("MessageInfo is missing but is mandatory!"));
        }
        if (ebms3UserMessage.getPartyInfo() != null) {
            if (ebms3UserMessage.getPartyInfo().getTo() != null && ebms3UserMessage.getPartyInfo().getTo().getPartyIdCount() > 1) {
                errorList.add((Object)CEFCompatibilityValidator._createError("Only 1 PartyID is allowed in PartyTo - part"));
            }
            if (ebms3UserMessage.getPartyInfo().getFrom() != null && ebms3UserMessage.getPartyInfo().getFrom().getPartyIdCount() > 1) {
                errorList.add((Object)CEFCompatibilityValidator._createError("Only 1 PartyID is allowed in PartyFrom - part"));
            }
        } else {
            errorList.add((Object)CEFCompatibilityValidator._createError("At least one PartyInfo element has to be present"));
        }
    }

    public void validateSignalMessage(@Nonnull Ebms3SignalMessage ebms3SignalMessage, @Nonnull ErrorList errorList) {
        ValueEnforcer.notNull((Object)ebms3SignalMessage, (String)"SignalMsg");
        if (StringHelper.hasNoText((String)ebms3SignalMessage.getMessageInfo().getMessageId())) {
            errorList.add((Object)CEFCompatibilityValidator._createError("MessageID is missing but is mandatory!"));
        }
    }
}

