/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.springboot.servlet;

import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.URLHelper;
import com.helger.httpclient.HttpClientSettings;
import com.helger.httpclient.HttpDebugger;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.crypto.AS4CryptoFactoryConfiguration;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.incoming.AS4ServerInitializer;
import com.helger.phase4.incoming.mgr.AS4ProfileSelector;
import com.helger.phase4.peppol.servlet.Phase4PeppolDefaultReceiverConfiguration;
import com.helger.phase4.profile.peppol.PeppolCRLDownloader;
import com.helger.phase4.profile.peppol.Phase4PeppolHttpClientSettings;
import com.helger.phase4.springboot.servlet.ServletConfig;
import com.helger.photon.io.WebFileIO;
import com.helger.servlet.ServletHelper;
import com.helger.smpclient.peppol.ISMPServiceMetadataProvider;
import com.helger.smpclient.peppol.PeppolWildcardSelector;
import com.helger.smpclient.peppol.SMPClientReadOnly;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xservlet.requesttrack.RequestTrackerSettings;
import jakarta.activation.CommandMap;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class ServletConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletConfig.class);

    @Nonnull
    public static IAS4CryptoFactory getCryptoFactoryToUse() {
        return AS4CryptoFactoryConfiguration.getDefaultInstance();
    }

    @Bean
    public ServletRegistrationBean<MyAS4Servlet> servletRegistrationBean(ServletContext servletContext) {
        this._init(servletContext);
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)new MyAS4Servlet(), true, new String[]{"/as4"});
        servletRegistrationBean.setLoadOnStartup(1);
        return servletRegistrationBean;
    }

    private void _init(@Nonnull ServletContext servletContext) {
        if (!WebScopeManager.isGlobalScopePresent()) {
            WebScopeManager.onGlobalBegin((ServletContext)servletContext);
            ServletConfig._initGlobalSettings((ServletContext)servletContext);
            ServletConfig._initAS4();
            ServletConfig._initPeppolAS4();
        }
    }

    private static void _initGlobalSettings(@Nonnull ServletContext servletContext) {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        if (GlobalDebug.isDebugMode()) {
            RequestTrackerSettings.setLongRunningRequestsCheckEnabled((boolean)false);
            RequestTrackerSettings.setParallelRunningRequestsCheckEnabled((boolean)false);
        }
        HttpDebugger.setEnabled((boolean)false);
        if (CommandMap.getDefaultCommandMap().createDataContentHandler(CMimeType.MULTIPART_RELATED.getAsString()) == null) {
            throw new IllegalStateException("No DataContentHandler for MIME Type '" + CMimeType.MULTIPART_RELATED.getAsString() + "' is available. There seems to be a problem with the dependencies/packaging");
        }
        String string = ServletHelper.getServletContextBasePath((ServletContext)servletContext);
        String string2 = AS4Configuration.getDataPath();
        if (StringHelper.hasNoText((String)string2)) {
            throw new InitializationException("No data path was provided!");
        }
        WebFileIO.initPaths((File)new File(string2).getAbsoluteFile(), (String)string, (boolean)false);
    }

    private static void _initAS4() {
        AS4ProfileSelector.setCustomDefaultAS4ProfileID((String)"peppol");
        AS4ServerInitializer.initAS4Server();
    }

    private static void _initPeppolAS4() {
        Phase4PeppolDefaultReceiverConfiguration.setCheckSBDHForMandatoryCountryC1((boolean)true);
        Phase4PeppolDefaultReceiverConfiguration.setCheckSigningCertificateRevocation((boolean)true);
        PeppolCRLDownloader.setAsDefaultCRLCache((HttpClientSettings)new Phase4PeppolHttpClientSettings());
        IAS4CryptoFactory iAS4CryptoFactory = ServletConfig.getCryptoFactoryToUse();
        KeyStore keyStore = iAS4CryptoFactory.getKeyStore();
        if (keyStore == null) {
            throw new InitializationException("Failed to load configured AS4 Key store - fix the configuration");
        }
        LOGGER.info("Successfully loaded configured AS4 key store from the crypto factory");
        KeyStore.PrivateKeyEntry privateKeyEntry = iAS4CryptoFactory.getPrivateKeyEntry();
        if (privateKeyEntry == null) {
            throw new InitializationException("Failed to load configured AS4 private key - fix the configuration");
        }
        LOGGER.info("Successfully loaded configured AS4 private key from the crypto factory");
        X509Certificate x509Certificate = (X509Certificate)privateKeyEntry.getCertificate();
        String string = AS4Configuration.getConfig().getAsString((Object)"smp.url");
        String string2 = AS4Configuration.getThisEndpointAddress();
        if (StringHelper.hasText((String)string) && StringHelper.hasText((String)string2)) {
            Phase4PeppolDefaultReceiverConfiguration.setReceiverCheckEnabled((boolean)true);
            Phase4PeppolDefaultReceiverConfiguration.setSMPClient((ISMPServiceMetadataProvider)new SMPClientReadOnly(URLHelper.getAsURI((String)string)));
            Phase4PeppolDefaultReceiverConfiguration.setWildcardSelectionMode((PeppolWildcardSelector.EMode)Phase4PeppolDefaultReceiverConfiguration.DEFAULT_WILDCARD_SELECTION_MODE);
            Phase4PeppolDefaultReceiverConfiguration.setAS4EndpointURL((String)string2);
            Phase4PeppolDefaultReceiverConfiguration.setAPCertificate((X509Certificate)x509Certificate);
            LOGGER.info("phase4 Peppol receiver checks are enabled");
        } else {
            Phase4PeppolDefaultReceiverConfiguration.setReceiverCheckEnabled((boolean)false);
            LOGGER.warn("phase4 Peppol receiver checks are disabled");
        }
    }

    @Bean
    public Destroyer destroyer() {
        return new Destroyer();
    }
}

