/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.springboot.spi;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.peppol.sbdh.PeppolSBDHData;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import com.helger.phase4.incoming.IAS4IncomingMessageState;
import com.helger.phase4.peppol.servlet.IPhase4PeppolIncomingSBDHandlerSPI;
import com.helger.phase4.springboot.enumeration.ESBDHHandlerServiceSelector;
import com.helger.phase4.springboot.service.ISBDHandlerService;
import com.helger.phase4.springboot.service.SDBHandlerServiceLocator;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocument;

@IsSPIImplementation
public class CustomPeppolIncomingSBDHandlerSPI
implements IPhase4PeppolIncomingSBDHandlerSPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomPeppolIncomingSBDHandlerSPI.class);

    public void handleIncomingSBD(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull byte[] byArray, @Nonnull StandardBusinessDocument standardBusinessDocument, @Nonnull PeppolSBDHData peppolSBDHData, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList) throws Exception {
        LOGGER.info("Retrieving the handler service.");
        ISBDHandlerService iSBDHandlerService = SDBHandlerServiceLocator.getService((ESBDHHandlerServiceSelector)ESBDHHandlerServiceSelector.CUSTOM_PEPPOL_INCOMING);
        LOGGER.info("Successfully retrieved the handler service.");
        LOGGER.info("Injecting parameters into the handler service.");
        iSBDHandlerService.setMessageMetadata(iAS4IncomingMessageMetadata);
        iSBDHandlerService.setHttpHeaders(httpHeaderMap);
        iSBDHandlerService.setUserMessage(ebms3UserMessage);
        iSBDHandlerService.setStandardBusinessDocumentBytes(byArray);
        iSBDHandlerService.setStandardBusinessDocument(standardBusinessDocument);
        iSBDHandlerService.setPeppolStandardBusinessDocumentHeader(peppolSBDHData);
        iSBDHandlerService.setMessageState(iAS4IncomingMessageState);
        LOGGER.info("Handling request.");
        iSBDHandlerService.handle();
        LOGGER.info("Request handled with success.");
    }
}

