/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.springboot.spi;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.peppol.sbdh.PeppolSBDHData;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import com.helger.phase4.incoming.IAS4IncomingMessageState;
import com.helger.phase4.peppol.servlet.IPhase4PeppolIncomingSBDHandlerSPI;
import com.helger.phase4.springboot.spi.CustomPeppolIncomingViaInterfaceSPI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocument;

@IsSPIImplementation
public class CustomPeppolIncomingViaInterfaceSPI
implements IPhase4PeppolIncomingSBDHandlerSPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomPeppolIncomingViaInterfaceSPI.class);
    private static IPeppolIncomingHandler s_aHandler = null;

    @Nullable
    public static IPeppolIncomingHandler getIncomingHandler() {
        return s_aHandler;
    }

    public static void setIncomingHandler(@Nullable IPeppolIncomingHandler iPeppolIncomingHandler) {
        if (s_aHandler != null && iPeppolIncomingHandler != null) {
            LOGGER.warn("Overwriting static handler for incoming Peppol messages");
        }
        s_aHandler = iPeppolIncomingHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIncomingSBD(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull byte[] byArray, @Nonnull StandardBusinessDocument standardBusinessDocument, @Nonnull PeppolSBDHData peppolSBDHData, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList) throws Exception {
        if (s_aHandler != null) {
            LOGGER.info("Invoking the registered handler");
            try {
                s_aHandler.handleIncomingSBD(iAS4IncomingMessageMetadata, httpHeaderMap, ebms3UserMessage, byArray, standardBusinessDocument, peppolSBDHData, iAS4IncomingMessageState, iCommonsList);
            }
            finally {
                LOGGER.info("Finished invoking the registered handler");
            }
        } else {
            LOGGER.error("No handler is registered. Make sure to call 'setIncomingHandler' of this class on application startup");
        }
    }
}

