/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql;

import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.db.jdbc.IHasDataSource;
import com.helger.db.jdbc.executor.DBExecutor;
import com.helger.phoss.smp.backend.sql.SMPDataSourceSingleton;
import com.helger.phoss.smp.backend.sql.SMPJDBCConfiguration;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SMPDBExecutor
extends DBExecutor {
    public static final Function<String, String> TABLE_NAME_CUSTOMIZER;
    private static final Logger LOGGER;

    public SMPDBExecutor() {
        super((IHasDataSource)SMPDataSourceSingleton.getInstance().getDataSourceProvider());
        this.setDebugConnections(SMPJDBCConfiguration.isJdbcDebugConnections());
        this.setDebugTransactions(SMPJDBCConfiguration.isJdbcDebugTransaction());
        this.setDebugSQLStatements(SMPJDBCConfiguration.isJdbcDebugSQL());
        if (SMPJDBCConfiguration.isJdbcExecutionTimeWarningEnabled()) {
            long l = SMPJDBCConfiguration.getJdbcExecutionTimeWarningMilliseconds();
            if (l > 0L) {
                this.setExecutionDurationWarnMS(l);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignoring setting 'jdbc.execution-time-warning.ms' because it is invalid.");
            }
        } else {
            this.setExecutionDurationWarnMS(0L);
        }
    }

    static {
        String string3 = SMPJDBCConfiguration.getJdbcSchema();
        TABLE_NAME_CUSTOMIZER = StringHelper.hasText((String)string3) && RegExHelper.stringMatchesPattern((String)"[0-9a-zA-Z]+", (String)string3) ? string2 -> string3 + ".smp_" + string2 : string -> "smp_" + string;
        LOGGER = LoggerFactory.getLogger(SMPDBExecutor.class);
    }
}

