/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql;

import com.helger.db.jdbc.IHasDataSource;
import com.helger.phoss.smp.backend.sql.SMPJDBCConfiguration;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SMPDataSourceProvider
implements IHasDataSource,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPDataSourceProvider.class);
    private final BasicDataSource m_aDataSource = new BasicDataSource();

    SMPDataSourceProvider() {
        String string;
        this.m_aDataSource.setDriverClassName(SMPJDBCConfiguration.getJdbcDriver());
        String string2 = SMPJDBCConfiguration.getJdbcUser();
        if (string2 != null) {
            this.m_aDataSource.setUsername(string2);
        }
        if ((string = SMPJDBCConfiguration.getJdbcPassword()) != null) {
            this.m_aDataSource.setPassword(string);
        }
        this.m_aDataSource.setUrl(SMPJDBCConfiguration.getJdbcUrl());
        this.m_aDataSource.setDefaultAutoCommit(Boolean.FALSE);
        this.m_aDataSource.setPoolPreparedStatements(true);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Created new DataSource " + this.m_aDataSource);
        }
    }

    @Nonnull
    public BasicDataSource getDataSource() {
        return this.m_aDataSource;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.m_aDataSource != null && !this.m_aDataSource.isClosed()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Now closing DataSource");
                }
                this.m_aDataSource.close();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Successfully closed DataSource");
                }
            }
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("Failed to close DataSource " + this.m_aDataSource, sQLException);
        }
    }
}

