/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql;

import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.phoss.smp.backend.sql.EDatabaseType;
import com.helger.phoss.smp.backend.sql.SMPDataSourceProvider;
import com.helger.phoss.smp.backend.sql.SMPJDBCConfiguration;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SMPDataSourceSingleton
extends AbstractGlobalSingleton {
    private static final EDatabaseType DB_TYPE;
    private final SMPDataSourceProvider m_aDSP = new SMPDataSourceProvider();

    @Nonnull
    public static EDatabaseType getDatabaseType() {
        return DB_TYPE;
    }

    @Deprecated
    @UsedViaReflection
    public SMPDataSourceSingleton() {
    }

    @Nonnull
    public static SMPDataSourceSingleton getInstance() {
        return (SMPDataSourceSingleton)SMPDataSourceSingleton.getGlobalSingleton(SMPDataSourceSingleton.class);
    }

    protected void onBeforeDestroy(@Nonnull IScope iScope) throws Exception {
        StreamHelper.close((AutoCloseable)this.m_aDSP);
    }

    @Nonnull
    public SMPDataSourceProvider getDataSourceProvider() {
        return this.m_aDSP;
    }

    static {
        String string = SMPJDBCConfiguration.getTargetDatabaseType();
        DB_TYPE = EDatabaseType.getFromCaseIDInsensitiveOrNull(string);
        if (DB_TYPE == null) {
            throw new IllegalStateException("The database type MUST be provided and MUST be one of " + StringHelper.imploder().source((Object[])EDatabaseType.values(), EDatabaseType::getID).separator(", ").build() + " - provided value is '" + string + "'");
        }
    }
}

