/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql;

import com.helger.commons.annotation.Since;
import com.helger.config.IConfig;
import com.helger.phoss.smp.config.SMPConfigProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SMPJDBCConfiguration {
    private static final String CONFIG_JDBC_DRIVER = "jdbc.driver";
    private static final String CONFIG_JDBC_USER = "jdbc.user";
    private static final String CONFIG_JDBC_PASSWORD = "jdbc.password";
    private static final String CONFIG_JDBC_URL = "jdbc.url";
    @Since(value="5.3.0")
    private static final String CONFIG_JDBC_SCHEMA = "jdbc.schema";
    @Since(value="5.3.0")
    private static final String CONFIG_JDBC_SCHEMA_CREATE = "jdbc.schema-create";
    private static final boolean DEFAULT_JDBC_SCHEMA_CREATE = false;
    private static final String CONFIG_TARGET_DATABASE = "target-database";
    @Since(value="5.0.6")
    private static final String CONFIG_JDBC_EXECUTION_TIME_WARNING_ENABLED = "jdbc.execution-time-warning.enabled";
    private static final boolean DEFAULT_JDBC_EXECUTION_TIME_WARNING_ENABLED = true;
    @Since(value="5.0.6")
    public static final String CONFIG_JDBC_EXECUTION_TIME_WARNING_MS = "jdbc.execution-time-warning.ms";
    @Since(value="5.3.0")
    private static final String CONFIG_JDBC_CACHE_SG_ENABLED = "jdbc.cache.sg.enabled";
    private static final boolean DEFAULT_JDBC_CACHE_SG_ENABLED = true;
    @Since(value="5.3.0")
    private static final String CONFIG_JDBC_DEBUG_CONNECTIONS = "jdbc.debug.connections";
    private static final boolean DEFAULT_JDBC_DEBUG_CONNECTIONS = false;
    @Since(value="5.3.0")
    private static final String CONFIG_JDBC_DEBUG_TRANSACTIONS = "jdbc.debug.transactions";
    private static final boolean DEFAULT_JDBC_DEBUG_TRANSACTIONS = false;
    @Since(value="5.3.0")
    private static final String CONFIG_JDBC_DEBUG_SQL = "jdbc.debug.sql";
    private static final boolean DEFAULT_JDBC_DEBUG_SQL = false;
    @Since(value="5.4.0")
    public static final String CONFIG_SMP_FLYWAY_ENABLED = "smp.flyway.enabled";
    private static final boolean DEFAULT_SMP_FLYWAY_ENABLED = true;
    @Since(value="6.0.0")
    private static final String CONFIG_SMP_FLYWAY_BASELINE_VERSION = "smp.flyway.baseline.version";
    private static final int DEFAULT_SMP_FLYWAY_BASELINE_VERSION = 0;
    private static final SMPJDBCConfiguration INSTANCE = new SMPJDBCConfiguration();

    private SMPJDBCConfiguration() {
    }

    @Nonnull
    private static IConfig _getConfig() {
        return SMPConfigProvider.getConfig();
    }

    @Nullable
    public static String getJdbcDriver() {
        return SMPJDBCConfiguration._getConfig().getAsString((Object)CONFIG_JDBC_DRIVER);
    }

    @Nullable
    public static String getJdbcUser() {
        return SMPJDBCConfiguration._getConfig().getAsString((Object)CONFIG_JDBC_USER);
    }

    @Nullable
    public static String getJdbcPassword() {
        return SMPJDBCConfiguration._getConfig().getAsString((Object)CONFIG_JDBC_PASSWORD);
    }

    @Nullable
    public static String getJdbcUrl() {
        return SMPJDBCConfiguration._getConfig().getAsString((Object)CONFIG_JDBC_URL);
    }

    @Nullable
    public static String getJdbcSchema() {
        return SMPJDBCConfiguration._getConfig().getAsString((Object)CONFIG_JDBC_SCHEMA);
    }

    public static boolean isJdbcSchemaCreate() {
        return SMPJDBCConfiguration._getConfig().getAsBoolean((Object)CONFIG_JDBC_SCHEMA_CREATE, false);
    }

    @Nullable
    public static String getTargetDatabaseType() {
        return SMPJDBCConfiguration._getConfig().getAsString((Object)CONFIG_TARGET_DATABASE);
    }

    public static boolean isJdbcExecutionTimeWarningEnabled() {
        return SMPJDBCConfiguration._getConfig().getAsBoolean((Object)CONFIG_JDBC_EXECUTION_TIME_WARNING_ENABLED, true);
    }

    public static long getJdbcExecutionTimeWarningMilliseconds() {
        return SMPJDBCConfiguration._getConfig().getAsLong((Object)CONFIG_JDBC_EXECUTION_TIME_WARNING_MS, 1000L);
    }

    public static boolean isJdbcServiceGroupCacheEnabled() {
        return SMPJDBCConfiguration._getConfig().getAsBoolean((Object)CONFIG_JDBC_CACHE_SG_ENABLED, true);
    }

    public static boolean isJdbcDebugConnections() {
        return SMPJDBCConfiguration._getConfig().getAsBoolean((Object)CONFIG_JDBC_DEBUG_CONNECTIONS, false);
    }

    public static boolean isJdbcDebugTransaction() {
        return SMPJDBCConfiguration._getConfig().getAsBoolean((Object)CONFIG_JDBC_DEBUG_TRANSACTIONS, false);
    }

    public static boolean isJdbcDebugSQL() {
        return SMPJDBCConfiguration._getConfig().getAsBoolean((Object)CONFIG_JDBC_DEBUG_SQL, false);
    }

    public static boolean isFlywayEnabled() {
        return SMPJDBCConfiguration._getConfig().getAsBoolean((Object)CONFIG_SMP_FLYWAY_ENABLED, true);
    }

    public static int getFlywayBaselineVersion() {
        return SMPJDBCConfiguration._getConfig().getAsInt((Object)CONFIG_SMP_FLYWAY_BASELINE_VERSION, 0);
    }

    public static boolean isStatusEnabled() {
        return SMPJDBCConfiguration._getConfig().getAsBoolean((Object)"smp.status.sql.enabled", true);
    }
}

