/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import com.helger.phoss.smp.backend.sql.EDatabaseType;
import com.helger.phoss.smp.backend.sql.SMPJDBCConfiguration;
import com.helger.phoss.smp.backend.sql.migration.V10__MigrateRolesToDB;
import com.helger.phoss.smp.backend.sql.migration.V11__MigrateUsersToDB;
import com.helger.phoss.smp.backend.sql.migration.V12__MigrateUserGroupsToDB;
import com.helger.phoss.smp.backend.sql.migration.V14__MigrateSettingsToDB;
import com.helger.phoss.smp.backend.sql.migration.V15__MigrateDBUsersToPhotonUsers;
import com.helger.phoss.smp.backend.sql.migration.V2__MigrateDBUsersToPhotonUsers;
import com.helger.phoss.smp.backend.sql.migration.V5__MigrateTransportProfilesToDB;
import com.helger.photon.audit.AuditHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.BaseCallback;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.info.MigrationInfoImpl;
import org.flywaydb.core.internal.jdbc.DriverDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FlywayMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Singleton.class);

    private FlywayMigrator() {
    }

    void runFlyway(@Nonnull EDatabaseType eDatabaseType) {
        ValueEnforcer.notNull((Object)((Object)eDatabaseType), (String)"DBType");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting to run Flyway for DB type " + (Object)((Object)eDatabaseType));
        }
        BaseCallback baseCallback = new BaseCallback(){

            public void handle(@Nonnull Event event, @Nullable Context context) {
                ResolvedMigration resolvedMigration;
                MigrationInfo migrationInfo;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Flyway: Event " + event.getId());
                }
                if (event == Event.AFTER_EACH_MIGRATE && context != null && (migrationInfo = context.getMigrationInfo()) instanceof MigrationInfoImpl && (resolvedMigration = ((MigrationInfoImpl)migrationInfo).getResolvedMigration()) != null && LOGGER.isInfoEnabled()) {
                    LOGGER.info("  Performed migration: " + resolvedMigration);
                }
            }
        };
        BaseCallback baseCallback2 = new BaseCallback(){

            public void handle(@Nonnull Event event, @Nullable Context context) {
                ResolvedMigration resolvedMigration;
                MigrationInfo migrationInfo;
                if (event == Event.AFTER_EACH_MIGRATE && context != null && (migrationInfo = context.getMigrationInfo()) instanceof MigrationInfoImpl && (resolvedMigration = ((MigrationInfoImpl)migrationInfo).getResolvedMigration()) != null && resolvedMigration.getVersion().isAtLeast("7")) {
                    AuditHelper.onAuditExecuteSuccess((String)"sql-migration-success", (Object[])new Object[]{resolvedMigration.getVersion().toString(), resolvedMigration.getDescription(), resolvedMigration.getScript(), resolvedMigration.getType().name(), resolvedMigration.getPhysicalLocation()});
                }
            }
        };
        FluentConfiguration fluentConfiguration = Flyway.configure().dataSource((DataSource)new DriverDataSource(FlywayMigrator.class.getClassLoader(), SMPJDBCConfiguration.getJdbcDriver(), SMPJDBCConfiguration.getJdbcUrl(), SMPJDBCConfiguration.getJdbcUser(), SMPJDBCConfiguration.getJdbcPassword()));
        fluentConfiguration.baselineOnMigrate(true);
        fluentConfiguration.validateOnMigrate(false);
        fluentConfiguration.baselineVersion(Integer.toString(SMPJDBCConfiguration.getFlywayBaselineVersion())).baselineDescription("SMP 5.2.x database layout, MySQL only");
        fluentConfiguration.locations(new String[]{"db/migrate-" + eDatabaseType.getID()});
        fluentConfiguration.javaMigrations(new JavaMigration[]{new V2__MigrateDBUsersToPhotonUsers(), new V5__MigrateTransportProfilesToDB(), new V10__MigrateRolesToDB(), new V11__MigrateUsersToDB(), new V12__MigrateUserGroupsToDB(), new V14__MigrateSettingsToDB(), new V15__MigrateDBUsersToPhotonUsers()});
        fluentConfiguration.callbacks(new Callback[]{baseCallback, baseCallback2});
        String string = SMPJDBCConfiguration.getJdbcSchema();
        if (StringHelper.hasText((String)string)) {
            fluentConfiguration.schemas(new String[]{string});
        }
        fluentConfiguration.createSchemas(SMPJDBCConfiguration.isJdbcSchemaCreate());
        Flyway flyway = fluentConfiguration.load();
        flyway.migrate();
        LOGGER.info("Finished running Flyway");
    }

    @Immutable
    public static final class Singleton {
        static final FlywayMigrator INSTANCE = new FlywayMigrator();

        private Singleton() {
        }
    }
}

