/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.mutable.MutableBoolean;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.type.ObjectType;
import com.helger.db.jdbc.callback.ConstantPreparedStatementDataProvider;
import com.helger.db.jdbc.callback.IPreparedStatementDataProvider;
import com.helger.db.jdbc.executor.DBExecutor;
import com.helger.db.jdbc.executor.DBResultRow;
import com.helger.db.jdbc.mgr.AbstractJDBCEnabledManager;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.json.serialize.IJsonWriterSettings;
import com.helger.json.serialize.JsonReader;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.phoss.smp.domain.SMPMetaManager;
import com.helger.phoss.smp.domain.businesscard.ISMPBusinessCard;
import com.helger.phoss.smp.domain.businesscard.ISMPBusinessCardCallback;
import com.helger.phoss.smp.domain.businesscard.ISMPBusinessCardManager;
import com.helger.phoss.smp.domain.businesscard.SMPBusinessCard;
import com.helger.phoss.smp.domain.businesscard.SMPBusinessCardContact;
import com.helger.phoss.smp.domain.businesscard.SMPBusinessCardEntity;
import com.helger.phoss.smp.domain.businesscard.SMPBusinessCardIdentifier;
import com.helger.phoss.smp.domain.businesscard.SMPBusinessCardName;
import com.helger.photon.audit.AuditHelper;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SMPBusinessCardManagerJDBC
extends AbstractJDBCEnabledManager
implements ISMPBusinessCardManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPBusinessCardManagerJDBC.class);
    private static final IJsonWriterSettings JWS = JsonWriterSettings.DEFAULT_SETTINGS;
    private final CallbackList<ISMPBusinessCardCallback> m_aCBs = new CallbackList();

    public SMPBusinessCardManagerJDBC(@Nonnull Supplier<? extends DBExecutor> supplier) {
        super(supplier);
    }

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<ISMPBusinessCardCallback> bcCallbacks() {
        return this.m_aCBs;
    }

    @Nonnull
    public static IJson getBCIAsJson(@Nullable List<SMPBusinessCardIdentifier> list) {
        JsonArray jsonArray = new JsonArray();
        if (list != null) {
            for (SMPBusinessCardIdentifier sMPBusinessCardIdentifier : list) {
                jsonArray.add((IJson)new JsonObject().add("id", (Object)sMPBusinessCardIdentifier.getID()).add("scheme", (Object)sMPBusinessCardIdentifier.getScheme()).add("value", (Object)sMPBusinessCardIdentifier.getValue()));
            }
        }
        return jsonArray;
    }

    @Nonnull
    public static ICommonsList<SMPBusinessCardIdentifier> getJsonAsBCI(@Nullable String string) {
        IJson iJson;
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        IJson iJson2 = iJson = string == null ? null : JsonReader.readFromString((String)string);
        if (iJson != null && iJson.isArray()) {
            for (IJson iJson3 : iJson.getAsArray()) {
                IJsonObject iJsonObject = iJson3.getAsObject();
                SMPBusinessCardIdentifier sMPBusinessCardIdentifier = new SMPBusinessCardIdentifier(iJsonObject.getAsString((Object)"id"), iJsonObject.getAsString((Object)"scheme"), iJsonObject.getAsString((Object)"value"));
                commonsArrayList.add((Object)sMPBusinessCardIdentifier);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    public static IJson getStringAsJson(@Nullable Iterable<String> iterable) {
        return (IJson)new JsonArray().addAll(iterable);
    }

    @Nonnull
    public static ICommonsList<String> getJsonAsString(@Nullable String string) {
        IJson iJson;
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        IJson iJson2 = iJson = string == null ? null : JsonReader.readFromString((String)string);
        if (iJson != null && iJson.isArray()) {
            for (IJson iJson3 : iJson.getAsArray()) {
                String string2 = iJson3.getAsValue().getAsString();
                commonsArrayList.add((Object)string2);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    public static IJson getBCCAsJson(@Nullable Iterable<SMPBusinessCardContact> iterable) {
        JsonArray jsonArray = new JsonArray();
        if (iterable != null) {
            for (SMPBusinessCardContact sMPBusinessCardContact : iterable) {
                jsonArray.add((IJson)new JsonObject().add("id", (Object)sMPBusinessCardContact.getID()).add("type", (Object)sMPBusinessCardContact.getType()).add("name", (Object)sMPBusinessCardContact.getName()).add("phone", (Object)sMPBusinessCardContact.getPhoneNumber()).add("email", (Object)sMPBusinessCardContact.getEmail()));
            }
        }
        return jsonArray;
    }

    @Nonnull
    public static ICommonsList<SMPBusinessCardContact> getJsonAsBCC(@Nullable String string) {
        IJson iJson;
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        IJson iJson2 = iJson = string == null ? null : JsonReader.readFromString((String)string);
        if (iJson != null && iJson.isArray()) {
            for (IJson iJson3 : iJson.getAsArray()) {
                IJsonObject iJsonObject = iJson3.getAsObject();
                SMPBusinessCardContact sMPBusinessCardContact = new SMPBusinessCardContact(iJsonObject.getAsString((Object)"id"), iJsonObject.getAsString((Object)"type"), iJsonObject.getAsString((Object)"name"), iJsonObject.getAsString((Object)"phone"), iJsonObject.getAsString((Object)"email"));
                commonsArrayList.add((Object)sMPBusinessCardContact);
            }
        }
        return commonsArrayList;
    }

    @Nullable
    public ISMPBusinessCard createOrUpdateSMPBusinessCard(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull Collection<SMPBusinessCardEntity> collection) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notNull(collection, (String)"Entities");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("createOrUpdateSMPBusinessCard (" + iParticipantIdentifier.getURIEncoded() + ", " + collection.size() + " entities)");
        }
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        DBExecutor dBExecutor = this.newExecutor();
        ESuccess eSuccess = dBExecutor.performInTransaction(() -> {
            String string = iParticipantIdentifier.getURIEncoded();
            long l = dBExecutor.insertOrUpdateOrDelete("DELETE FROM smp_bce WHERE pid=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string}));
            if (l > 0L) {
                mutableBoolean.set(true);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.info("Deleted " + l + " existing DBBusinessCardEntity rows");
                }
            }
            for (SMPBusinessCardEntity sMPBusinessCardEntity : collection) {
                String string2;
                String string3;
                if (sMPBusinessCardEntity.isSingleNameWithoutLanguage()) {
                    string3 = ((SMPBusinessCardName)sMPBusinessCardEntity.names().getFirst()).getName();
                    string2 = null;
                } else {
                    string3 = null;
                    string2 = sMPBusinessCardEntity.getNamesAsJson().getAsJsonString();
                }
                dBExecutor.insertOrUpdateOrDelete("INSERT INTO smp_bce (id, pid, name, names, country, geoinfo, identifiers, websites, contacts, addon, regdate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{sMPBusinessCardEntity.getID(), string, string3, string2, sMPBusinessCardEntity.getCountryCode(), sMPBusinessCardEntity.getGeographicalInformation(), SMPBusinessCardManagerJDBC.getBCIAsJson((List<SMPBusinessCardIdentifier>)sMPBusinessCardEntity.identifiers()).getAsJsonString(JWS), SMPBusinessCardManagerJDBC.getStringAsJson((Iterable<String>)sMPBusinessCardEntity.websiteURIs()).getAsJsonString(JWS), SMPBusinessCardManagerJDBC.getBCCAsJson((Iterable<SMPBusinessCardContact>)sMPBusinessCardEntity.contacts()).getAsJsonString(JWS), sMPBusinessCardEntity.getAdditionalInformation(), sMPBusinessCardEntity.getRegistrationDate()}));
            }
        });
        if (eSuccess.isFailure()) {
            if (mutableBoolean.booleanValue()) {
                AuditHelper.onAuditModifyFailure((ObjectType)SMPBusinessCard.OT, (String)"set-all", (Object[])new Object[]{iParticipantIdentifier.getURIEncoded()});
            } else {
                AuditHelper.onAuditCreateFailure((ObjectType)SMPBusinessCard.OT, (Object[])new Object[]{iParticipantIdentifier.getURIEncoded()});
            }
            return null;
        }
        SMPBusinessCard sMPBusinessCard = new SMPBusinessCard(iParticipantIdentifier, collection);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished createOrUpdateSMPBusinessCard");
        }
        if (mutableBoolean.booleanValue()) {
            AuditHelper.onAuditModifySuccess((ObjectType)SMPBusinessCard.OT, (String)"set-all", (Object[])new Object[]{iParticipantIdentifier.getURIEncoded(), collection.size()});
        } else {
            AuditHelper.onAuditCreateSuccess((ObjectType)SMPBusinessCard.OT, (Object[])new Object[]{iParticipantIdentifier.getURIEncoded(), collection.size()});
        }
        this.m_aCBs.forEach(iSMPBusinessCardCallback -> iSMPBusinessCardCallback.onSMPBusinessCardCreatedOrUpdated((ISMPBusinessCard)sMPBusinessCard));
        return sMPBusinessCard;
    }

    @Nonnull
    public EChange deleteSMPBusinessCard(@Nullable ISMPBusinessCard iSMPBusinessCard) {
        long l;
        if (iSMPBusinessCard == null) {
            return EChange.UNCHANGED;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("deleteSMPBusinessCard (" + (String)iSMPBusinessCard.getID() + ")");
        }
        if ((l = this.newExecutor().insertOrUpdateOrDelete("DELETE FROM smp_bce WHERE pid=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iSMPBusinessCard.getID()}))) <= 0L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Finished deleteSMPBusinessCard. Change=false");
            }
            AuditHelper.onAuditDeleteFailure((ObjectType)SMPBusinessCard.OT, (Object[])new Object[]{iSMPBusinessCard.getID(), "no-such-id"});
            return EChange.UNCHANGED;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished deleteSMPBusinessCard. Change=true");
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)SMPBusinessCard.OT, (Object[])new Object[]{iSMPBusinessCard.getID(), iSMPBusinessCard.getEntityCount()});
        this.m_aCBs.forEach(iSMPBusinessCardCallback -> iSMPBusinessCardCallback.onSMPBusinessCardDeleted(iSMPBusinessCard));
        return EChange.CHANGED;
    }

    @Nonnull
    private static EContinue _addNames(@Nonnull SMPBusinessCardEntity sMPBusinessCardEntity, @Nullable String string, @Nullable String string2) {
        if (StringHelper.hasText((String)string2)) {
            IJsonArray iJsonArray = JsonReader.builder().source(string2).readAsArray();
            if (iJsonArray != null) {
                for (IJsonObject iJsonObject : iJsonArray.iteratorObjects()) {
                    SMPBusinessCardName sMPBusinessCardName = SMPBusinessCardName.createFromJson((IJsonObject)iJsonObject);
                    if (sMPBusinessCardName == null) continue;
                    sMPBusinessCardEntity.names().add((Object)sMPBusinessCardName);
                }
            }
            if (sMPBusinessCardEntity.names().isEmpty()) {
                LOGGER.error("The names of a Business Entity retrieved from the DB (" + string2 + ") could not be parsed properly to a JSON array of JSON objects. Ignoring Business Entity.");
                return EContinue.BREAK;
            }
        } else {
            sMPBusinessCardEntity.names().add((Object)new SMPBusinessCardName(string, null));
        }
        return EContinue.CONTINUE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISMPBusinessCard> getAllSMPBusinessCards() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT id, pid, name, names, country, geoinfo, identifiers, websites, contacts, addon, regdate FROM smp_bce");
        if (iCommonsList != null) {
            SMPBusinessCardEntity sMPBusinessCardEntity;
            IIdentifierFactory iIdentifierFactory = SMPMetaManager.getIdentifierFactory();
            CommonsHashMap commonsHashMap = new CommonsHashMap();
            for (Object object : iCommonsList) {
                sMPBusinessCardEntity = new SMPBusinessCardEntity(object.getAsString(0));
                String string = object.getAsString(1);
                IParticipantIdentifier iParticipantIdentifier2 = iIdentifierFactory.parseParticipantIdentifier(string);
                if (iParticipantIdentifier2 == null) {
                    LOGGER.error("The participant identifier of a Business Entity retrieved from the DB (" + string + ") cannot be parsed properly. Ignoring Business Entity.");
                    continue;
                }
                String string2 = object.getAsString(2);
                String string3 = object.getAsString(3);
                SMPBusinessCardManagerJDBC._addNames(sMPBusinessCardEntity, string2, string3);
                sMPBusinessCardEntity.setCountryCode(object.getAsString(4));
                sMPBusinessCardEntity.setGeographicalInformation(object.getAsString(5));
                sMPBusinessCardEntity.identifiers().setAll(SMPBusinessCardManagerJDBC.getJsonAsBCI(object.getAsString(6)));
                sMPBusinessCardEntity.websiteURIs().setAll(SMPBusinessCardManagerJDBC.getJsonAsString(object.getAsString(7)));
                sMPBusinessCardEntity.contacts().setAll(SMPBusinessCardManagerJDBC.getJsonAsBCC(object.getAsString(8)));
                sMPBusinessCardEntity.setAdditionalInformation(object.getAsString(9));
                sMPBusinessCardEntity.setRegistrationDate(object.get(10).getAsLocalDate());
                ((ICommonsList)commonsHashMap.computeIfAbsent((Object)iParticipantIdentifier2, iParticipantIdentifier -> new CommonsArrayList())).add((Object)sMPBusinessCardEntity);
            }
            for (Object object : commonsHashMap.entrySet()) {
                sMPBusinessCardEntity = (IParticipantIdentifier)object.getKey();
                commonsArrayList.add((Object)new SMPBusinessCard((IParticipantIdentifier)sMPBusinessCardEntity, (Iterable)object.getValue()));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllSMPBusinessCardIDs() {
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT pid FROM smp_bce");
        if (iCommonsList != null) {
            for (DBResultRow dBResultRow : iCommonsList) {
                commonsHashSet.add((Object)dBResultRow.getAsString(0));
            }
        }
        return commonsHashSet;
    }

    @Nullable
    public ISMPBusinessCard getSMPBusinessCardOfID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        if (iParticipantIdentifier == null) {
            return null;
        }
        ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT id, name, names, country, geoinfo, identifiers, websites, contacts, addon, regdate FROM smp_bce WHERE pid=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getURIEncoded()}));
        if (iCommonsList == null) {
            return null;
        }
        if (iCommonsList.isEmpty()) {
            return null;
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (DBResultRow dBResultRow : iCommonsList) {
            SMPBusinessCardEntity sMPBusinessCardEntity = new SMPBusinessCardEntity(dBResultRow.getAsString(0));
            String string = dBResultRow.getAsString(1);
            String string2 = dBResultRow.getAsString(2);
            SMPBusinessCardManagerJDBC._addNames(sMPBusinessCardEntity, string, string2);
            sMPBusinessCardEntity.setCountryCode(dBResultRow.getAsString(3));
            sMPBusinessCardEntity.setGeographicalInformation(dBResultRow.getAsString(4));
            sMPBusinessCardEntity.identifiers().setAll(SMPBusinessCardManagerJDBC.getJsonAsBCI(dBResultRow.getAsString(5)));
            sMPBusinessCardEntity.websiteURIs().setAll(SMPBusinessCardManagerJDBC.getJsonAsString(dBResultRow.getAsString(6)));
            sMPBusinessCardEntity.contacts().setAll(SMPBusinessCardManagerJDBC.getJsonAsBCC(dBResultRow.getAsString(7)));
            sMPBusinessCardEntity.setAdditionalInformation(dBResultRow.getAsString(8));
            sMPBusinessCardEntity.setRegistrationDate(dBResultRow.get(9).getAsLocalDate());
            commonsArrayList.add((Object)sMPBusinessCardEntity);
        }
        return new SMPBusinessCard(iParticipantIdentifier, (Iterable)commonsArrayList);
    }

    @Nonnegative
    public long getSMPBusinessCardCount() {
        return this.newExecutor().queryCount("SELECT COUNT (DISTINCT pid) FROM smp_bce");
    }
}

