/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.id.factory.AbstractPersistingLongIDFactory;
import com.helger.commons.mutable.MutableLong;
import com.helger.commons.string.StringParser;
import com.helger.phoss.smp.backend.sql.SMPDBExecutor;
import com.helger.phoss.smp.backend.sql.mgr.SMPSettingsManagerJDBC;
import javax.annotation.Nonnegative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPIDFactoryJDBC
extends AbstractPersistingLongIDFactory {
    public static final int DEFAULT_RESERVE_COUNT = 20;
    public static final String SETTINGS_KEY_LATEST_ID = "latest-id";
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPIDFactoryJDBC.class);
    private final long m_nInitialCount;

    public SMPIDFactoryJDBC(@Nonnegative long l) {
        super(20);
        ValueEnforcer.isGE0((long)l, (String)"InitialCount");
        this.m_nInitialCount = l;
    }

    protected long readAndUpdateIDCounter(@Nonnegative int n) {
        MutableLong mutableLong = new MutableLong(0L);
        SMPDBExecutor sMPDBExecutor = new SMPDBExecutor();
        sMPDBExecutor.performInTransaction(() -> {
            String string = SMPSettingsManagerJDBC.getSettingsValueFromDB(sMPDBExecutor, SETTINGS_KEY_LATEST_ID);
            long l = StringParser.parseLong((String)string, (long)this.m_nInitialCount);
            mutableLong.set(l);
            long l2 = l + (long)n;
            SMPSettingsManagerJDBC.setSettingsValueInDB(sMPDBExecutor, SETTINGS_KEY_LATEST_ID, Long.toString(l2));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Updated SQL ID from " + string + " to " + l2);
            }
        });
        return mutableLong.longValue();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

