/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.mgr;

import com.helger.commons.state.ETriState;
import com.helger.commons.string.ToStringGenerator;
import com.helger.dao.DAOException;
import com.helger.db.jdbc.executor.DBExecutor;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.phoss.smp.backend.sql.EDatabaseType;
import com.helger.phoss.smp.backend.sql.SMPDBExecutor;
import com.helger.phoss.smp.backend.sql.SMPDataSourceSingleton;
import com.helger.phoss.smp.backend.sql.SMPJDBCConfiguration;
import com.helger.phoss.smp.backend.sql.mgr.FlywayMigrator;
import com.helger.phoss.smp.backend.sql.mgr.SMPBusinessCardManagerJDBC;
import com.helger.phoss.smp.backend.sql.mgr.SMPParticipantMigrationManagerJDBC;
import com.helger.phoss.smp.backend.sql.mgr.SMPRedirectManagerJDBC;
import com.helger.phoss.smp.backend.sql.mgr.SMPServiceGroupManagerJDBC;
import com.helger.phoss.smp.backend.sql.mgr.SMPServiceInformationManagerJDBC;
import com.helger.phoss.smp.backend.sql.mgr.SMPSettingsManagerJDBC;
import com.helger.phoss.smp.backend.sql.mgr.SMPTransportProfileManagerJDBC;
import com.helger.phoss.smp.domain.ISMPManagerProvider;
import com.helger.phoss.smp.domain.SMPMetaManager;
import com.helger.phoss.smp.domain.businesscard.ISMPBusinessCardManager;
import com.helger.phoss.smp.domain.pmigration.ISMPParticipantMigrationManager;
import com.helger.phoss.smp.domain.redirect.ISMPRedirectManager;
import com.helger.phoss.smp.domain.servicegroup.ISMPServiceGroupManager;
import com.helger.phoss.smp.domain.serviceinfo.ISMPServiceInformationManager;
import com.helger.phoss.smp.domain.sml.ISMLInfoManager;
import com.helger.phoss.smp.domain.sml.SMLInfoManagerXML;
import com.helger.phoss.smp.domain.transportprofile.ISMPTransportProfileManager;
import com.helger.phoss.smp.settings.ISMPSettingsManager;
import com.helger.photon.jdbc.PhotonSecurityManagerFactoryJDBC;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SMPManagerProviderSQL
implements ISMPManagerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPManagerProviderSQL.class);
    private static final String SML_INFO_XML = "sml-info.xml";
    private final EDatabaseType m_eDBType = SMPDataSourceSingleton.getDatabaseType();

    public void beforeInitManagers() {
        PhotonSecurityManagerFactoryJDBC.install(SMPDBExecutor::new, SMPDBExecutor.TABLE_NAME_CUSTOMIZER);
        if (SMPJDBCConfiguration.isFlywayEnabled()) {
            FlywayMigrator.Singleton.INSTANCE.runFlyway(this.m_eDBType);
        } else {
            LOGGER.warn("Flyway Migration is disabled according to the configuration item smp.flyway.enabled");
        }
        DBExecutor.setConnectionStatusChangeCallback((eTriState, eTriState2) -> SMPMetaManager.getInstance().setBackendConnectionState(eTriState2, false));
        SMPMetaManager.getInstance().setBackendConnectionStateChangeCallback(eTriState -> DBExecutor.resetConnectionEstablished());
    }

    @Nonnull
    public ETriState getBackendConnectionEstablishedDefaultState() {
        return ETriState.UNDEFINED;
    }

    @Nonnull
    public ISMLInfoManager createSMLInfoMgr() {
        try {
            return new SMLInfoManagerXML(SML_INFO_XML);
        }
        catch (DAOException dAOException) {
            throw new IllegalStateException(dAOException.getMessage(), dAOException);
        }
    }

    @Nonnull
    public ISMPSettingsManager createSettingsMgr() {
        return new SMPSettingsManagerJDBC(SMPDBExecutor::new);
    }

    @Nonnull
    public ISMPTransportProfileManager createTransportProfileMgr() {
        return new SMPTransportProfileManagerJDBC(SMPDBExecutor::new);
    }

    @Nonnull
    public ISMPServiceGroupManager createServiceGroupMgr() {
        SMPServiceGroupManagerJDBC sMPServiceGroupManagerJDBC = new SMPServiceGroupManagerJDBC(SMPDBExecutor::new);
        sMPServiceGroupManagerJDBC.setCacheEnabled(SMPJDBCConfiguration.isJdbcServiceGroupCacheEnabled());
        return sMPServiceGroupManagerJDBC;
    }

    @Nonnull
    public ISMPRedirectManager createRedirectMgr(@Nonnull IIdentifierFactory iIdentifierFactory, @Nonnull ISMPServiceGroupManager iSMPServiceGroupManager) {
        return new SMPRedirectManagerJDBC(SMPDBExecutor::new, iSMPServiceGroupManager);
    }

    @Nonnull
    public ISMPServiceInformationManager createServiceInformationMgr(@Nonnull IIdentifierFactory iIdentifierFactory, @Nonnull ISMPServiceGroupManager iSMPServiceGroupManager) {
        return new SMPServiceInformationManagerJDBC(SMPDBExecutor::new, iSMPServiceGroupManager);
    }

    @Nonnull
    public ISMPParticipantMigrationManager createParticipantMigrationMgr() {
        return new SMPParticipantMigrationManagerJDBC(SMPDBExecutor::new);
    }

    @Nullable
    public ISMPBusinessCardManager createBusinessCardMgr(@Nonnull IIdentifierFactory iIdentifierFactory, @Nonnull ISMPServiceGroupManager iSMPServiceGroupManager) {
        return new SMPBusinessCardManagerJDBC(SMPDBExecutor::new);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("DBType", (Enum)this.m_eDBType).getToString();
    }
}

