/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.mutable.MutableLong;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.type.ObjectType;
import com.helger.commons.wrapper.Wrapper;
import com.helger.db.api.helper.DBValueHelper;
import com.helger.db.jdbc.callback.ConstantPreparedStatementDataProvider;
import com.helger.db.jdbc.callback.IPreparedStatementDataProvider;
import com.helger.db.jdbc.executor.DBExecutor;
import com.helger.db.jdbc.executor.DBResultRow;
import com.helger.db.jdbc.mgr.AbstractJDBCEnabledManager;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.phoss.smp.domain.SMPMetaManager;
import com.helger.phoss.smp.domain.pmigration.EParticipantMigrationDirection;
import com.helger.phoss.smp.domain.pmigration.EParticipantMigrationState;
import com.helger.phoss.smp.domain.pmigration.ISMPParticipantMigration;
import com.helger.phoss.smp.domain.pmigration.ISMPParticipantMigrationManager;
import com.helger.phoss.smp.domain.pmigration.SMPParticipantMigration;
import com.helger.photon.audit.AuditHelper;
import java.time.LocalDateTime;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SMPParticipantMigrationManagerJDBC
extends AbstractJDBCEnabledManager
implements ISMPParticipantMigrationManager {
    public SMPParticipantMigrationManagerJDBC(@Nonnull Supplier<? extends DBExecutor> supplier) {
        super(supplier);
    }

    @Nullable
    private ISMPParticipantMigration _createParticipantMigration(@Nonnull SMPParticipantMigration sMPParticipantMigration) {
        ValueEnforcer.notNull((Object)sMPParticipantMigration, (String)"SMPParticipantMigration");
        DBExecutor dBExecutor = this.newExecutor();
        ESuccess eSuccess = dBExecutor.performInTransaction(() -> {
            long l = dBExecutor.insertOrUpdateOrDelete("INSERT INTO smp_pmigration (id, direction, state, pid, initdt, migkey) VALUES (?, ?, ?, ?, ?, ?)", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{sMPParticipantMigration.getID(), sMPParticipantMigration.getDirection().getID(), sMPParticipantMigration.getState().getID(), sMPParticipantMigration.getParticipantIdentifier().getURIEncoded(), DBValueHelper.toTimestamp((LocalDateTime)sMPParticipantMigration.getInitiationDateTime()), sMPParticipantMigration.getMigrationKey()}));
            if (l != 1L) {
                throw new IllegalStateException("Failed to create new DB entry (" + l + ")");
            }
        });
        if (eSuccess.isFailure()) {
            AuditHelper.onAuditCreateFailure((ObjectType)SMPParticipantMigration.OT, (Object[])new Object[]{sMPParticipantMigration.getID(), "database-error"});
            return null;
        }
        AuditHelper.onAuditCreateSuccess((ObjectType)SMPParticipantMigration.OT, (Object[])new Object[]{sMPParticipantMigration.getID(), sMPParticipantMigration.getDirection(), sMPParticipantMigration.getParticipantIdentifier().getURIEncoded(), sMPParticipantMigration.getInitiationDateTime(), sMPParticipantMigration.getMigrationKey()});
        return sMPParticipantMigration;
    }

    @Nullable
    public ISMPParticipantMigration createOutboundParticipantMigration(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) {
        SMPParticipantMigration sMPParticipantMigration = SMPParticipantMigration.createOutbound((IParticipantIdentifier)iParticipantIdentifier, (String)string);
        return this._createParticipantMigration(sMPParticipantMigration);
    }

    @Nullable
    public ISMPParticipantMigration createInboundParticipantMigration(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) {
        SMPParticipantMigration sMPParticipantMigration = SMPParticipantMigration.createInbound((IParticipantIdentifier)iParticipantIdentifier, (String)string);
        return this._createParticipantMigration(sMPParticipantMigration);
    }

    @Nonnull
    public EChange deleteParticipantMigrationOfID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return EChange.UNCHANGED;
        }
        long l = this.newExecutor().insertOrUpdateOrDelete("DELETE FROM smp_pmigration WHERE id=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string}));
        if (l == 0L) {
            AuditHelper.onAuditDeleteFailure((ObjectType)SMPParticipantMigration.OT, (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)SMPParticipantMigration.OT, (Object[])new Object[]{string});
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange deleteAllParticipantMigrationsOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        long l = this.newExecutor().insertOrUpdateOrDelete("DELETE FROM smp_pmigration WHERE pid=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getURIEncoded()}));
        if (l == 0L) {
            AuditHelper.onAuditDeleteFailure((ObjectType)SMPParticipantMigration.OT, (Object[])new Object[]{iParticipantIdentifier.getURIEncoded(), "no-such-participant-id"});
            return EChange.UNCHANGED;
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)SMPParticipantMigration.OT, (Object[])new Object[]{iParticipantIdentifier.getURIEncoded()});
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange setParticipantMigrationState(@Nullable String string, @Nonnull EParticipantMigrationState eParticipantMigrationState) {
        ValueEnforcer.notNull((Object)eParticipantMigrationState, (String)"NewState");
        MutableLong mutableLong = new MutableLong(-1L);
        DBExecutor dBExecutor = this.newExecutor();
        ESuccess eSuccess = dBExecutor.performInTransaction(() -> {
            long l = dBExecutor.insertOrUpdateOrDelete("UPDATE smp_pmigration SET state=? WHERE id=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{eParticipantMigrationState.getID(), string}));
            mutableLong.set(l);
        });
        if (eSuccess.isFailure()) {
            AuditHelper.onAuditModifyFailure((ObjectType)SMPParticipantMigration.OT, (String)"set-migration-state", (Object[])new Object[]{string, eParticipantMigrationState, "database-error"});
            return EChange.UNCHANGED;
        }
        if (mutableLong.is0()) {
            AuditHelper.onAuditModifyFailure((ObjectType)SMPParticipantMigration.OT, (String)"set-migration-state", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        AuditHelper.onAuditModifySuccess((ObjectType)SMPParticipantMigration.OT, (String)"set-migration-state", (Object[])new Object[]{string, eParticipantMigrationState});
        return EChange.CHANGED;
    }

    @Nullable
    public SMPParticipantMigration getParticipantMigrationOfID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        Wrapper wrapper = new Wrapper();
        this.newExecutor().querySingle("SELECT direction, state, pid, initdt, migkey FROM smp_pmigration WHERE id=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string}), arg_0 -> ((Wrapper)wrapper).set(arg_0));
        if (wrapper.isNotSet()) {
            return null;
        }
        DBResultRow dBResultRow = (DBResultRow)wrapper.get();
        EParticipantMigrationDirection eParticipantMigrationDirection = EParticipantMigrationDirection.getFromIDOrNull((String)dBResultRow.getAsString(0));
        EParticipantMigrationState eParticipantMigrationState = EParticipantMigrationState.getFromIDOrNull((String)dBResultRow.getAsString(1));
        IParticipantIdentifier iParticipantIdentifier = SMPMetaManager.getIdentifierFactory().parseParticipantIdentifier(dBResultRow.getAsString(2));
        return new SMPParticipantMigration(string, eParticipantMigrationDirection, eParticipantMigrationState, iParticipantIdentifier, dBResultRow.getAsLocalDateTime(3), dBResultRow.getAsString(4));
    }

    @Nullable
    public ISMPParticipantMigration getParticipantMigrationOfParticipantID(@Nonnull EParticipantMigrationDirection eParticipantMigrationDirection, @Nonnull EParticipantMigrationState eParticipantMigrationState, @Nullable IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)eParticipantMigrationDirection, (String)"Direction");
        ValueEnforcer.notNull((Object)eParticipantMigrationState, (String)"State");
        if (iParticipantIdentifier == null) {
            return null;
        }
        Wrapper wrapper = new Wrapper();
        this.newExecutor().querySingle("SELECT id, initdt, migkey FROM smp_pmigration WHERE direction=? AND state=? AND pid=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{eParticipantMigrationDirection.getID(), eParticipantMigrationState.getID(), iParticipantIdentifier.getURIEncoded()}), arg_0 -> ((Wrapper)wrapper).set(arg_0));
        if (wrapper.isNotSet()) {
            return null;
        }
        DBResultRow dBResultRow = (DBResultRow)wrapper.get();
        return new SMPParticipantMigration(dBResultRow.getAsString(0), eParticipantMigrationDirection, eParticipantMigrationState, iParticipantIdentifier, dBResultRow.getAsLocalDateTime(1), dBResultRow.getAsString(2));
    }

    @Nonnull
    @ReturnsMutableCopy
    private ICommonsList<ISMPParticipantMigration> _getAllParticipantMigrations(@Nonnull EParticipantMigrationDirection eParticipantMigrationDirection, @Nullable EParticipantMigrationState eParticipantMigrationState) {
        CommonsArrayList commonsArrayList;
        block4: {
            block3: {
                commonsArrayList = new CommonsArrayList();
                if (eParticipantMigrationState != null) break block3;
                ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT id, state, pid, initdt, migkey FROM smp_pmigration WHERE direction=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{eParticipantMigrationDirection.getID()}));
                if (iCommonsList == null) break block4;
                for (DBResultRow dBResultRow : iCommonsList) {
                    EParticipantMigrationState eParticipantMigrationState2 = EParticipantMigrationState.getFromIDOrNull((String)dBResultRow.getAsString(1));
                    IParticipantIdentifier iParticipantIdentifier = SMPMetaManager.getIdentifierFactory().parseParticipantIdentifier(dBResultRow.getAsString(2));
                    commonsArrayList.add((Object)new SMPParticipantMigration(dBResultRow.getAsString(0), eParticipantMigrationDirection, eParticipantMigrationState2, iParticipantIdentifier, dBResultRow.getAsLocalDateTime(3), dBResultRow.getAsString(4)));
                }
                break block4;
            }
            ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT id, pid, initdt, migkey FROM smp_pmigration WHERE direction=? AND state=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{eParticipantMigrationDirection.getID(), eParticipantMigrationState.getID()}));
            if (iCommonsList != null) {
                for (DBResultRow dBResultRow : iCommonsList) {
                    IParticipantIdentifier iParticipantIdentifier = SMPMetaManager.getIdentifierFactory().parseParticipantIdentifier(dBResultRow.getAsString(1));
                    commonsArrayList.add((Object)new SMPParticipantMigration(dBResultRow.getAsString(0), eParticipantMigrationDirection, eParticipantMigrationState, iParticipantIdentifier, dBResultRow.getAsLocalDateTime(2), dBResultRow.getAsString(3)));
                }
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISMPParticipantMigration> getAllOutboundParticipantMigrations(@Nullable EParticipantMigrationState eParticipantMigrationState) {
        return this._getAllParticipantMigrations(EParticipantMigrationDirection.OUTBOUND, eParticipantMigrationState);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISMPParticipantMigration> getAllInboundParticipantMigrations(@Nullable EParticipantMigrationState eParticipantMigrationState) {
        return this._getAllParticipantMigrations(EParticipantMigrationDirection.INBOUND, eParticipantMigrationState);
    }

    private boolean _containsMigration(@Nonnull EParticipantMigrationDirection eParticipantMigrationDirection, @Nonnull EParticipantMigrationState eParticipantMigrationState, @Nullable IParticipantIdentifier iParticipantIdentifier) {
        if (iParticipantIdentifier == null) {
            return false;
        }
        return this.newExecutor().queryCount("SELECT COUNT(*) FROM smp_pmigration WHERE direction=? AND state=? AND pid=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{eParticipantMigrationDirection.getID(), eParticipantMigrationState.getID(), iParticipantIdentifier.getURIEncoded()})) > 0L;
    }

    public boolean containsOutboundMigrationInProgress(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        return this._containsMigration(EParticipantMigrationDirection.OUTBOUND, EParticipantMigrationState.IN_PROGRESS, iParticipantIdentifier);
    }

    public boolean containsInboundMigration(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        return this._containsMigration(EParticipantMigrationDirection.INBOUND, EParticipantMigrationState.MIGRATED, iParticipantIdentifier);
    }
}

