/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.mutable.MutableBoolean;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.commons.type.ObjectType;
import com.helger.commons.wrapper.Wrapper;
import com.helger.db.jdbc.callback.ConstantPreparedStatementDataProvider;
import com.helger.db.jdbc.callback.IPreparedStatementDataProvider;
import com.helger.db.jdbc.executor.DBExecutor;
import com.helger.db.jdbc.executor.DBResultRow;
import com.helger.db.jdbc.mgr.AbstractJDBCEnabledManager;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.simple.doctype.SimpleDocumentTypeIdentifier;
import com.helger.peppolid.simple.participant.SimpleParticipantIdentifier;
import com.helger.phoss.smp.domain.redirect.ISMPRedirect;
import com.helger.phoss.smp.domain.redirect.ISMPRedirectCallback;
import com.helger.phoss.smp.domain.redirect.ISMPRedirectManager;
import com.helger.phoss.smp.domain.redirect.SMPRedirect;
import com.helger.phoss.smp.domain.servicegroup.ISMPServiceGroup;
import com.helger.phoss.smp.domain.servicegroup.ISMPServiceGroupManager;
import com.helger.photon.audit.AuditHelper;
import com.helger.security.certificate.CertificateHelper;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SMPRedirectManagerJDBC
extends AbstractJDBCEnabledManager
implements ISMPRedirectManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPRedirectManagerJDBC.class);
    private final ISMPServiceGroupManager m_aServiceGroupMgr;
    private final CallbackList<ISMPRedirectCallback> m_aCallbacks = new CallbackList();

    public SMPRedirectManagerJDBC(@Nonnull Supplier<? extends DBExecutor> supplier, @Nonnull ISMPServiceGroupManager iSMPServiceGroupManager) {
        super(supplier);
        this.m_aServiceGroupMgr = iSMPServiceGroupManager;
    }

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<ISMPRedirectCallback> redirectCallbacks() {
        return this.m_aCallbacks;
    }

    @Nullable
    public ISMPRedirect createOrUpdateSMPRedirect(@Nonnull ISMPServiceGroup iSMPServiceGroup, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable X509Certificate x509Certificate, @Nullable String string3) {
        ValueEnforcer.notNull((Object)iSMPServiceGroup, (String)"ServiceGroup");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeIdentifier");
        MutableBoolean mutableBoolean = new MutableBoolean(true);
        DBExecutor dBExecutor = this.newExecutor();
        ESuccess eSuccess = dBExecutor.performInTransaction(() -> {
            String string4;
            ISMPRedirect iSMPRedirect = this.getSMPRedirectOfServiceGroupAndDocumentType(iSMPServiceGroup, iDocumentTypeIdentifier);
            IParticipantIdentifier iParticipantIdentifier = iSMPServiceGroup.getParticipantIdentifier();
            String string5 = string4 = x509Certificate == null ? null : CertificateHelper.getPEMEncodedCertificate((Certificate)x509Certificate);
            if (iSMPRedirect == null) {
                long l = dBExecutor.insertOrUpdateOrDelete("INSERT INTO smp_service_metadata_red (businessIdentifierScheme, businessIdentifier, documentIdentifierScheme, documentIdentifier, redirectionUrl, certificateUID, certificate, extension) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue(), string, string2, string4, string3}));
                if (l != 1L) {
                    throw new IllegalStateException("Failed to create new DB entry (" + l + ")");
                }
                mutableBoolean.set(true);
            } else {
                long l = dBExecutor.insertOrUpdateOrDelete("UPDATE smp_service_metadata_red SET redirectionUrl=?, certificateUID=?, certificate=?, extension=? WHERE businessIdentifierScheme=? AND businessIdentifier=? AND documentIdentifierScheme=? AND documentIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string, string2, string4, string3, iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue()}));
                if (l != 1L) {
                    throw new IllegalStateException("Failed to update existing DB entry (" + l + ")");
                }
                mutableBoolean.set(false);
            }
        });
        if (eSuccess.isFailure()) {
            return null;
        }
        SMPRedirect sMPRedirect = new SMPRedirect(iSMPServiceGroup, iDocumentTypeIdentifier, string, string2, x509Certificate, string3);
        if (mutableBoolean.booleanValue()) {
            AuditHelper.onAuditCreateSuccess((ObjectType)SMPRedirect.OT, (Object[])new Object[]{sMPRedirect.getID(), sMPRedirect.getServiceGroupID(), sMPRedirect.getDocumentTypeIdentifier().getURIEncoded(), sMPRedirect.getTargetHref(), sMPRedirect.getSubjectUniqueIdentifier(), sMPRedirect.getCertificate(), sMPRedirect.getExtensions().getExtensionsAsJsonString()});
            this.m_aCallbacks.forEach(iSMPRedirectCallback -> iSMPRedirectCallback.onSMPRedirectCreated((ISMPRedirect)sMPRedirect));
        } else {
            AuditHelper.onAuditModifySuccess((ObjectType)SMPRedirect.OT, (String)"set-all", (Object[])new Object[]{sMPRedirect.getID(), sMPRedirect.getServiceGroupID(), sMPRedirect.getDocumentTypeIdentifier().getURIEncoded(), sMPRedirect.getTargetHref(), sMPRedirect.getSubjectUniqueIdentifier(), sMPRedirect.getCertificate(), sMPRedirect.getExtensions().getExtensionsAsJsonString()});
            this.m_aCallbacks.forEach(iSMPRedirectCallback -> iSMPRedirectCallback.onSMPRedirectUpdated((ISMPRedirect)sMPRedirect));
        }
        return sMPRedirect;
    }

    @Nonnull
    public EChange deleteSMPRedirect(@Nullable ISMPRedirect iSMPRedirect) {
        if (iSMPRedirect == null) {
            return EChange.UNCHANGED;
        }
        IParticipantIdentifier iParticipantIdentifier = iSMPRedirect.getServiceGroup().getParticipantIdentifier();
        IDocumentTypeIdentifier iDocumentTypeIdentifier = iSMPRedirect.getDocumentTypeIdentifier();
        long l = this.newExecutor().insertOrUpdateOrDelete("DELETE FROM smp_service_metadata_red WHERE businessIdentifierScheme=? AND businessIdentifier=? AND documentIdentifierScheme=? and documentIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue()}));
        if (l == 0L) {
            AuditHelper.onAuditDeleteFailure((ObjectType)SMPRedirect.OT, (Object[])new Object[]{iSMPRedirect.getID(), "no-such-id"});
            return EChange.UNCHANGED;
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)SMPRedirect.OT, (Object[])new Object[]{iSMPRedirect.getID(), iSMPRedirect.getServiceGroupID(), iSMPRedirect.getDocumentTypeIdentifier().getURIEncoded()});
        this.m_aCallbacks.forEach(iSMPRedirectCallback -> iSMPRedirectCallback.onSMPRedirectDeleted(iSMPRedirect));
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange deleteAllSMPRedirectsOfServiceGroup(@Nullable ISMPServiceGroup iSMPServiceGroup) {
        if (iSMPServiceGroup == null) {
            return EChange.UNCHANGED;
        }
        ICommonsList<ISMPRedirect> iCommonsList = this.getAllSMPRedirectsOfServiceGroup(iSMPServiceGroup);
        IParticipantIdentifier iParticipantIdentifier = iSMPServiceGroup.getParticipantIdentifier();
        long l = this.newExecutor().insertOrUpdateOrDelete("DELETE FROM smp_service_metadata_red WHERE businessIdentifierScheme=? AND businessIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue()}));
        if (l == 0L) {
            return EChange.UNCHANGED;
        }
        if (l == (long)iCommonsList.size()) {
            for (ISMPRedirect iSMPRedirect : iCommonsList) {
                AuditHelper.onAuditDeleteSuccess((ObjectType)SMPRedirect.OT, (Object[])new Object[]{iSMPRedirect.getID(), iSMPRedirect.getServiceGroupID(), iSMPRedirect.getDocumentTypeIdentifier().getURIEncoded()});
                this.m_aCallbacks.forEach(iSMPRedirectCallback -> iSMPRedirectCallback.onSMPRedirectDeleted(iSMPRedirect));
            }
        } else {
            LOGGER.warn(l + " SMP redirects were deleted, but " + iCommonsList.size() + " were found previously. Because of this inconsistency, no callbacks are triggered");
        }
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISMPRedirect> getAllSMPRedirects() {
        ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT businessIdentifierScheme, businessIdentifier, documentIdentifierScheme, documentIdentifier, redirectionUrl, certificateUID, certificate, extension FROM smp_service_metadata_red");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iCommonsList != null) {
            for (DBResultRow dBResultRow : iCommonsList) {
                ISMPServiceGroup iSMPServiceGroup = this.m_aServiceGroupMgr.getSMPServiceGroupOfID((IParticipantIdentifier)new SimpleParticipantIdentifier(dBResultRow.getAsString(0), dBResultRow.getAsString(1)));
                X509Certificate x509Certificate = CertificateHelper.convertStringToCertficateOrNull((String)dBResultRow.getAsString(6));
                commonsArrayList.add((Object)new SMPRedirect(iSMPServiceGroup, (IDocumentTypeIdentifier)new SimpleDocumentTypeIdentifier(dBResultRow.getAsString(2), dBResultRow.getAsString(3)), dBResultRow.getAsString(4), dBResultRow.getAsString(5), x509Certificate, dBResultRow.getAsString(7)));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISMPRedirect> getAllSMPRedirectsOfServiceGroup(@Nullable ISMPServiceGroup iSMPServiceGroup) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iSMPServiceGroup != null) {
            IParticipantIdentifier iParticipantIdentifier = iSMPServiceGroup.getParticipantIdentifier();
            ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT documentIdentifierScheme, documentIdentifier, redirectionUrl, certificateUID, certificate, extension FROM smp_service_metadata_red WHERE businessIdentifierScheme=? AND businessIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue()}));
            if (iCommonsList != null) {
                for (DBResultRow dBResultRow : iCommonsList) {
                    X509Certificate x509Certificate = CertificateHelper.convertStringToCertficateOrNull((String)dBResultRow.getAsString(4));
                    commonsArrayList.add((Object)new SMPRedirect(iSMPServiceGroup, (IDocumentTypeIdentifier)new SimpleDocumentTypeIdentifier(dBResultRow.getAsString(0), dBResultRow.getAsString(1)), dBResultRow.getAsString(2), dBResultRow.getAsString(3), x509Certificate, dBResultRow.getAsString(5)));
                }
            }
        }
        return commonsArrayList;
    }

    @Nonnegative
    public long getSMPRedirectCount() {
        return this.newExecutor().queryCount("SELECT COUNT(*) FROM smp_service_metadata_red");
    }

    @Nullable
    public ISMPRedirect getSMPRedirectOfServiceGroupAndDocumentType(@Nullable ISMPServiceGroup iSMPServiceGroup, @Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        if (iSMPServiceGroup == null) {
            return null;
        }
        if (iDocumentTypeIdentifier == null) {
            return null;
        }
        IParticipantIdentifier iParticipantIdentifier = iSMPServiceGroup.getParticipantIdentifier();
        Wrapper wrapper = new Wrapper();
        this.newExecutor().querySingle("SELECT redirectionUrl, certificateUID, certificate, extension FROM smp_service_metadata_red WHERE businessIdentifierScheme=? AND businessIdentifier=? AND documentIdentifierScheme=? and documentIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue()}), arg_0 -> ((Wrapper)wrapper).set(arg_0));
        if (wrapper.isNotSet()) {
            return null;
        }
        DBResultRow dBResultRow = (DBResultRow)wrapper.get();
        X509Certificate x509Certificate = CertificateHelper.convertStringToCertficateOrNull((String)dBResultRow.getAsString(2));
        return new SMPRedirect(iSMPServiceGroup, iDocumentTypeIdentifier, dBResultRow.getAsString(0), dBResultRow.getAsString(1), x509Certificate, dBResultRow.getAsString(3));
    }
}

