/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.mutable.MutableBoolean;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.type.ObjectType;
import com.helger.commons.wrapper.Wrapper;
import com.helger.db.jdbc.callback.ConstantPreparedStatementDataProvider;
import com.helger.db.jdbc.callback.IPreparedStatementDataProvider;
import com.helger.db.jdbc.executor.DBExecutor;
import com.helger.db.jdbc.executor.DBResultRow;
import com.helger.db.jdbc.mgr.AbstractJDBCEnabledManager;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.simple.participant.SimpleParticipantIdentifier;
import com.helger.phoss.smp.domain.servicegroup.ISMPServiceGroup;
import com.helger.phoss.smp.domain.servicegroup.ISMPServiceGroupCallback;
import com.helger.phoss.smp.domain.servicegroup.ISMPServiceGroupManager;
import com.helger.phoss.smp.domain.servicegroup.SMPServiceGroup;
import com.helger.phoss.smp.exception.SMPInternalErrorException;
import com.helger.phoss.smp.exception.SMPNotFoundException;
import com.helger.phoss.smp.exception.SMPSMLException;
import com.helger.phoss.smp.exception.SMPServerException;
import com.helger.phoss.smp.smlhook.IRegistrationHook;
import com.helger.phoss.smp.smlhook.RegistrationHookException;
import com.helger.phoss.smp.smlhook.RegistrationHookFactory;
import com.helger.photon.audit.AuditHelper;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SMPServiceGroupManagerJDBC
extends AbstractJDBCEnabledManager
implements ISMPServiceGroupManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPServiceGroupManagerJDBC.class);
    private final CallbackList<ISMPServiceGroupCallback> m_aCBs = new CallbackList();
    private ExpiringMap<String, SMPServiceGroup> m_aCache;

    public SMPServiceGroupManagerJDBC(@Nonnull Supplier<? extends DBExecutor> supplier) {
        super(supplier);
    }

    public boolean isCacheEnabled() {
        return this.m_aCache != null;
    }

    public void setCacheEnabled(boolean bl) {
        this.m_aCache = bl ? ExpiringMap.builder().expiration(60L, TimeUnit.SECONDS).expirationPolicy(ExpirationPolicy.CREATED).build() : null;
    }

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<ISMPServiceGroupCallback> serviceGroupCallbacks() {
        return this.m_aCBs;
    }

    @Nonnull
    public SMPServiceGroup createSMPServiceGroup(@Nonnull @Nonempty String string, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string2, boolean bl) throws SMPServerException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"OwnerID");
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("createSMPServiceGroup (" + string + ", " + iParticipantIdentifier.getURIEncoded() + ", " + (StringHelper.hasText((String)string2) ? "with extension" : "without extension") + ", " + bl + ")");
        }
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        MutableBoolean mutableBoolean2 = new MutableBoolean(false);
        IRegistrationHook iRegistrationHook = RegistrationHookFactory.getInstance();
        Wrapper wrapper = new Wrapper();
        DBExecutor dBExecutor = this.newExecutor();
        ESuccess eSuccess = dBExecutor.performInTransaction(() -> {
            SMPServiceGroup sMPServiceGroup = this.getSMPServiceGroupOfID(iParticipantIdentifier);
            if (sMPServiceGroup != null) {
                throw new IllegalStateException("The service group with ID " + iParticipantIdentifier.getURIEncoded() + " already exists!");
            }
            if (bl) {
                iRegistrationHook.createServiceGroup(iParticipantIdentifier);
                mutableBoolean.set(true);
            }
            if (dBExecutor.insertOrUpdateOrDelete("INSERT INTO smp_service_group (businessIdentifierScheme, businessIdentifier, extension) VALUES (?, ?, ?)", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), string2})) > 0L) {
                mutableBoolean2.set(true);
                dBExecutor.insertOrUpdateOrDelete("INSERT INTO smp_ownership (businessIdentifierScheme, businessIdentifier, username) VALUES (?, ?, ?)", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), string}));
            }
        }, arg_0 -> ((Wrapper)wrapper).set(arg_0));
        if (mutableBoolean.booleanValue() && !mutableBoolean2.booleanValue()) {
            try {
                iRegistrationHook.undoCreateServiceGroup(iParticipantIdentifier);
            }
            catch (RegistrationHookException registrationHookException) {
                LOGGER.error("Failed to undoCreateServiceGroup (" + iParticipantIdentifier.getURIEncoded() + ")", (Throwable)registrationHookException);
            }
        }
        if (eSuccess.isFailure() || wrapper.isSet() || !mutableBoolean2.booleanValue()) {
            AuditHelper.onAuditCreateFailure((ObjectType)SMPServiceGroup.OT, (Object[])new Object[]{iParticipantIdentifier.getURIEncoded(), string, string2, bl});
            Exception exception = (Exception)wrapper.get();
            if (exception instanceof SMPServerException) {
                throw (SMPServerException)exception;
            }
            if (exception instanceof RegistrationHookException) {
                throw new SMPSMLException("Failed to create '" + iParticipantIdentifier.getURIEncoded() + "' in SML", exception);
            }
            throw new SMPInternalErrorException("Error creating ServiceGroup '" + iParticipantIdentifier.getURIEncoded() + "'", (Throwable)exception);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("createSMPServiceGroup succeeded");
        }
        AuditHelper.onAuditCreateSuccess((ObjectType)SMPServiceGroup.OT, (Object[])new Object[]{iParticipantIdentifier.getURIEncoded(), string, string2, bl});
        SMPServiceGroup sMPServiceGroup = new SMPServiceGroup(string, iParticipantIdentifier, string2);
        if (this.m_aCache != null) {
            this.m_aCache.put((Object)iParticipantIdentifier.getURIEncoded(), (Object)sMPServiceGroup);
        }
        this.m_aCBs.forEach(iSMPServiceGroupCallback -> iSMPServiceGroupCallback.onSMPServiceGroupCreated((ISMPServiceGroup)sMPServiceGroup, bl));
        return sMPServiceGroup;
    }

    @Nonnull
    public EChange updateSMPServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string, @Nullable String string2) throws SMPServerException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"NewOwnerID");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("updateSMPServiceGroup (" + iParticipantIdentifier.getURIEncoded() + ", " + string + ", " + (StringHelper.hasText((String)string2) ? "with extension" : "without extension") + ")");
        }
        Wrapper wrapper = new Wrapper((Object)EChange.UNCHANGED);
        Wrapper wrapper2 = new Wrapper();
        DBExecutor dBExecutor = this.newExecutor();
        ESuccess eSuccess = dBExecutor.performInTransaction(() -> {
            long l;
            SMPServiceGroup sMPServiceGroup = this.getSMPServiceGroupOfID(iParticipantIdentifier);
            if (sMPServiceGroup == null) {
                throw new SMPNotFoundException("The service group with ID " + iParticipantIdentifier.getURIEncoded() + " does not exist!");
            }
            if (!EqualsHelper.equals((Object)string, (Object)sMPServiceGroup.getOwnerID())) {
                l = dBExecutor.insertOrUpdateOrDelete("UPDATE smp_ownership SET username=? WHERE businessIdentifierScheme=? AND businessIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string, sMPServiceGroup.getParticipantIdentifier().getScheme(), sMPServiceGroup.getParticipantIdentifier().getValue()}));
                if (l != 1L) {
                    throw new IllegalStateException("Failed to update the ownership username to '" + string + "'");
                }
                wrapper.set((Object)EChange.CHANGED);
            }
            if (!EqualsHelper.equals((Object)string2, (Object)sMPServiceGroup.getExtensions().getExtensionsAsJsonString())) {
                l = dBExecutor.insertOrUpdateOrDelete("UPDATE smp_service_group SET extension=? WHERE businessIdentifierScheme=? AND businessIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string2, sMPServiceGroup.getParticipantIdentifier().getScheme(), sMPServiceGroup.getParticipantIdentifier().getValue()}));
                if (l != 1L) {
                    throw new IllegalStateException("Failed to update the service_group extension to '" + string2 + "'");
                }
                wrapper.set((Object)EChange.CHANGED);
            }
        }, arg_0 -> ((Wrapper)wrapper2).set(arg_0));
        if (eSuccess.isFailure() || wrapper2.isSet()) {
            AuditHelper.onAuditModifyFailure((ObjectType)SMPServiceGroup.OT, (String)"set-all", (Object[])new Object[]{iParticipantIdentifier.getURIEncoded(), string, string2});
            Exception exception = (Exception)wrapper2.get();
            if (exception instanceof SMPServerException) {
                throw (SMPServerException)exception;
            }
            throw new SMPInternalErrorException("Failed to update ServiceGroup '" + iParticipantIdentifier.getURIEncoded() + "'", (Throwable)exception);
        }
        EChange eChange = (EChange)wrapper.get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("updateSMPServiceGroup succeeded. Change=" + eChange.isChanged());
        }
        AuditHelper.onAuditModifySuccess((ObjectType)SMPServiceGroup.OT, (String)"set-all", (Object[])new Object[]{iParticipantIdentifier.getURIEncoded(), string, string2});
        if (eChange.isChanged()) {
            this.m_aCBs.forEach(iSMPServiceGroupCallback -> iSMPServiceGroupCallback.onSMPServiceGroupUpdated(iParticipantIdentifier));
        }
        return eChange;
    }

    @Nonnull
    public EChange deleteSMPServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, boolean bl) throws SMPServerException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("deleteSMPServiceGroup (" + iParticipantIdentifier.getURIEncoded() + ")");
        }
        IRegistrationHook iRegistrationHook = RegistrationHookFactory.getInstance();
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        Wrapper wrapper = new Wrapper((Object)EChange.UNCHANGED);
        Wrapper wrapper2 = new Wrapper();
        DBExecutor dBExecutor = this.newExecutor();
        ESuccess eSuccess = dBExecutor.performInTransaction(() -> {
            long l;
            SMPServiceGroup sMPServiceGroup = this.getSMPServiceGroupOfID(iParticipantIdentifier);
            if (sMPServiceGroup == null) {
                throw new SMPNotFoundException("The service group with ID " + iParticipantIdentifier.getURIEncoded() + " does not exist!");
            }
            if (bl) {
                iRegistrationHook.deleteServiceGroup(iParticipantIdentifier);
                mutableBoolean.set(true);
            }
            if ((l = dBExecutor.insertOrUpdateOrDelete("DELETE FROM smp_service_group WHERE businessIdentifierScheme=? AND businessIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue()}))) != 1L) {
                throw new IllegalStateException("Failed to delete service group");
            }
            wrapper.set((Object)EChange.CHANGED);
        }, arg_0 -> ((Wrapper)wrapper2).set(arg_0));
        if (eSuccess.isFailure() && bl && mutableBoolean.booleanValue()) {
            try {
                iRegistrationHook.undoDeleteServiceGroup(iParticipantIdentifier);
            }
            catch (RegistrationHookException registrationHookException) {
                LOGGER.error("Failed to undoDeleteServiceGroup (" + iParticipantIdentifier.getURIEncoded() + ")", (Throwable)registrationHookException);
            }
        }
        if (wrapper2.isSet()) {
            AuditHelper.onAuditDeleteFailure((ObjectType)SMPServiceGroup.OT, (Object[])new Object[]{iParticipantIdentifier.getURIEncoded(), "database-error"});
            Exception exception = (Exception)wrapper2.get();
            if (exception instanceof SMPServerException) {
                throw (SMPServerException)exception;
            }
            if (exception instanceof RegistrationHookException) {
                throw new SMPSMLException("Failed to delete '" + iParticipantIdentifier.getURIEncoded() + "' in SML", exception);
            }
            throw new SMPInternalErrorException("Failed to delete ServiceGroup '" + iParticipantIdentifier.getURIEncoded() + "'", (Throwable)exception);
        }
        EChange eChange = (EChange)wrapper.get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("deleteSMPServiceGroup succeeded. Change=" + eChange.isChanged());
        }
        if (eChange.isChanged()) {
            AuditHelper.onAuditDeleteSuccess((ObjectType)SMPServiceGroup.OT, (Object[])new Object[]{iParticipantIdentifier.getURIEncoded()});
            if (this.m_aCache != null) {
                this.m_aCache.remove((Object)iParticipantIdentifier.getURIEncoded());
            }
            this.m_aCBs.forEach(iSMPServiceGroupCallback -> iSMPServiceGroupCallback.onSMPServiceGroupDeleted(iParticipantIdentifier, bl));
        }
        return eChange;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISMPServiceGroup> getAllSMPServiceGroups() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getAllSMPServiceGroups()");
        }
        ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT sg.businessIdentifierScheme, sg.businessIdentifier, sg.extension, so.username FROM smp_service_group sg, smp_ownership so WHERE so.businessIdentifierScheme=sg.businessIdentifierScheme AND so.businessIdentifier=sg.businessIdentifier");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iCommonsList != null) {
            for (DBResultRow dBResultRow : iCommonsList) {
                commonsArrayList.add((Object)new SMPServiceGroup(dBResultRow.getAsString(3), (IParticipantIdentifier)new SimpleParticipantIdentifier(dBResultRow.getAsString(0), dBResultRow.getAsString(1)), dBResultRow.getAsString(2)));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllSMPServiceGroupIDs() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getAllSMPServiceGroupIDs()");
        }
        ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT sg.businessIdentifierScheme, sg.businessIdentifier FROM smp_service_group sg");
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        if (iCommonsList != null) {
            for (DBResultRow dBResultRow : iCommonsList) {
                commonsHashSet.add((Object)CIdentifier.getURIEncoded((String)dBResultRow.getAsString(0), (String)dBResultRow.getAsString(1)));
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISMPServiceGroup> getAllSMPServiceGroupsOfOwner(@Nonnull String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getAllSMPServiceGroupsOfOwner(" + string + ")");
        }
        ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT sg.businessIdentifierScheme, sg.businessIdentifier, sg.extension FROM smp_service_group sg, smp_ownership so WHERE so.username=? AND so.businessIdentifierScheme=sg.businessIdentifierScheme AND so.businessIdentifier=sg.businessIdentifier", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string}));
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iCommonsList != null) {
            for (DBResultRow dBResultRow : iCommonsList) {
                commonsArrayList.add((Object)new SMPServiceGroup(string, (IParticipantIdentifier)new SimpleParticipantIdentifier(dBResultRow.getAsString(0), dBResultRow.getAsString(1)), dBResultRow.getAsString(2)));
            }
        }
        return commonsArrayList;
    }

    @Nonnegative
    public long getSMPServiceGroupCountOfOwner(@Nonnull String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getSMPServiceGroupCountOfOwner(" + string + ")");
        }
        return this.newExecutor().queryCount("SELECT COUNT(sg.businessIdentifier) FROM smp_service_group sg, smp_ownership so WHERE so.username=? AND so.businessIdentifierScheme=sg.businessIdentifierScheme AND so.businessIdentifier=sg.businessIdentifier", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string}));
    }

    @Nullable
    public SMPServiceGroup getSMPServiceGroupOfID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        SMPServiceGroup sMPServiceGroup;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getSMPServiceGroupOfID(" + (iParticipantIdentifier == null ? "null" : iParticipantIdentifier.getURIEncoded()) + ")");
        }
        if (iParticipantIdentifier == null) {
            return null;
        }
        SMPServiceGroup sMPServiceGroup2 = sMPServiceGroup = this.m_aCache == null ? null : (SMPServiceGroup)this.m_aCache.get((Object)iParticipantIdentifier.getURIEncoded());
        if (sMPServiceGroup != null) {
            return sMPServiceGroup;
        }
        Wrapper wrapper = new Wrapper();
        this.newExecutor().querySingle("SELECT sg.extension, so.username FROM smp_service_group sg, smp_ownership so WHERE sg.businessIdentifierScheme=? AND sg.businessIdentifier=? AND so.businessIdentifierScheme=sg.businessIdentifierScheme AND so.businessIdentifier=sg.businessIdentifier", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue()}), arg_0 -> ((Wrapper)wrapper).set(arg_0));
        if (wrapper.isNotSet()) {
            return null;
        }
        sMPServiceGroup = new SMPServiceGroup(((DBResultRow)wrapper.get()).getAsString(1), iParticipantIdentifier, ((DBResultRow)wrapper.get()).getAsString(0));
        if (this.m_aCache != null) {
            this.m_aCache.put((Object)iParticipantIdentifier.getURIEncoded(), (Object)sMPServiceGroup);
        }
        return sMPServiceGroup;
    }

    public boolean containsSMPServiceGroupWithID(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("containsSMPServiceGroupWithID(" + (iParticipantIdentifier == null ? "null" : iParticipantIdentifier.getURIEncoded()) + ")");
        }
        if (iParticipantIdentifier == null) {
            return false;
        }
        if (this.m_aCache != null && this.m_aCache.containsKey((Object)iParticipantIdentifier.getURIEncoded())) {
            return true;
        }
        return 1L == this.newExecutor().queryCount("SELECT COUNT(*) FROM smp_service_group WHERE businessIdentifierScheme=? AND businessIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue()}));
    }

    @CheckForSigned
    public long getSMPServiceGroupCount() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getSMPServiceGroupCount()");
        }
        return this.newExecutor().queryCount("SELECT COUNT(*) FROM smp_service_group");
    }
}

