/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mutable.MutableBoolean;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.type.ObjectType;
import com.helger.commons.wrapper.Wrapper;
import com.helger.db.api.helper.DBValueHelper;
import com.helger.db.jdbc.callback.ConstantPreparedStatementDataProvider;
import com.helger.db.jdbc.callback.IPreparedStatementDataProvider;
import com.helger.db.jdbc.executor.DBExecutor;
import com.helger.db.jdbc.executor.DBResultRow;
import com.helger.db.jdbc.mgr.AbstractJDBCEnabledManager;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.simple.doctype.SimpleDocumentTypeIdentifier;
import com.helger.peppolid.simple.participant.SimpleParticipantIdentifier;
import com.helger.peppolid.simple.process.SimpleProcessIdentifier;
import com.helger.phoss.smp.domain.servicegroup.ISMPServiceGroup;
import com.helger.phoss.smp.domain.servicegroup.ISMPServiceGroupManager;
import com.helger.phoss.smp.domain.serviceinfo.ISMPEndpoint;
import com.helger.phoss.smp.domain.serviceinfo.ISMPProcess;
import com.helger.phoss.smp.domain.serviceinfo.ISMPServiceInformation;
import com.helger.phoss.smp.domain.serviceinfo.ISMPServiceInformationCallback;
import com.helger.phoss.smp.domain.serviceinfo.ISMPServiceInformationManager;
import com.helger.phoss.smp.domain.serviceinfo.SMPEndpoint;
import com.helger.phoss.smp.domain.serviceinfo.SMPProcess;
import com.helger.phoss.smp.domain.serviceinfo.SMPServiceInformation;
import com.helger.photon.audit.AuditHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SMPServiceInformationManagerJDBC
extends AbstractJDBCEnabledManager
implements ISMPServiceInformationManager {
    private final ISMPServiceGroupManager m_aServiceGroupMgr;
    private final CallbackList<ISMPServiceInformationCallback> m_aCBs = new CallbackList();

    public SMPServiceInformationManagerJDBC(@Nonnull Supplier<? extends DBExecutor> supplier, @Nonnull ISMPServiceGroupManager iSMPServiceGroupManager) {
        super(supplier);
        this.m_aServiceGroupMgr = iSMPServiceGroupManager;
    }

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<ISMPServiceInformationCallback> serviceInformationCallbacks() {
        return this.m_aCBs;
    }

    @Nonnull
    public ESuccess mergeSMPServiceInformation(@Nonnull ISMPServiceInformation iSMPServiceInformation) {
        ValueEnforcer.notNull((Object)iSMPServiceInformation, (String)"ServiceInformation");
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        DBExecutor dBExecutor = this.newExecutor();
        ESuccess eSuccess = dBExecutor.performInTransaction(() -> {
            EChange eChange = this._deleteSMPServiceInformationNoCallback(iSMPServiceInformation);
            mutableBoolean.set(eChange.isChanged());
            IParticipantIdentifier iParticipantIdentifier = iSMPServiceInformation.getServiceGroup().getParticipantIdentifier();
            IDocumentTypeIdentifier iDocumentTypeIdentifier = iSMPServiceInformation.getDocumentTypeIdentifier();
            dBExecutor.insertOrUpdateOrDelete("INSERT INTO smp_service_metadata (businessIdentifierScheme, businessIdentifier, documentIdentifierScheme, documentIdentifier, extension) VALUES (?, ?, ?, ?, ?)", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue(), iSMPServiceInformation.getExtensions().getExtensionsAsJsonString()}));
            for (ISMPProcess iSMPProcess : iSMPServiceInformation.getAllProcesses()) {
                IProcessIdentifier iProcessIdentifier = iSMPProcess.getProcessIdentifier();
                dBExecutor.insertOrUpdateOrDelete("INSERT INTO smp_process (businessIdentifierScheme, businessIdentifier, documentIdentifierScheme, documentIdentifier, processIdentifierType, processIdentifier, extension) VALUES (?, ?, ?, ?, ?, ?, ?)", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue(), iProcessIdentifier.getScheme(), iProcessIdentifier.getValue(), iSMPProcess.getExtensions().getExtensionsAsJsonString()}));
                for (ISMPEndpoint iSMPEndpoint : iSMPProcess.getAllEndpoints()) {
                    dBExecutor.insertOrUpdateOrDelete("INSERT INTO smp_endpoint (businessIdentifierScheme, businessIdentifier, documentIdentifierScheme, documentIdentifier, processIdentifierType, processIdentifier, certificate, endpointReference, minimumAuthenticationLevel, requireBusinessLevelSignature, serviceActivationDate, serviceDescription, serviceExpirationDate, technicalContactUrl, technicalInformationUrl, transportProfile, extension) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue(), iProcessIdentifier.getScheme(), iProcessIdentifier.getValue(), iSMPEndpoint.getCertificate(), iSMPEndpoint.getEndpointReference(), iSMPEndpoint.getMinimumAuthenticationLevel(), iSMPEndpoint.isRequireBusinessLevelSignature(), DBValueHelper.toTimestamp((XMLOffsetDateTime)iSMPEndpoint.getServiceActivationDateTime()), iSMPEndpoint.getServiceDescription(), DBValueHelper.toTimestamp((XMLOffsetDateTime)iSMPEndpoint.getServiceExpirationDateTime()), iSMPEndpoint.getTechnicalContactUrl(), iSMPEndpoint.getTechnicalInformationUrl(), iSMPEndpoint.getTransportProfile(), iSMPEndpoint.getExtensions().getExtensionsAsJsonString()}));
                }
            }
        });
        if (eSuccess.isFailure()) {
            return ESuccess.FAILURE;
        }
        if (mutableBoolean.booleanValue()) {
            AuditHelper.onAuditModifySuccess((ObjectType)SMPServiceInformation.OT, (String)"set-all", (Object[])new Object[]{iSMPServiceInformation.getID(), iSMPServiceInformation.getServiceGroupID(), iSMPServiceInformation.getDocumentTypeIdentifier().getURIEncoded(), iSMPServiceInformation.getAllProcesses(), iSMPServiceInformation.getExtensions().getExtensionsAsJsonString()});
            this.m_aCBs.forEach(iSMPServiceInformationCallback -> iSMPServiceInformationCallback.onSMPServiceInformationUpdated(iSMPServiceInformation));
        } else {
            AuditHelper.onAuditCreateSuccess((ObjectType)SMPServiceInformation.OT, (Object[])new Object[]{iSMPServiceInformation.getID(), iSMPServiceInformation.getServiceGroupID(), iSMPServiceInformation.getDocumentTypeIdentifier().getURIEncoded(), iSMPServiceInformation.getAllProcesses(), iSMPServiceInformation.getExtensions().getExtensionsAsJsonString()});
            this.m_aCBs.forEach(iSMPServiceInformationCallback -> iSMPServiceInformationCallback.onSMPServiceInformationCreated(iSMPServiceInformation));
        }
        return ESuccess.SUCCESS;
    }

    @Nullable
    public ISMPServiceInformation findServiceInformation(@Nullable ISMPServiceGroup iSMPServiceGroup, @Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nullable IProcessIdentifier iProcessIdentifier, @Nullable ISMPTransportProfile iSMPTransportProfile) {
        ISMPEndpoint iSMPEndpoint;
        ISMPProcess iSMPProcess;
        ISMPServiceInformation iSMPServiceInformation = this.getSMPServiceInformationOfServiceGroupAndDocumentType(iSMPServiceGroup, iDocumentTypeIdentifier);
        if (iSMPServiceInformation != null && (iSMPProcess = iSMPServiceInformation.getProcessOfID(iProcessIdentifier)) != null && (iSMPEndpoint = iSMPProcess.getEndpointOfTransportProfile(iSMPTransportProfile)) != null) {
            return iSMPServiceInformation;
        }
        return null;
    }

    @Nonnull
    private EChange _deleteSMPServiceInformationNoCallback(@Nonnull ISMPServiceInformation iSMPServiceInformation) {
        Wrapper wrapper = new Wrapper((Object)-1L);
        DBExecutor dBExecutor = this.newExecutor();
        ESuccess eSuccess = dBExecutor.performInTransaction(() -> {
            IParticipantIdentifier iParticipantIdentifier = iSMPServiceInformation.getServiceGroup().getParticipantIdentifier();
            IDocumentTypeIdentifier iDocumentTypeIdentifier = iSMPServiceInformation.getDocumentTypeIdentifier();
            long l = dBExecutor.insertOrUpdateOrDelete("DELETE FROM smp_endpoint WHERE businessIdentifierScheme=? AND businessIdentifier=? AND documentIdentifierScheme=? AND documentIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue()}));
            long l2 = dBExecutor.insertOrUpdateOrDelete("DELETE FROM smp_process WHERE businessIdentifierScheme=? AND businessIdentifier=? AND documentIdentifierScheme=? AND documentIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue()}));
            long l3 = dBExecutor.insertOrUpdateOrDelete("DELETE FROM smp_service_metadata WHERE businessIdentifierScheme=? AND businessIdentifier=? AND documentIdentifierScheme=? AND documentIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue()}));
            wrapper.set((Object)(l + l2 + l3));
        });
        if (eSuccess.isFailure()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf(((Long)wrapper.get() > 0L ? 1 : 0) != 0);
    }

    @Nonnull
    public EChange deleteSMPServiceInformation(@Nullable ISMPServiceInformation iSMPServiceInformation) {
        if (iSMPServiceInformation == null) {
            return EChange.UNCHANGED;
        }
        if (this._deleteSMPServiceInformationNoCallback(iSMPServiceInformation).isUnchanged()) {
            AuditHelper.onAuditDeleteFailure((ObjectType)SMPServiceInformation.OT, (Object[])new Object[]{"no-such-id", iSMPServiceInformation.getID()});
            return EChange.UNCHANGED;
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)SMPServiceInformation.OT, (Object[])new Object[]{iSMPServiceInformation.getID()});
        this.m_aCBs.forEach(iSMPServiceInformationCallback -> iSMPServiceInformationCallback.onSMPServiceInformationDeleted(iSMPServiceInformation));
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange deleteAllSMPServiceInformationOfServiceGroup(@Nullable ISMPServiceGroup iSMPServiceGroup) {
        if (iSMPServiceGroup == null) {
            return EChange.UNCHANGED;
        }
        Wrapper wrapper = new Wrapper((Object)0L);
        Wrapper wrapper2 = new Wrapper();
        DBExecutor dBExecutor = this.newExecutor();
        ESuccess eSuccess = dBExecutor.performInTransaction(() -> {
            wrapper2.set(this.getAllSMPServiceInformationOfServiceGroup(iSMPServiceGroup));
            IParticipantIdentifier iParticipantIdentifier = iSMPServiceGroup.getParticipantIdentifier();
            long l = dBExecutor.insertOrUpdateOrDelete("DELETE FROM smp_endpoint WHERE businessIdentifierScheme=? AND businessIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue()}));
            long l2 = dBExecutor.insertOrUpdateOrDelete("DELETE FROM smp_process WHERE businessIdentifierScheme=? AND businessIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue()}));
            long l3 = dBExecutor.insertOrUpdateOrDelete("DELETE FROM smp_service_metadata WHERE businessIdentifierScheme=? AND businessIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue()}));
            wrapper.set((Object)(l + l2 + l3));
        });
        if (eSuccess.isFailure() || (Long)wrapper.get() <= 0L) {
            AuditHelper.onAuditDeleteFailure((ObjectType)SMPServiceInformation.OT, (Object[])new Object[]{"no-such-id", iSMPServiceGroup.getID()});
            return EChange.UNCHANGED;
        }
        if (wrapper2.isSet()) {
            for (ISMPServiceInformation iSMPServiceInformation : (ICommonsList)wrapper2.get()) {
                AuditHelper.onAuditDeleteSuccess((ObjectType)SMPServiceInformation.OT, (Object[])new Object[]{iSMPServiceInformation.getID()});
                this.m_aCBs.forEach(iSMPServiceInformationCallback -> iSMPServiceInformationCallback.onSMPServiceInformationDeleted(iSMPServiceInformation));
            }
        }
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange deleteSMPProcess(@Nullable ISMPServiceInformation iSMPServiceInformation, @Nullable ISMPProcess iSMPProcess) {
        if (iSMPServiceInformation == null || iSMPProcess == null) {
            return EChange.UNCHANGED;
        }
        Wrapper wrapper = new Wrapper((Object)0L);
        DBExecutor dBExecutor = this.newExecutor();
        ESuccess eSuccess = dBExecutor.performInTransaction(() -> {
            IParticipantIdentifier iParticipantIdentifier = iSMPServiceInformation.getServiceGroup().getParticipantIdentifier();
            IDocumentTypeIdentifier iDocumentTypeIdentifier = iSMPServiceInformation.getDocumentTypeIdentifier();
            IProcessIdentifier iProcessIdentifier = iSMPProcess.getProcessIdentifier();
            long l = dBExecutor.insertOrUpdateOrDelete("DELETE FROM smp_endpoint WHERE businessIdentifierScheme=? AND businessIdentifier=? AND documentIdentifierScheme=? AND documentIdentifier=? AND processIdentifierType=? AND processIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue(), iProcessIdentifier.getScheme(), iProcessIdentifier.getValue()}));
            long l2 = dBExecutor.insertOrUpdateOrDelete("DELETE FROM smp_process WHERE businessIdentifierScheme=? AND businessIdentifier=? AND documentIdentifierScheme=? AND documentIdentifier=? AND processIdentifierType=? AND processIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue(), iProcessIdentifier.getScheme(), iProcessIdentifier.getValue()}));
            wrapper.set((Object)(l + l2));
        });
        if (eSuccess.isFailure()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf(((Long)wrapper.get() > 0L ? 1 : 0) != 0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISMPServiceInformation> getAllSMPServiceInformation() {
        Object object;
        CommonsArrayList commonsArrayList;
        ISMPServiceGroup iSMPServiceGroup;
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT sm.businessIdentifierScheme, sm.businessIdentifier, sm.documentIdentifierScheme, sm.documentIdentifier, sm.extension,   sp.processIdentifierType, sp.processIdentifier, sp.extension,   se.transportProfile, se.endpointReference, se.requireBusinessLevelSignature, se.minimumAuthenticationLevel,     se.serviceActivationDate, se.serviceExpirationDate, se.certificate, se.serviceDescription,     se.technicalContactUrl, se.technicalInformationUrl, se.extension FROM smp_service_metadata sm INNER JOIN smp_process sp   ON sm.businessIdentifierScheme=sp.businessIdentifierScheme AND sm.businessIdentifier=sp.businessIdentifier   AND sm.documentIdentifierScheme=sp.documentIdentifierScheme AND sm.documentIdentifier=sp.documentIdentifier INNER JOIN smp_endpoint se   ON sp.businessIdentifierScheme=se.businessIdentifierScheme AND sp.businessIdentifier=se.businessIdentifier   AND sp.documentIdentifierScheme=se.documentIdentifierScheme AND sp.documentIdentifier=se.documentIdentifier   AND sp.processIdentifierType=se.processIdentifierType AND sp.processIdentifier=se.processIdentifier");
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        if (iCommonsList != null) {
            for (Object object2 : iCommonsList) {
                iSMPServiceGroup = new SimpleParticipantIdentifier(object2.getAsString(0), object2.getAsString(1));
                SimpleDocumentTypeIdentifier simpleDocumentTypeIdentifier = new SimpleDocumentTypeIdentifier(object2.getAsString(2), object2.getAsString(3));
                Object object3 = object2.getAsString(4);
                commonsArrayList = new SMPProcess((IProcessIdentifier)new SimpleProcessIdentifier(object2.getAsString(5), object2.getAsString(6)), null, object2.getAsString(7));
                object = new SMPEndpoint(object2.getAsString(8), object2.getAsString(9), object2.getAsBoolean(10, false), object2.getAsString(11), object2.getAsXMLOffsetDateTime(12), object2.getAsXMLOffsetDateTime(13), object2.getAsString(14), object2.getAsString(15), object2.getAsString(16), object2.getAsString(17), object2.getAsString(18));
                ((ICommonsList)((ICommonsMap)((ICommonsMap)commonsHashMap.computeIfAbsent((Object)iSMPServiceGroup, iParticipantIdentifier -> new CommonsHashMap())).computeIfAbsent((Object)new DocTypeAndExtension((IDocumentTypeIdentifier)simpleDocumentTypeIdentifier, (String)object3), docTypeAndExtension -> new CommonsHashMap())).computeIfAbsent((Object)commonsArrayList, sMPProcess -> new CommonsArrayList())).add(object);
            }
        }
        for (Object object2 : commonsHashMap.entrySet()) {
            iSMPServiceGroup = this.m_aServiceGroupMgr.getSMPServiceGroupOfID((IParticipantIdentifier)object2.getKey());
            if (iSMPServiceGroup == null) {
                throw new IllegalStateException("Failed to resolve service group for participant ID '" + ((IParticipantIdentifier)object2.getKey()).getURIEncoded() + "'");
            }
            for (Object object3 : ((ICommonsMap)object2.getValue()).entrySet()) {
                commonsArrayList = new CommonsArrayList();
                for (Map.Entry entry : ((ICommonsMap)object3.getValue()).entrySet()) {
                    SMPProcess sMPProcess2 = (SMPProcess)entry.getKey();
                    sMPProcess2.addEndpoints((Iterable)entry.getValue());
                    commonsArrayList.add((Object)sMPProcess2);
                }
                object = (DocTypeAndExtension)object3.getKey();
                commonsArrayList2.add((Object)new SMPServiceInformation(iSMPServiceGroup, ((DocTypeAndExtension)object).m_aDocTypeID, (List)commonsArrayList, ((DocTypeAndExtension)object).m_sExt));
            }
        }
        return commonsArrayList2;
    }

    @Nonnegative
    public long getSMPServiceInformationCount() {
        return this.newExecutor().queryCount("SELECT COUNT(*) FROM smp_service_metadata");
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISMPServiceInformation> getAllSMPServiceInformationOfServiceGroup(@Nullable ISMPServiceGroup iSMPServiceGroup) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iSMPServiceGroup != null) {
            IParticipantIdentifier iParticipantIdentifier = iSMPServiceGroup.getParticipantIdentifier();
            ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT sm.documentIdentifierScheme, sm.documentIdentifier, sm.extension,   sp.processIdentifierType, sp.processIdentifier, sp.extension,   se.transportProfile, se.endpointReference, se.requireBusinessLevelSignature, se.minimumAuthenticationLevel,     se.serviceActivationDate, se.serviceExpirationDate, se.certificate, se.serviceDescription,     se.technicalContactUrl, se.technicalInformationUrl, se.extension FROM smp_service_metadata sm INNER JOIN smp_process sp   ON sm.businessIdentifierScheme=sp.businessIdentifierScheme AND sm.businessIdentifier=sp.businessIdentifier   AND sm.documentIdentifierScheme=sp.documentIdentifierScheme AND sm.documentIdentifier=sp.documentIdentifier INNER JOIN smp_endpoint se   ON sp.businessIdentifierScheme=se.businessIdentifierScheme AND sp.businessIdentifier=se.businessIdentifier   AND sp.documentIdentifierScheme=se.documentIdentifierScheme AND sp.documentIdentifier=se.documentIdentifier   AND sp.processIdentifierType=se.processIdentifierType AND sp.processIdentifier=se.processIdentifier WHERE sm.businessIdentifierScheme=? AND sm.businessIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue()}));
            if (iCommonsList != null) {
                SMPProcess sMPProcess2;
                Object object;
                SimpleDocumentTypeIdentifier simpleDocumentTypeIdentifier;
                CommonsHashMap commonsHashMap = new CommonsHashMap();
                for (Object object2 : iCommonsList) {
                    simpleDocumentTypeIdentifier = new SimpleDocumentTypeIdentifier(object2.getAsString(0), object2.getAsString(1));
                    object = object2.getAsString(2);
                    Map.Entry entry = new SMPProcess((IProcessIdentifier)new SimpleProcessIdentifier(object2.getAsString(3), object2.getAsString(4)), null, object2.getAsString(5));
                    sMPProcess2 = new SMPEndpoint(object2.getAsString(6), object2.getAsString(7), object2.getAsBoolean(8, false), object2.getAsString(9), object2.getAsXMLOffsetDateTime(10), object2.getAsXMLOffsetDateTime(11), object2.getAsString(12), object2.getAsString(13), object2.getAsString(14), object2.getAsString(15), object2.getAsString(16));
                    ((ICommonsList)((ICommonsMap)commonsHashMap.computeIfAbsent((Object)new DocTypeAndExtension((IDocumentTypeIdentifier)simpleDocumentTypeIdentifier, (String)object), docTypeAndExtension -> new CommonsHashMap())).computeIfAbsent((Object)entry, sMPProcess -> new CommonsArrayList())).add((Object)sMPProcess2);
                }
                for (Object object2 : commonsHashMap.entrySet()) {
                    simpleDocumentTypeIdentifier = new CommonsArrayList();
                    for (Map.Entry entry : ((ICommonsMap)object2.getValue()).entrySet()) {
                        sMPProcess2 = (SMPProcess)entry.getKey();
                        sMPProcess2.addEndpoints((Iterable)entry.getValue());
                        simpleDocumentTypeIdentifier.add((Object)sMPProcess2);
                    }
                    object = (DocTypeAndExtension)object2.getKey();
                    commonsArrayList.add((Object)new SMPServiceInformation(iSMPServiceGroup, ((DocTypeAndExtension)object).m_aDocTypeID, (List)simpleDocumentTypeIdentifier, ((DocTypeAndExtension)object).m_sExt));
                }
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IDocumentTypeIdentifier> getAllSMPDocumentTypesOfServiceGroup(@Nullable ISMPServiceGroup iSMPServiceGroup) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iSMPServiceGroup != null) {
            IParticipantIdentifier iParticipantIdentifier = iSMPServiceGroup.getParticipantIdentifier();
            ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT sm.documentIdentifierScheme, sm.documentIdentifier FROM smp_service_metadata sm WHERE sm.businessIdentifierScheme=? AND sm.businessIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue()}));
            if (iCommonsList != null) {
                for (DBResultRow dBResultRow : iCommonsList) {
                    commonsArrayList.add((Object)new SimpleDocumentTypeIdentifier(dBResultRow.getAsString(0), dBResultRow.getAsString(1)));
                }
            }
        }
        return commonsArrayList;
    }

    @Nullable
    public ISMPServiceInformation getSMPServiceInformationOfServiceGroupAndDocumentType(@Nullable ISMPServiceGroup iSMPServiceGroup, @Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        if (iSMPServiceGroup == null) {
            return null;
        }
        if (iDocumentTypeIdentifier == null) {
            return null;
        }
        IParticipantIdentifier iParticipantIdentifier = iSMPServiceGroup.getParticipantIdentifier();
        ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT sm.extension,   sp.processIdentifierType, sp.processIdentifier, sp.extension,   se.transportProfile, se.endpointReference, se.requireBusinessLevelSignature, se.minimumAuthenticationLevel,     se.serviceActivationDate, se.serviceExpirationDate, se.certificate, se.serviceDescription,     se.technicalContactUrl, se.technicalInformationUrl, se.extension FROM smp_service_metadata sm INNER JOIN smp_process sp   ON sm.businessIdentifierScheme=sp.businessIdentifierScheme AND sm.businessIdentifier=sp.businessIdentifier   AND sm.documentIdentifierScheme=sp.documentIdentifierScheme AND sm.documentIdentifier=sp.documentIdentifier INNER JOIN smp_endpoint se   ON sp.businessIdentifierScheme=se.businessIdentifierScheme AND sp.businessIdentifier=se.businessIdentifier   AND sp.documentIdentifierScheme=se.documentIdentifierScheme AND sp.documentIdentifier=se.documentIdentifier   AND sp.processIdentifierType=se.processIdentifierType AND sp.processIdentifier=se.processIdentifier WHERE sm.businessIdentifierScheme=? AND sm.businessIdentifier=? AND sm.documentIdentifierScheme=? AND sm.documentIdentifier=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue(), iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue()}));
        if (iCommonsList != null && iCommonsList.isNotEmpty()) {
            SMPProcess sMPProcess2;
            String string = ((DBResultRow)iCommonsList.getFirst()).getAsString(0);
            CommonsHashMap commonsHashMap = new CommonsHashMap();
            for (Object object : iCommonsList) {
                Map.Entry entry = new SMPProcess((IProcessIdentifier)new SimpleProcessIdentifier(object.getAsString(1), object.getAsString(2)), null, object.getAsString(3));
                sMPProcess2 = new SMPEndpoint(object.getAsString(4), object.getAsString(5), object.getAsBoolean(6, false), object.getAsString(7), object.getAsXMLOffsetDateTime(8), object.getAsXMLOffsetDateTime(9), object.getAsString(10), object.getAsString(11), object.getAsString(12), object.getAsString(13), object.getAsString(14));
                ((ICommonsList)commonsHashMap.computeIfAbsent((Object)entry, sMPProcess -> new CommonsArrayList())).add((Object)sMPProcess2);
            }
            Iterator iterator = new CommonsArrayList();
            for (Map.Entry entry : commonsHashMap.entrySet()) {
                sMPProcess2 = (SMPProcess)entry.getKey();
                sMPProcess2.addEndpoints((Iterable)entry.getValue());
                iterator.add(sMPProcess2);
            }
            return new SMPServiceInformation(iSMPServiceGroup, iDocumentTypeIdentifier, (List)((Object)iterator), string);
        }
        return null;
    }

    public boolean containsAnyEndpointWithTransportProfile(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        long l = this.newExecutor().queryCount("SELECT COUNT(*) FROM smp_endpoint WHERE transportProfile=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string}));
        return l > 0L;
    }

    @MustImplementEqualsAndHashcode
    private static final class DocTypeAndExtension {
        final IDocumentTypeIdentifier m_aDocTypeID;
        final String m_sExt;

        public DocTypeAndExtension(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, String string) {
            this.m_aDocTypeID = iDocumentTypeIdentifier;
            this.m_sExt = string;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            DocTypeAndExtension docTypeAndExtension = (DocTypeAndExtension)object;
            return this.m_aDocTypeID.equals(docTypeAndExtension.m_aDocTypeID) && EqualsHelper.equals((Object)this.m_sExt, (Object)docTypeAndExtension.m_sExt);
        }

        public int hashCode() {
            return new HashCodeGenerator((Object)this).append((Object)this.m_aDocTypeID).append((Object)this.m_sExt).getHashCode();
        }
    }
}

