/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.attr.StringMap;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.wrapper.Wrapper;
import com.helger.db.api.helper.DBValueHelper;
import com.helger.db.jdbc.callback.ConstantPreparedStatementDataProvider;
import com.helger.db.jdbc.callback.IPreparedStatementDataProvider;
import com.helger.db.jdbc.executor.DBExecutor;
import com.helger.db.jdbc.executor.DBResultRow;
import com.helger.db.jdbc.mgr.AbstractJDBCEnabledManager;
import com.helger.phoss.smp.settings.ISMPSettings;
import com.helger.phoss.smp.settings.ISMPSettingsCallback;
import com.helger.phoss.smp.settings.ISMPSettingsManager;
import com.helger.phoss.smp.settings.SMPSettings;
import com.helger.web.scope.singleton.AbstractRequestWebSingleton;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPSettingsManagerJDBC
extends AbstractJDBCEnabledManager
implements ISMPSettingsManager {
    private static final String SMP_REST_WRITABLE_API_DISABLED = "smp-rest-writable-api-disabled";
    private static final String DIRECTORY_INTEGRATION_REQUIRED = "directory-required";
    private static final String DIRECTORY_INTEGRATION_ENABLED = "directory-enabled";
    private static final String DIRECTORY_INTEGRATION_AUTO_UPDATE = "directory-auto-update";
    private static final String DIRECTORY_HOSTNAME = "directory-hostname";
    private static final String SML_REQUIRED = "sml-required";
    private static final String SML_ENABLED = "sml-enabled";
    private static final String SML_INFO_ID = "smlinfo-id";
    private final CallbackList<ISMPSettingsCallback> m_aCallbacks = new CallbackList();

    public SMPSettingsManagerJDBC(@Nonnull Supplier<? extends DBExecutor> supplier) {
        super(supplier);
    }

    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<ISMPSettingsCallback> callbacks() {
        return this.m_aCallbacks;
    }

    static void setSettingsValueInDB(@Nonnull DBExecutor dBExecutor, @Nonnull @Nonempty String string, @Nullable String string2) {
        long l;
        ValueEnforcer.notNull((Object)dBExecutor, (String)"Executor");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Key");
        long l2 = dBExecutor.insertOrUpdateOrDelete("UPDATE smp_settings SET value=? WHERE id=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{DBValueHelper.getTrimmedToLength((String)string2, (int)500), DBValueHelper.getTrimmedToLength((String)string, (int)45)}));
        if (l2 == 0L && (l = dBExecutor.insertOrUpdateOrDelete("INSERT INTO smp_settings (id, value) VALUES (?, ?)", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{DBValueHelper.getTrimmedToLength((String)string, (int)45), DBValueHelper.getTrimmedToLength((String)string2, (int)500)}))) != 1L) {
            throw new IllegalStateException("Failed to create new DB entry (" + l + ")");
        }
    }

    @Nonnull
    public ESuccess setSettingsValuesInDB(@Nonnull @Nonempty Map<String, String> map) {
        ValueEnforcer.notEmpty(map, (String)"Entries");
        DBExecutor dBExecutor = this.newExecutor();
        return dBExecutor.performInTransaction(() -> {
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                SMPSettingsManagerJDBC.setSettingsValueInDB(dBExecutor, string, string2);
            }
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getAllSettingsValuesFromDB() {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT id, value FROM smp_settings");
        if (iCommonsList != null) {
            for (DBResultRow dBResultRow : iCommonsList) {
                commonsHashMap.put((Object)dBResultRow.getAsString(0), (Object)dBResultRow.getAsString(1));
            }
        }
        return commonsHashMap;
    }

    @Nullable
    public static String getSettingsValueFromDB(@Nonnull DBExecutor dBExecutor, @Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        Wrapper wrapper = new Wrapper();
        dBExecutor.querySingle("SELECT value FROM smp_settings WHERE id=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string}), arg_0 -> ((Wrapper)wrapper).set(arg_0));
        if (wrapper.isNotSet()) {
            return null;
        }
        return ((DBResultRow)wrapper.get()).getAsString(0);
    }

    @Nullable
    public String getSettingsValue(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return SMPSettingsManagerJDBC.getSettingsValueFromDB(this.newExecutor(), string);
    }

    @Nonnull
    public ISMPSettings getSettings() {
        return SettingsSingleton.getInstance().getSettings(this);
    }

    @Nonnull
    public EChange updateSettings(boolean bl, boolean bl2, boolean bl3, boolean bl4, @Nullable String string, boolean bl5, boolean bl6, @Nullable String string2) {
        StringMap stringMap = new StringMap();
        stringMap.putIn(SMP_REST_WRITABLE_API_DISABLED, bl);
        stringMap.putIn(DIRECTORY_INTEGRATION_ENABLED, bl2);
        stringMap.putIn(DIRECTORY_INTEGRATION_REQUIRED, bl3);
        stringMap.putIn(DIRECTORY_INTEGRATION_AUTO_UPDATE, bl4);
        stringMap.putIn((Object)DIRECTORY_HOSTNAME, (Object)string);
        stringMap.putIn(SML_ENABLED, bl5);
        stringMap.putIn(SML_REQUIRED, bl6);
        stringMap.putIn((Object)SML_INFO_ID, (Object)string2);
        if (this.setSettingsValuesInDB((Map<String, String>)stringMap).isFailure()) {
            return EChange.UNCHANGED;
        }
        return EChange.CHANGED;
    }

    public static class SettingsSingleton
    extends AbstractRequestWebSingleton {
        private static final Logger LOGGER = LoggerFactory.getLogger(SettingsSingleton.class);
        private ISMPSettings m_aSettings;

        @Deprecated
        @UsedViaReflection
        public SettingsSingleton() {
        }

        @Nonnull
        public static SettingsSingleton getInstance() {
            return (SettingsSingleton)SettingsSingleton.getRequestSingleton(SettingsSingleton.class);
        }

        @Nonnull
        private ISMPSettings _getSettingsFromDB(@Nonnull SMPSettingsManagerJDBC sMPSettingsManagerJDBC) {
            ICommonsMap<String, String> iCommonsMap = sMPSettingsManagerJDBC.getAllSettingsValuesFromDB();
            SMPSettings sMPSettings = new SMPSettings(false);
            sMPSettings.setRESTWritableAPIDisabled(StringParser.parseBool((String)((String)iCommonsMap.get((Object)SMPSettingsManagerJDBC.SMP_REST_WRITABLE_API_DISABLED)), (boolean)false));
            sMPSettings.setDirectoryIntegrationEnabled(StringParser.parseBool((String)((String)iCommonsMap.get((Object)SMPSettingsManagerJDBC.DIRECTORY_INTEGRATION_ENABLED)), (boolean)true));
            sMPSettings.setDirectoryIntegrationRequired(StringParser.parseBool((String)((String)iCommonsMap.get((Object)SMPSettingsManagerJDBC.DIRECTORY_INTEGRATION_REQUIRED)), (boolean)true));
            sMPSettings.setDirectoryIntegrationAutoUpdate(StringParser.parseBool((String)((String)iCommonsMap.get((Object)SMPSettingsManagerJDBC.DIRECTORY_INTEGRATION_AUTO_UPDATE)), (boolean)true));
            sMPSettings.setDirectoryHostName((String)iCommonsMap.get((Object)SMPSettingsManagerJDBC.DIRECTORY_HOSTNAME));
            sMPSettings.setSMLEnabled(StringParser.parseBool((String)((String)iCommonsMap.get((Object)SMPSettingsManagerJDBC.SML_ENABLED)), (boolean)false));
            sMPSettings.setSMLRequired(StringParser.parseBool((String)((String)iCommonsMap.get((Object)SMPSettingsManagerJDBC.SML_REQUIRED)), (boolean)true));
            sMPSettings.setSMLInfoID((String)iCommonsMap.get((Object)SMPSettingsManagerJDBC.SML_INFO_ID));
            return sMPSettings;
        }

        @Nonnull
        public ISMPSettings getSettings(@Nonnull SMPSettingsManagerJDBC sMPSettingsManagerJDBC) {
            ISMPSettings iSMPSettings = this.m_aSettings;
            if (iSMPSettings == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Loading SMP settings from DB");
                }
                iSMPSettings = this.m_aSettings = this._getSettingsFromDB(sMPSettingsManagerJDBC);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reusing SMP settings of request");
            }
            return iSMPSettings;
        }
    }
}

