/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.mgr;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.mutable.MutableLong;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.type.ObjectType;
import com.helger.commons.wrapper.Wrapper;
import com.helger.db.api.helper.DBValueHelper;
import com.helger.db.jdbc.callback.ConstantPreparedStatementDataProvider;
import com.helger.db.jdbc.callback.IPreparedStatementDataProvider;
import com.helger.db.jdbc.executor.DBExecutor;
import com.helger.db.jdbc.executor.DBResultRow;
import com.helger.db.jdbc.mgr.AbstractJDBCEnabledManager;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppol.smp.SMPTransportProfile;
import com.helger.phoss.smp.domain.transportprofile.ISMPTransportProfileManager;
import com.helger.photon.audit.AuditHelper;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SMPTransportProfileManagerJDBC
extends AbstractJDBCEnabledManager
implements ISMPTransportProfileManager {
    public SMPTransportProfileManagerJDBC(@Nonnull Supplier<? extends DBExecutor> supplier) {
        super(supplier);
    }

    @Nullable
    public ISMPTransportProfile createSMPTransportProfile(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, boolean bl) {
        SMPTransportProfile sMPTransportProfile = new SMPTransportProfile(string, string2, bl);
        DBExecutor dBExecutor = this.newExecutor();
        ESuccess eSuccess = dBExecutor.performInTransaction(() -> SMPTransportProfileManagerJDBC.lambda$createSMPTransportProfile$0(dBExecutor, (ISMPTransportProfile)sMPTransportProfile));
        if (eSuccess.isFailure()) {
            AuditHelper.onAuditCreateFailure((ObjectType)SMPTransportProfile.OT, (Object[])new Object[]{string, string2, bl, "database-error"});
            return null;
        }
        AuditHelper.onAuditCreateSuccess((ObjectType)SMPTransportProfile.OT, (Object[])new Object[]{string, string2, bl});
        return sMPTransportProfile;
    }

    @Nonnull
    public EChange updateSMPTransportProfile(@Nullable String string, @Nonnull @Nonempty String string2, boolean bl) {
        MutableLong mutableLong = new MutableLong(-1L);
        DBExecutor dBExecutor = this.newExecutor();
        ESuccess eSuccess = dBExecutor.performInTransaction(() -> {
            long l = dBExecutor.insertOrUpdateOrDelete("UPDATE smp_tprofile SET name=?, deprecated=? WHERE id=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string2, bl, string}));
            mutableLong.set(l);
        });
        if (eSuccess.isFailure()) {
            AuditHelper.onAuditModifyFailure((ObjectType)SMPTransportProfile.OT, (String)"update", (Object[])new Object[]{string, "database-error"});
            return EChange.UNCHANGED;
        }
        if (mutableLong.is0()) {
            AuditHelper.onAuditModifyFailure((ObjectType)SMPTransportProfile.OT, (String)"update", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        AuditHelper.onAuditModifySuccess((ObjectType)SMPTransportProfile.OT, (String)"update", (Object[])new Object[]{string, string2, bl});
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange deleteSMPTransportProfile(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return EChange.UNCHANGED;
        }
        long l = this.newExecutor().insertOrUpdateOrDelete("DELETE FROM smp_tprofile WHERE id=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string}));
        if (l == 0L) {
            AuditHelper.onAuditDeleteFailure((ObjectType)SMPTransportProfile.OT, (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)SMPTransportProfile.OT, (Object[])new Object[]{string});
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISMPTransportProfile> getAllSMPTransportProfiles() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT id, name, deprecated FROM smp_tprofile");
        if (iCommonsList != null) {
            for (DBResultRow dBResultRow : iCommonsList) {
                commonsArrayList.add((Object)new SMPTransportProfile(dBResultRow.getAsString(0), dBResultRow.getAsString(1), dBResultRow.getAsBoolean(2, false)));
            }
        }
        return commonsArrayList;
    }

    @Nullable
    public ISMPTransportProfile getSMPTransportProfileOfID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        Wrapper wrapper = new Wrapper();
        this.newExecutor().querySingle("SELECT name, deprecated FROM smp_tprofile WHERE id=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string}), arg_0 -> ((Wrapper)wrapper).set(arg_0));
        if (wrapper.isNotSet()) {
            return null;
        }
        DBResultRow dBResultRow = (DBResultRow)wrapper.get();
        return new SMPTransportProfile(string, dBResultRow.getAsString(0), dBResultRow.getAsBoolean(1, false));
    }

    public boolean containsSMPTransportProfileWithID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return this.newExecutor().queryCount("SELECT COUNT(*) FROM smp_tprofile WHERE id=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string})) > 0L;
    }

    @Nonnegative
    public long getSMPTransportProfileCount() {
        return this.newExecutor().queryCount("SELECT COUNT(*) FROM smp_tprofile");
    }

    private static /* synthetic */ void lambda$createSMPTransportProfile$0(DBExecutor dBExecutor, ISMPTransportProfile iSMPTransportProfile) throws Exception {
        long l = dBExecutor.insertOrUpdateOrDelete("INSERT INTO smp_tprofile (id, name, deprecated) VALUES (?, ?, ?)", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{DBValueHelper.getTrimmedToLength((String)iSMPTransportProfile.getID(), (int)45), iSMPTransportProfile.getName(), iSMPTransportProfile.isDeprecated()}));
        if (l != 1L) {
            throw new IllegalStateException("Failed to create new DB entry (" + l + ")");
        }
    }
}

