/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.migration;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.type.ObjectType;
import com.helger.db.jdbc.callback.ConstantPreparedStatementDataProvider;
import com.helger.db.jdbc.callback.IPreparedStatementDataProvider;
import com.helger.db.jdbc.executor.DBExecutor;
import com.helger.db.jdbc.executor.DBResultRow;
import com.helger.db.jdbc.mgr.AbstractJDBCEnabledManager;
import com.helger.phoss.smp.backend.sql.EDatabaseType;
import com.helger.phoss.smp.backend.sql.SMPDataSourceSingleton;
import com.helger.phoss.smp.backend.sql.domain.DBUser;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SMPUserManagerJDBC
extends AbstractJDBCEnabledManager {
    public static final ObjectType OT = new ObjectType("smpuser");
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPUserManagerJDBC.class);

    public SMPUserManagerJDBC(@Nonnull Supplier<? extends DBExecutor> supplier) {
        super(supplier);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<DBUser> getAllUsers() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        ICommonsList iCommonsList = this.newExecutor().queryAll("SELECT username, password FROM smp_user");
        if (iCommonsList != null) {
            for (DBResultRow dBResultRow : iCommonsList) {
                commonsArrayList.add((Object)new DBUser(dBResultRow.getAsString(0), dBResultRow.getAsString(1)));
            }
        }
        return commonsArrayList;
    }

    public void updateOwnershipsAndKillUsers(@Nonnull ICommonsMap<String, String> iCommonsMap) {
        ValueEnforcer.notNull(iCommonsMap, (String)"OldToNewUserNameMap");
        DBExecutor dBExecutor = this.newExecutor();
        dBExecutor.performInTransaction(() -> {
            try {
                EDatabaseType eDatabaseType = SMPDataSourceSingleton.getDatabaseType();
                switch (eDatabaseType) {
                    case MYSQL: {
                        dBExecutor.executeStatement("ALTER TABLE smp_ownership DROP FOREIGN KEY FK_smp_ownership_username");
                        break;
                    }
                    case POSTGRESQL: {
                        dBExecutor.executeStatement("ALTER TABLE smp_ownership DROP CONSTRAINT FK_smp_ownership_username");
                        break;
                    }
                    case ORACLE: 
                    case DB2: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("The migration code for DB type " + eDatabaseType + " is missing");
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                LOGGER.warn("Error in droping constraints", (Throwable)runtimeException);
            }
            for (Map.Entry entry : iCommonsMap.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                dBExecutor.insertOrUpdateOrDelete("UPDATE smp_ownership SET username=? WHERE username=?", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{string2, string}));
            }
            try {
                dBExecutor.executeStatement("DROP TABLE smp_user");
            }
            catch (RuntimeException runtimeException) {
                LOGGER.warn("Error in droping table smp_user", (Throwable)runtimeException);
            }
        });
    }
}

