/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.migration;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.phoss.smp.backend.sql.SMPDBExecutor;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.jdbc.security.RoleManagerJDBC;
import com.helger.photon.security.role.IRole;
import com.helger.photon.security.role.Role;
import com.helger.photon.security.role.RoleManager;
import com.helger.web.scope.mgr.WebScoped;
import java.io.File;
import javax.annotation.Nonnull;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class V10__MigrateRolesToDB
extends BaseJavaMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(V10__MigrateRolesToDB.class);

    public void migrate(@Nonnull Context context) throws Exception {
        try (WebScoped webScoped = new WebScoped();){
            LOGGER.info("Migrating all roles to the DB");
            File file = WebFileIO.getDataIO().getFile("security/roles.xml");
            if (file.exists()) {
                RoleManager roleManager = new RoleManager("security/roles.xml");
                ICommonsList iCommonsList = roleManager.getAll();
                if (iCommonsList.isNotEmpty()) {
                    RoleManagerJDBC roleManagerJDBC = new RoleManagerJDBC(SMPDBExecutor::new, SMPDBExecutor.TABLE_NAME_CUSTOMIZER);
                    for (IRole iRole : iCommonsList) {
                        if (roleManagerJDBC.internalCreateNewRole((Role)iRole, false, false) != null) continue;
                        LOGGER.error("Failed to migrate role " + iRole + " to DB");
                    }
                }
                WebFileIO.getDataIO().renameFile("security/roles.xml", "security/roles.xml.migrated");
                LOGGER.info("Finished migrating all " + iCommonsList.size() + " roles to the DB");
            } else {
                LOGGER.warn("No role file found");
            }
        }
    }
}

