/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.migration;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.phoss.smp.backend.sql.SMPDBExecutor;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.jdbc.security.UserManagerJDBC;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.User;
import com.helger.photon.security.user.UserManager;
import com.helger.web.scope.mgr.WebScoped;
import java.io.File;
import javax.annotation.Nonnull;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class V11__MigrateUsersToDB
extends BaseJavaMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(V11__MigrateUsersToDB.class);

    public void migrate(@Nonnull Context context) throws Exception {
        try (WebScoped webScoped = new WebScoped();){
            LOGGER.info("Migrating all users to the DB");
            File file = WebFileIO.getDataIO().getFile("security/users.xml");
            if (file.exists()) {
                UserManager userManager = new UserManager("security/users.xml");
                ICommonsList iCommonsList = userManager.getAll();
                if (iCommonsList.isNotEmpty()) {
                    UserManagerJDBC userManagerJDBC = new UserManagerJDBC(SMPDBExecutor::new, SMPDBExecutor.TABLE_NAME_CUSTOMIZER);
                    for (IUser iUser : iCommonsList) {
                        if (userManagerJDBC.internalCreateNewUser((User)iUser, false, false) != null) continue;
                        LOGGER.error("Failed to migrate user " + iUser + " to DB");
                    }
                }
                WebFileIO.getDataIO().renameFile("security/users.xml", "security/users.xml.migrated");
                LOGGER.info("Finished migrating all " + iCommonsList.size() + " users to the DB");
            } else {
                LOGGER.warn("No user file found");
            }
        }
    }
}

