/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.migration;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.phoss.smp.backend.sql.SMPDBExecutor;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.jdbc.security.RoleManagerJDBC;
import com.helger.photon.jdbc.security.UserGroupManagerJDBC;
import com.helger.photon.jdbc.security.UserManagerJDBC;
import com.helger.photon.security.role.IRoleManager;
import com.helger.photon.security.user.IUserManager;
import com.helger.photon.security.usergroup.IUserGroup;
import com.helger.photon.security.usergroup.UserGroup;
import com.helger.photon.security.usergroup.UserGroupManager;
import com.helger.web.scope.mgr.WebScoped;
import java.io.File;
import javax.annotation.Nonnull;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class V12__MigrateUserGroupsToDB
extends BaseJavaMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(V12__MigrateUserGroupsToDB.class);

    public void migrate(@Nonnull Context context) throws Exception {
        try (WebScoped webScoped = new WebScoped();){
            LOGGER.info("Migrating all user groups to the DB");
            File file = WebFileIO.getDataIO().getFile("security/usergroups.xml");
            if (file.exists()) {
                UserManagerJDBC userManagerJDBC = new UserManagerJDBC(SMPDBExecutor::new, SMPDBExecutor.TABLE_NAME_CUSTOMIZER);
                RoleManagerJDBC roleManagerJDBC = new RoleManagerJDBC(SMPDBExecutor::new, SMPDBExecutor.TABLE_NAME_CUSTOMIZER);
                UserGroupManager userGroupManager = new UserGroupManager("security/usergroups.xml", (IUserManager)userManagerJDBC, (IRoleManager)roleManagerJDBC);
                ICommonsList iCommonsList = userGroupManager.getAll();
                if (iCommonsList.isNotEmpty()) {
                    UserGroupManagerJDBC userGroupManagerJDBC = new UserGroupManagerJDBC(SMPDBExecutor::new, SMPDBExecutor.TABLE_NAME_CUSTOMIZER, (IUserManager)userManagerJDBC, (IRoleManager)roleManagerJDBC);
                    for (IUserGroup iUserGroup : iCommonsList) {
                        if (userGroupManagerJDBC.internalCreateNewUserGroup((UserGroup)iUserGroup, false, false) != null) continue;
                        LOGGER.error("Failed to migrate user group " + iUserGroup + " to DB");
                    }
                }
                WebFileIO.getDataIO().renameFile("security/usergroups.xml", "security/usergroups.xml.migrated");
                LOGGER.info("Finished migrating all " + iCommonsList.size() + " user groups to the DB");
            } else {
                LOGGER.warn("No user group file found");
            }
        }
    }
}

