/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.migration;

import com.helger.phoss.smp.backend.sql.SMPDBExecutor;
import com.helger.phoss.smp.backend.sql.mgr.SMPSettingsManagerJDBC;
import com.helger.phoss.smp.backend.sql.migration.V5__MigrateTransportProfilesToDB;
import com.helger.phoss.smp.settings.ISMPSettings;
import com.helger.phoss.smp.settings.SMPSettingsManagerXML;
import com.helger.photon.app.io.WebFileIO;
import com.helger.web.scope.mgr.WebScoped;
import java.io.File;
import javax.annotation.Nonnull;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V14__MigrateSettingsToDB
extends BaseJavaMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(V5__MigrateTransportProfilesToDB.class);

    public void migrate(@Nonnull Context context) throws Exception {
        try (WebScoped webScoped = new WebScoped();){
            LOGGER.info("Migrating all settings to the DB");
            File file = WebFileIO.getDataIO().getFile("smp-settings.xml");
            if (file.exists()) {
                SMPSettingsManagerJDBC sMPSettingsManagerJDBC = new SMPSettingsManagerJDBC(SMPDBExecutor::new);
                SMPSettingsManagerXML sMPSettingsManagerXML = new SMPSettingsManagerXML("smp-settings.xml");
                ISMPSettings iSMPSettings = sMPSettingsManagerXML.getSettings();
                if (sMPSettingsManagerJDBC.updateSettings(iSMPSettings.isRESTWritableAPIDisabled(), iSMPSettings.isDirectoryIntegrationEnabled(), iSMPSettings.isDirectoryIntegrationRequired(), iSMPSettings.isDirectoryIntegrationAutoUpdate(), iSMPSettings.getDirectoryHostName(), iSMPSettings.isSMLEnabled(), iSMPSettings.isSMLRequired(), iSMPSettings.getSMLInfoID()).isUnchanged()) {
                    throw new IllegalStateException("Failed to migrate SMP settings to DB");
                }
                WebFileIO.getDataIO().renameFile("smp-settings.xml", "smp-settings.xml.migrated");
                LOGGER.info("Finished migrating all SMP settings to the DB");
            } else {
                LOGGER.info("No SMP settings file found");
            }
        }
    }
}

