/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.migration;

import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.io.IHasOutputStream;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.phoss.smp.CSMPServer;
import com.helger.phoss.smp.backend.sql.EDatabaseType;
import com.helger.phoss.smp.backend.sql.SMPDBExecutor;
import com.helger.phoss.smp.backend.sql.SMPDataSourceSingleton;
import com.helger.phoss.smp.backend.sql.domain.DBUser;
import com.helger.phoss.smp.backend.sql.migration.SMPUserManagerJDBC;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.IUserManager;
import com.helger.web.scope.mgr.WebScoped;
import com.helger.xml.microdom.util.XMLMapHandler;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class V15__MigrateDBUsersToPhotonUsers
extends BaseJavaMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(V15__MigrateDBUsersToPhotonUsers.class);

    public void migrate(@Nonnull Context context) throws Exception {
        try (WebScoped webScoped = new WebScoped();){
            LOGGER.info("Migrating all old DB users to ph-oton users");
            EDatabaseType eDatabaseType = SMPDataSourceSingleton.getDatabaseType();
            SMPUserManagerJDBC sMPUserManagerJDBC = new SMPUserManagerJDBC(SMPDBExecutor::new);
            ICommonsList<DBUser> iCommonsList = sMPUserManagerJDBC.getAllUsers();
            LOGGER.info("Found " + iCommonsList.size() + " DB user to migrate");
            CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
            IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
            Iterator iterator = iCommonsList.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2;
                DBUser dBUser;
                DBUser dBUser2 = dBUser = (DBUser)iterator.next();
                IUser iUser = null;
                int n = 0;
                while ((iUser = iUserManager.createNewUser(string2 = (string = dBUser2.getUserName() + (n > 0 ? Integer.toString(n) : "")) + "@example.org", string2, dBUser2.getPassword(), null, string, null, CSMPServer.DEFAULT_LOCALE, null, false)) == null) {
                    if (++n <= 1000) continue;
                    throw new IllegalStateException("Too many iterations mapping the DB user '" + dBUser2.getUserName() + "' to a ph-oton user");
                }
                commonsLinkedHashMap.put((Object)dBUser2.getUserName(), (Object)((String)iUser.getID()));
                LOGGER.info("Mapped DB user '" + dBUser2.getUserName() + "' to ph-oton user " + (String)iUser.getID());
            }
            sMPUserManagerJDBC.updateOwnershipsAndKillUsers((ICommonsMap<String, String>)commonsLinkedHashMap);
            if (XMLMapHandler.writeMap((Map)commonsLinkedHashMap, (IHasOutputStream)new FileSystemResource(WebFileIO.getDataIO().getFile("migrations/db-photon-user-mapping-" + eDatabaseType.getID() + ".xml"))).isFailure()) {
                LOGGER.error("Failed to store mapping of DB users to ph-oton users as XML");
            }
            LOGGER.info("Finished migrating all DB users to ph-oton users");
        }
    }
}

