/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.backend.sql.migration;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.phoss.smp.backend.sql.SMPDBExecutor;
import com.helger.phoss.smp.backend.sql.mgr.SMPTransportProfileManagerJDBC;
import com.helger.phoss.smp.domain.transportprofile.SMPTransportProfileManagerXML;
import com.helger.photon.app.io.WebFileIO;
import com.helger.web.scope.mgr.WebScoped;
import java.io.File;
import javax.annotation.Nonnull;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class V5__MigrateTransportProfilesToDB
extends BaseJavaMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(V5__MigrateTransportProfilesToDB.class);

    public void migrate(@Nonnull Context context) throws Exception {
        try (WebScoped webScoped = new WebScoped();){
            LOGGER.info("Migrating all transport profiles to the DB");
            File file = WebFileIO.getDataIO().getFile("transportprofiles.xml");
            if (file.exists()) {
                SMPTransportProfileManagerXML sMPTransportProfileManagerXML = new SMPTransportProfileManagerXML("transportprofiles.xml");
                ICommonsList iCommonsList = sMPTransportProfileManagerXML.getAll();
                if (iCommonsList.isNotEmpty()) {
                    SMPTransportProfileManagerJDBC sMPTransportProfileManagerJDBC = new SMPTransportProfileManagerJDBC(SMPDBExecutor::new);
                    for (ISMPTransportProfile iSMPTransportProfile : iCommonsList) {
                        if (sMPTransportProfileManagerJDBC.createSMPTransportProfile(iSMPTransportProfile.getID(), iSMPTransportProfile.getName(), iSMPTransportProfile.isDeprecated()) != null) continue;
                        LOGGER.error("Failed to migrate " + iSMPTransportProfile + " to DB");
                    }
                }
                WebFileIO.getDataIO().renameFile("transportprofiles.xml", "transportprofiles.xml.migrated");
                LOGGER.info("Finished migrating all " + iCommonsList.size() + " transport profiles to the DB");
            } else {
                LOGGER.info("No transport profile file found");
            }
        }
    }
}

