/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phoss.smp.sql.status;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.db.api.jdbc.JDBCHelper;
import com.helger.db.jdbc.ConnectionFromDataSource;
import com.helger.db.jdbc.executor.DBNoConnectionException;
import com.helger.phoss.smp.backend.sql.SMPDataSourceSingleton;
import com.helger.phoss.smp.backend.sql.SMPJDBCConfiguration;
import com.helger.phoss.smp.status.ISMPStatusProviderExtensionSPI;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@IsSPIImplementation
public class SMPSQLStatusProviderExtensionSPI
implements ISMPStatusProviderExtensionSPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPSQLStatusProviderExtensionSPI.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean _isDBConnectionPossible() {
        BasicDataSource basicDataSource = SMPDataSourceSingleton.getInstance().getDataSourceProvider().getDataSource();
        try {
            basicDataSource.setLoginTimeout(1);
        }
        catch (UnsupportedOperationException | SQLException exception) {
            // empty catch block
        }
        ConnectionFromDataSource connectionFromDataSource = new ConnectionFromDataSource((DataSource)basicDataSource);
        Connection connection = null;
        try {
            connection = connectionFromDataSource.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (DBNoConnectionException dBNoConnectionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null && connectionFromDataSource.shouldCloseConnection()) {
                JDBCHelper.close((Connection)connection);
            }
        }
    }

    @Nonnull
    public ICommonsOrderedMap<String, ?> getAdditionalStatusData(boolean bl) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        if (SMPJDBCConfiguration.isStatusEnabled()) {
            commonsLinkedHashMap.put((Object)"smp.sql.target-database", (Object)SMPJDBCConfiguration.getTargetDatabaseType());
            if (!bl) {
                commonsLinkedHashMap.put((Object)"smp.sql.db.connection-possible", (Object)SMPSQLStatusProviderExtensionSPI._isDBConnectionPossible());
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The listing of the specific SQL status items is disabled via the configuration");
        }
        return commonsLinkedHashMap;
    }
}

