/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.helpshift.Core;
import com.helpshift.account.domainmodel.ProfileDM;
import com.helpshift.campaigns.Campaigns;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.util.CampaignsNotification;
import com.helpshift.executors.ActionExecutor;
import com.helpshift.executors.SupportCampaignsActionExecutor;
import com.helpshift.notifications.NotificationChannelsManager;
import com.helpshift.support.Support;
import com.helpshift.util.HelpshiftContext;
import java.util.HashMap;
import java.util.Map;

public class All
implements Core.ApiProvider {
    private Campaigns campaigns = Campaigns.getInstance();
    private Support support = Support.getInstance();

    All() {
    }

    public static All getInstance() {
        return LazyHolder.INSTANCE;
    }

    @Override
    public void _preInstall(Application application, String apiKey, String domain, String appId, Map<String, Object> config) {
        this.campaigns._preInstall(application, apiKey, domain, appId, config);
        this.support._preInstall(application, apiKey, domain, appId, config);
    }

    @Override
    public void _install(@NonNull Application application, @NonNull String apiKey, @NonNull String domain, @NonNull String appId) {
        this._install(application, apiKey, domain, appId, new HashMap<String, Object>());
    }

    @Override
    public void _install(@NonNull Application application, @NonNull String apiKey, @NonNull String domain, @NonNull String appId, @NonNull Map<String, Object> config) {
        this.campaigns._install(application, apiKey, domain, appId, config);
        this.support._install(application, apiKey, domain, appId, config);
        this.makeLoginConsistent();
        NotificationChannelsManager notificationChannel = new NotificationChannelsManager((Context)application);
        notificationChannel.checkAndUpdateDefaultChannelInfo();
    }

    private void makeLoginConsistent() {
        String campaignsUid = ControllerFactory.getInstance().userController.getCurrentUser().identifier;
        String campaignsDid = ControllerFactory.getInstance().deviceController.deviceModel.getIdentifier();
        boolean isDeviceLoggedInInCampaigns = campaignsDid.equals(campaignsUid);
        ProfileDM profileDM = HelpshiftContext.getCoreApi().getAccountManagerDM().getProfileDM();
        if (!profileDM.isDefaultLogin()) {
            if (isDeviceLoggedInInCampaigns) {
                this.campaigns._login(profileDM.identifier, profileDM.name, profileDM.email);
            } else if (!campaignsUid.equals(profileDM.identifier)) {
                this.campaigns._login(profileDM.identifier, profileDM.name, profileDM.email);
            }
        } else if (!isDeviceLoggedInInCampaigns) {
            this.campaigns._logout();
        }
    }

    @Override
    public void _setNameAndEmail(String name, String email) {
        this.campaigns._setNameAndEmail(name, email);
        this.support._setNameAndEmail(name, email);
    }

    @Override
    public void _registerDeviceToken(@NonNull Context context, @NonNull String deviceToken) {
        this.campaigns._registerDeviceToken(context, deviceToken);
        this.support._registerDeviceToken(context, deviceToken);
    }

    @Override
    public void _handlePush(Context context, Intent intent) {
        String campaignId = CampaignsNotification.getCampaignsId(intent);
        if (campaignId != null) {
            this.campaigns._handlePush(context, intent);
        } else {
            this.support._handlePush(context, intent);
        }
    }

    @Override
    public boolean _login(@NonNull String userId, String name, String email) {
        boolean loginSucceeded = false;
        if (this.support._login(userId, name, email)) {
            loginSucceeded = this.campaigns._login(userId, name, email);
        }
        return loginSucceeded;
    }

    @Override
    public boolean _logout() {
        boolean logoutSucceeded = false;
        if (this.support._logout()) {
            logoutSucceeded = this.campaigns._logout();
        }
        return logoutSucceeded;
    }

    @Override
    public ActionExecutor _getActionExecutor() {
        return new SupportCampaignsActionExecutor();
    }

    @Override
    public void _setSDKLanguage(String locale) {
        this.campaigns._setSDKLanguage(locale);
        this.support._setSDKLanguage(locale);
    }

    private static class LazyHolder {
        static final All INSTANCE = new All();

        private LazyHolder() {
        }
    }
}

