/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import com.helpshift.Core;
import com.helpshift.exceptions.InstallException;
import com.helpshift.exceptions.handlers.UncaughtExceptionHandler;
import com.helpshift.executors.ActionExecutor;
import com.helpshift.logger.LoggerProvider;
import com.helpshift.logger.logmodels.LogExtrasModelFactory;
import com.helpshift.logger.logmodels.LogExtrasModelProvider;
import com.helpshift.static_classes.ErrorReporting;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.SchemaUtil;
import com.helpshift.util.TextUtils;
import com.helpshift.util.concurrent.ApiExecutor;
import com.helpshift.util.concurrent.ApiExecutorFactory;
import java.util.HashMap;
import java.util.Map;

public class CoreInternal {
    private static final String TAG = "Helpshift_CoreInternal";
    static Core.ApiProvider apiProvider;

    public static void init(Core.ApiProvider apiProvider) {
        CoreInternal.apiProvider = apiProvider;
    }

    protected static void verifyInit() {
        if (apiProvider == null) {
            throw new ExceptionInInitializerError("com.helpshift.Core.init() method not called");
        }
    }

    public static void setNameAndEmail(final String name, final String email) {
        CoreInternal.verifyInit();
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                apiProvider._setNameAndEmail(name, email);
            }
        });
    }

    public static void install(Application application, String apiKey, String domain, String appId) throws InstallException {
        CoreInternal.install(application, apiKey, domain, appId, new HashMap());
    }

    public static void install(final Application application, final String apiKey, final String domain, final String appId, final Map config) throws InstallException {
        CoreInternal.verifyInit();
        final String trimApiKey = !TextUtils.isEmpty(apiKey) ? apiKey.trim() : apiKey;
        final String trimDomain = !TextUtils.isEmpty(domain) ? domain.trim() : domain;
        final String trimAppId = !TextUtils.isEmpty(appId) ? appId.trim() : appId;
        SchemaUtil.validateInstallCredentials(trimApiKey, trimDomain, trimAppId);
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runSync(new Runnable(){

            @Override
            public void run() {
                apiProvider._preInstall(application, trimApiKey, trimDomain, trimAppId, config);
            }
        });
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                CoreInternal.initLogging(application.getApplicationContext(), config);
                HSLogger.d(CoreInternal.TAG, "Helpshift install :\n Flavor : " + apiProvider.getClass().getSimpleName() + "\n Apikey : " + apiKey + "\n Domain : " + domain + "\n AppId : " + appId + "\n Config : " + config.toString() + "\n Package Id : " + application.getPackageName() + "\n SDK version : " + "6.3.0" + "\n OS version : " + Build.VERSION.SDK_INT + "\n Device : " + Build.DEVICE);
                apiProvider._install(application, trimApiKey, trimDomain, trimAppId, config);
            }
        });
    }

    public static void registerDeviceToken(final Context context, final String deviceToken) {
        CoreInternal.verifyInit();
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                HSLogger.d(CoreInternal.TAG, "Registering push token : " + deviceToken);
                apiProvider._registerDeviceToken(context, deviceToken);
            }
        });
    }

    public static void handlePush(final Context context, final Intent intent) {
        CoreInternal.verifyInit();
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                HSLogger.d(CoreInternal.TAG, "Handling push on main thread");
                apiProvider._handlePush(context, intent);
            }
        });
    }

    public static void handlePush(final Context context, final Bundle data) {
        CoreInternal.verifyInit();
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.putExtras(data);
                HSLogger.d(CoreInternal.TAG, "Handling push on main thread");
                apiProvider._handlePush(context, intent);
            }
        });
    }

    public static void handlePush(final Context context, final Map<String, String> data) {
        CoreInternal.verifyInit();
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                Bundle bundle = new Bundle();
                for (Map.Entry entry : data.entrySet()) {
                    bundle.putString((String)entry.getKey(), (String)entry.getValue());
                }
                intent.putExtras(bundle);
                HSLogger.d(CoreInternal.TAG, "Handling push on main thread");
                apiProvider._handlePush(context, intent);
            }
        });
    }

    public static void login(final String userId, final String name, final String email) {
        CoreInternal.verifyInit();
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                HSLogger.d(CoreInternal.TAG, "Login state changed : name : " + name);
                apiProvider._login(userId, name, email);
            }
        });
    }

    public static void logout() {
        CoreInternal.verifyInit();
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                apiProvider._logout();
                HSLogger.d(CoreInternal.TAG, "Logged out.");
            }
        });
    }

    public static void setSDKLanguage(final String locale) {
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                HSLogger.d(CoreInternal.TAG, "Setting SDK language : " + locale);
                apiProvider._setSDKLanguage(locale);
            }
        });
    }

    public static ActionExecutor getActionExecutor() {
        return apiProvider._getActionExecutor();
    }

    static void initLogging(Context context, Map config) {
        Object enableLoggingConfig = config.get("enableLogging");
        boolean enableLogging = enableLoggingConfig instanceof Boolean && (Boolean)enableLoggingConfig != false;
        Object disableErrorReportingConfig = config.get("disableErrorLogging");
        if (disableErrorReportingConfig == null) {
            disableErrorReportingConfig = config.get("disableErrorReporting");
        }
        boolean disableErrorReporting = disableErrorReportingConfig instanceof Boolean && (Boolean)disableErrorReportingConfig != false;
        float serverTimeDeltaInSeconds = HelpshiftContext.getPlatform().getNetworkRequestDAO().getServerTimeDelta();
        HSLogger.initialize(LoggerProvider.getLoggerInstance(context, "__hs_log_store"));
        LogExtrasModelProvider.initialize(new LogExtrasModelFactory());
        HSLogger.updateTimeStampDelta(serverTimeDeltaInSeconds);
        HSLogger.enableLogging(enableLogging, !disableErrorReporting);
        ErrorReporting.shouldEnable(!disableErrorReporting);
        if (!disableErrorReporting) {
            UncaughtExceptionHandler.init(context);
        }
        if (HSLogger.getFatalLogsCount() == 0) {
            HSLogger.deleteAll();
        }
    }
}

