/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift;

import com.helpshift.CoreApi;
import com.helpshift.account.domainmodel.AccountManagerDM;
import com.helpshift.analytics.domainmodel.AnalyticsEventDM;
import com.helpshift.auth.domainmodel.WebSocketAuthDM;
import com.helpshift.cif.CustomIssueFieldDM;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.AttachmentFileManagerDM;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.domain.Threader;
import com.helpshift.common.platform.Platform;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.ConversationInboxPoller;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.ConversationRenderer;
import com.helpshift.conversation.activeconversation.FetchDataFromThread;
import com.helpshift.conversation.domainmodel.ConversationInboxDM;
import com.helpshift.conversation.domainmodel.ConversationInboxManagerDM;
import com.helpshift.conversation.viewmodel.ConversationVM;
import com.helpshift.conversation.viewmodel.NewConversationRenderer;
import com.helpshift.conversation.viewmodel.NewConversationVM;
import com.helpshift.crypto.CryptoDM;
import com.helpshift.delegate.RootDelegate;
import com.helpshift.delegate.UIThreadDelegateDecorator;
import com.helpshift.faq.FaqsDM;
import com.helpshift.localeprovider.domainmodel.LocaleProviderDM;
import com.helpshift.meta.MetaDataDM;
import com.helpshift.util.HSLogger;
import java.util.Map;

public class JavaCore
implements CoreApi {
    private final Platform platform;
    final Domain domain;
    private final Threader serialThreader;
    private final Threader parallelThreader;
    final SDKConfigurationDM sdkConfigurationDM;
    private final MetaDataDM metaDataDM;
    final AnalyticsEventDM analyticsEventDM;
    private AccountManagerDM accountManagerDM;
    private ConversationInboxManagerDM conversationInboxManagerDM;
    private boolean isSDKSessionActive = false;
    private static final String TAG = "Helpshift_JavaCore";

    public JavaCore(Platform platform) {
        this.platform = platform;
        this.domain = new Domain(platform);
        this.serialThreader = this.domain.getSerialThreader();
        this.parallelThreader = this.domain.getParallelThreader();
        this.sdkConfigurationDM = this.domain.getSDKConfigurationDM();
        this.analyticsEventDM = this.domain.getAnalyticsEventDM();
        this.metaDataDM = this.domain.getMetaDataDM();
    }

    @Override
    public NewConversationVM getNewConversationViewModel(NewConversationRenderer renderer) {
        return new NewConversationVM(this.platform, this.domain, this.getConversationInboxManagerDM().getConversationInboxDM(), renderer);
    }

    @Override
    public ConversationVM getConversationViewModel(Long conversationLocalId, ConversationRenderer renderer, boolean retainMessageBoxOnUI) {
        ConversationDM conversationDM = this.getConversationInboxManagerDM().getConversationInboxDM().getConversationDM(conversationLocalId);
        return new ConversationVM(this.platform, this.domain, this.getConversationInboxManagerDM().getConversationInboxDM(), conversationDM, renderer, retainMessageBoxOnUI);
    }

    @Override
    public ConversationDM getActiveConversation() {
        return this.getConversationInboxManagerDM().getConversationInboxDM().getActiveConversationFromStorage();
    }

    @Override
    public boolean isActiveConversationActionable() {
        return this.getConversationInboxManagerDM().getConversationInboxDM().isActiveConversationActionable();
    }

    @Override
    public void setDelegateListener(final RootDelegate rootDelegate) {
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.domain.setDelegate(rootDelegate);
            }
        });
    }

    @Override
    public synchronized boolean login(String userId, String name, String email) {
        boolean loginSuccessful = false;
        if (this.isSDKSessionActive) {
            HSLogger.d(TAG, "Login should be called before starting a Helpshift session");
        } else {
            Long oldProfileLocalId = this.getAccountManagerDM().getProfileDM().localId;
            this.clearNotifications(oldProfileLocalId);
            this.getAccountManagerDM().getProfileDM().deleteObservers();
            this.getConversationInboxManagerDM().destroyConversationInboxDM();
            this.getAccountManagerDM().login(userId, name, email);
            this.getConversationInboxPoller().startOrStopInAppPoller();
            this.fetchConversationUpdateAndShowNotifications();
            loginSuccessful = true;
        }
        return loginSuccessful;
    }

    @Override
    public void setName(final String name) {
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.getAccountManagerDM().getProfileDM().saveName(name);
                if (StringUtils.isEmpty(name)) {
                    JavaCore.this.getConversationInboxDM().saveName(name);
                }
            }
        });
    }

    @Override
    public void setEmail(final String email) {
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.getAccountManagerDM().getProfileDM().saveEmail(email);
                if (StringUtils.isEmpty(email)) {
                    JavaCore.this.getConversationInboxDM().saveEmail(email);
                }
            }
        });
    }

    @Override
    public synchronized boolean logout() {
        boolean logoutSuccessful = false;
        if (this.isSDKSessionActive) {
            HSLogger.d(TAG, "Logout should be called before starting a Helpshift session");
        } else {
            Long oldProfileLocalId = this.getAccountManagerDM().getProfileDM().localId;
            this.clearNotifications(oldProfileLocalId);
            this.getAccountManagerDM().getProfileDM().deleteObservers();
            this.getConversationInboxManagerDM().destroyConversationInboxDM();
            this.getAccountManagerDM().logout();
            this.getConversationInboxPoller().startOrStopInAppPoller();
            this.fetchConversationUpdateAndShowNotifications();
            logoutSuccessful = true;
        }
        return logoutSuccessful;
    }

    @Override
    public void setPushToken(final String pushToken) {
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.getAccountManagerDM().savePushToken(pushToken);
            }
        });
    }

    @Override
    public void onSDKSessionStarted() {
        this.isSDKSessionActive = true;
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.getDelegate().sessionBegan();
            }
        });
    }

    @Override
    public void onSDKSessionEnded() {
        this.isSDKSessionActive = false;
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.getDelegate().sessionEnded();
            }
        });
    }

    @Override
    public void fetchServerConfig() {
        this.runParallel(new F(){

            @Override
            public void f() {
                JavaCore.this.sdkConfigurationDM.fetchServerConfig();
            }
        });
    }

    @Override
    public void setInstallCredentials(final String apiKey, final String domainName, final String platformId) {
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.sdkConfigurationDM.setInstallCredentials(apiKey, domainName, platformId);
            }
        });
    }

    @Override
    public void updateInstallConfig(final Map<String, Object> installConfig) {
        this.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.sdkConfigurationDM.updateInstallConfig(installConfig);
            }
        });
    }

    @Override
    public void updateApiConfig(final Map<String, Object> apiConfig) {
        this.runSerial(new F(){

            @Override
            public void f() {
                boolean enableFullPrivacy;
                JavaCore.this.sdkConfigurationDM.updateApiConfig(apiConfig);
                if (apiConfig.containsKey("enableFullPrivacy") && (enableFullPrivacy = ((Boolean)apiConfig.get("enableFullPrivacy")).booleanValue())) {
                    JavaCore.this.getAccountManagerDM().getProfileDM().saveName(null);
                    JavaCore.this.getAccountManagerDM().getProfileDM().saveEmail(null);
                    JavaCore.this.getConversationInboxDM().saveName(null);
                    JavaCore.this.getConversationInboxDM().saveEmail(null);
                }
            }
        });
    }

    @Override
    public void sendAnalyticsEvent() {
        this.runParallel(new F(){

            @Override
            public void f() {
                if (JavaCore.this.analyticsEventDM != null) {
                    JavaCore.this.analyticsEventDM.sendEventsToServer(JavaCore.this.getAccountManagerDM().getProfileDM());
                }
            }
        });
    }

    @Override
    public AnalyticsEventDM getAnalyticsEventDM() {
        return this.analyticsEventDM;
    }

    @Override
    public void sendAppStartEvent() {
        this.runParallel(new F(){

            @Override
            public void f() {
                JavaCore.this.analyticsEventDM.sendAppStartEvent(JavaCore.this.getAccountManagerDM().getProfileDM());
            }
        });
    }

    @Override
    public UIThreadDelegateDecorator getDelegate() {
        return this.domain.getDelegate();
    }

    @Override
    public void sendFailedApiCalls() {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.getFaqDM();
                JavaCore.this.getAccountManagerDM();
                JavaCore.this.getConversationInboxManagerDM().getConversationInboxDM();
                JavaCore.this.getAnalyticsEventDM();
                JavaCore.this.domain.getAutoRetryFailedEventDM().sendAllEvents();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountManagerDM getAccountManagerDM() {
        if (this.accountManagerDM == null) {
            JavaCore javaCore = this;
            synchronized (javaCore) {
                if (this.accountManagerDM == null) {
                    this.accountManagerDM = new AccountManagerDM(this.platform, this.domain);
                }
            }
        }
        return this.accountManagerDM;
    }

    @Override
    public MetaDataDM getMetaDataDM() {
        return this.metaDataDM;
    }

    @Override
    public CustomIssueFieldDM getCustomIssueFieldDM() {
        return this.domain.getCustomIssueFieldDM();
    }

    @Override
    public SDKConfigurationDM getSDKConfigurationDM() {
        return this.sdkConfigurationDM;
    }

    @Override
    public ConversationInboxPoller getConversationInboxPoller() {
        return this.getConversationInboxManagerDM().getConversationInboxDM().getConversationInboxPoller();
    }

    @Override
    public void handlePushNotification(final String conversationServerId, final String appName) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                JavaCore.this.getConversationInboxManagerDM().getConversationInboxDM().handlePushNotification(conversationServerId, appName);
            }
        });
    }

    @Override
    public int getNotificationCountSync() {
        return this.getConversationInboxManagerDM().getConversationInboxDM().getNotificationCountSync();
    }

    @Override
    public void getNotificationCountASync(final FetchDataFromThread<Integer> callback) {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                Integer count = null;
                try {
                    count = JavaCore.this.getConversationInboxManagerDM().getConversationInboxDM().fetchConversationsAndGetNotificationCount();
                }
                finally {
                    if (callback != null) {
                        callback.onDataFetched(count);
                    }
                }
            }
        });
    }

    @Override
    public ConversationInboxDM getConversationInboxDM() {
        return this.getConversationInboxManagerDM().getConversationInboxDM();
    }

    @Override
    public FaqsDM getFaqDM() {
        return this.domain.getFaqsDM();
    }

    @Override
    public CryptoDM getCryptoDM() {
        return this.domain.getCryptoDM();
    }

    @Override
    public LocaleProviderDM getLocaleProviderDM() {
        return this.domain.getLocaleProviderDM();
    }

    @Override
    public AttachmentFileManagerDM getAttachmentFileManagerDM() {
        return this.domain.getAttachmentFileManagerDM();
    }

    private void clearNotifications(final Long profileLocalId) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                if (profileLocalId != null) {
                    JavaCore.this.getConversationInboxManagerDM().getConversationInboxDM().clearPushNotifications(profileLocalId);
                }
            }
        });
    }

    private void fetchConversationUpdateAndShowNotifications() {
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                JavaCore.this.getConversationInboxManagerDM().getConversationInboxDM().fetchConversationUpdates();
                JavaCore.this.showNotifications(JavaCore.this.getAccountManagerDM().getProfileDM().localId);
            }
        });
    }

    void showNotifications(final Long profileLocalId) {
        this.domain.runSerial(new F(){

            @Override
            public void f() {
                if (profileLocalId != null) {
                    JavaCore.this.getConversationInboxManagerDM().getConversationInboxDM().showPushNotifications(profileLocalId);
                }
            }
        });
    }

    @Override
    public void refreshAuthToken() {
        WebSocketAuthDM webSocketAuthDM = this.domain.getWebSocketAuthDM();
        webSocketAuthDM.refreshAuthToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConversationInboxManagerDM getConversationInboxManagerDM() {
        if (this.conversationInboxManagerDM == null) {
            JavaCore javaCore = this;
            synchronized (javaCore) {
                if (this.conversationInboxManagerDM == null) {
                    this.conversationInboxManagerDM = new ConversationInboxManagerDM(this.platform, this.domain, this.getAccountManagerDM());
                }
            }
        }
        return this.conversationInboxManagerDM;
    }

    private void runSerial(F f) {
        this.serialThreader.thread(f).f();
    }

    private void runParallel(F f) {
        this.parallelThreader.thread(f).f();
    }
}

