/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account.dao;

import com.helpshift.account.dao.AccountManagerDAO;
import com.helpshift.account.dao.ProfileDAO;
import com.helpshift.account.dao.ProfileDTO;
import com.helpshift.common.platform.KVStore;
import com.helpshift.support.ProfilesManager;

public class AndroidAccountManagerAndProfileDAO
implements AccountManagerDAO,
ProfileDAO {
    private ProfilesManager profilesManager;
    private KVStore kvStore;
    private static final String LOGIN_IDENTIFIER = "loginIdentifier";
    private static final String DEVICE_IDENTIFIER = "deviceId";
    private static final String DEVICE_TOKEN = "deviceToken";
    private static final String DEFAULT_USER_LOGIN_KEY = "default_user_login";
    private static final String DEFAULT_USER_PROFILE = "default_user_profile";

    public AndroidAccountManagerAndProfileDAO(ProfilesManager profilesManager, KVStore kvStore) {
        this.profilesManager = profilesManager;
        this.kvStore = kvStore;
    }

    @Override
    public void saveLoginId(String loginId) {
        this.kvStore.setString(LOGIN_IDENTIFIER, loginId);
    }

    @Override
    public String getLoginId() {
        return this.kvStore.getString(LOGIN_IDENTIFIER, "");
    }

    @Override
    public void saveUserIdentifier(String userIdentifier) {
        this.kvStore.setString(DEVICE_IDENTIFIER, userIdentifier);
    }

    @Override
    public String getUserIdentifier() {
        return this.kvStore.getString(DEVICE_IDENTIFIER, "");
    }

    @Override
    public void savePushToken(String pushToken) {
        this.kvStore.setString(DEVICE_TOKEN, pushToken);
    }

    @Override
    public String getPushToken() {
        return this.kvStore.getString(DEVICE_TOKEN, "");
    }

    @Override
    public ProfileDTO readProfile(String identifier) {
        ProfileDTO result = null;
        if (this.isDefaultProfile(identifier)) {
            Object defaultProfile = this.kvStore.getSerializable(DEFAULT_USER_PROFILE);
            if (defaultProfile instanceof ProfileDTO) {
                result = (ProfileDTO)defaultProfile;
            }
        } else {
            result = this.profilesManager.readProfile(identifier);
        }
        return result;
    }

    @Override
    public void saveDefaultLoginId(String defaultLoginId) {
        this.kvStore.setString(DEFAULT_USER_LOGIN_KEY, defaultLoginId);
    }

    @Override
    public String getDefaultLoginId() {
        return this.kvStore.getString(DEFAULT_USER_LOGIN_KEY);
    }

    private boolean isDefaultProfile(String identifier) {
        String defaultLoginId = this.getDefaultLoginId();
        return defaultLoginId != null && defaultLoginId.equals(identifier);
    }

    @Override
    public ProfileDTO insertOrUpdateProfile(ProfileDTO profileDTO) {
        ProfileDTO result;
        if (this.isDefaultProfile(profileDTO.identifier)) {
            if (profileDTO.localId == null) {
                long profileLocalId = 100000 + Math.abs(profileDTO.identifier.hashCode()) % 1000;
                profileDTO = new ProfileDTO(profileLocalId, profileDTO.identifier, profileDTO.serverId, profileDTO.name, profileDTO.email, profileDTO.saltedIdentifier, profileDTO.uid, profileDTO.did, profileDTO.isPushTokenSynced);
            }
            this.kvStore.setSerializable(DEFAULT_USER_PROFILE, profileDTO);
            result = profileDTO;
        } else {
            this.profilesManager.addProfile(profileDTO);
            result = this.profilesManager.readProfile(profileDTO.identifier);
        }
        return result;
    }
}

