/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account.domainmodel;

import com.helpshift.account.dao.AccountManagerDAO;
import com.helpshift.account.dao.ProfileDTO;
import com.helpshift.account.domainmodel.ProfileDM;
import com.helpshift.common.AutoRetriableDM;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.F;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import java.util.UUID;

public class AccountManagerDM
implements AutoRetriableDM {
    private final Platform platform;
    final Domain domain;
    private final AccountManagerDAO accountManagerDAO;
    private ProfileDM profileDM;

    public AccountManagerDM(Platform platform, Domain domain) {
        this.platform = platform;
        this.domain = domain;
        this.accountManagerDAO = platform.getAccountManagerDAO();
        this.domain.getAutoRetryFailedEventDM().register(AutoRetryFailedEventDM.EventType.ACCOUNT, this);
    }

    public void login(String userId, String name, String email) {
        this.profileDM = null;
        this.accountManagerDAO.saveLoginId(userId);
        this.getProfileDM().saveName(name);
        this.getProfileDM().saveEmail(email);
    }

    public void logout() {
        this.profileDM = null;
        this.accountManagerDAO.saveLoginId(null);
    }

    public void savePushToken(String pushToken) {
        this.accountManagerDAO.savePushToken(pushToken);
        this.getProfileDM().setPushToken(pushToken);
        this.domain.runParallel(new F(){

            @Override
            public void f() {
                try {
                    AccountManagerDM.this.getProfileDM().sendPushToken();
                }
                catch (RootAPIException e) {
                    AccountManagerDM.this.domain.getAutoRetryFailedEventDM().scheduleRetryTaskForEventType(AutoRetryFailedEventDM.EventType.ACCOUNT, e.getServerStatusCode());
                    throw e;
                }
            }
        });
    }

    private String getDefaultLoginId() {
        String defaultLoginId = this.accountManagerDAO.getDefaultLoginId();
        if (StringUtils.isEmpty(defaultLoginId)) {
            defaultLoginId = UUID.randomUUID().toString();
            this.accountManagerDAO.saveDefaultLoginId(defaultLoginId);
        }
        return defaultLoginId;
    }

    private String getLoginOrDefaultId() {
        String id = this.accountManagerDAO.getLoginId();
        if (StringUtils.isEmpty(id)) {
            id = this.getDefaultLoginId();
        }
        return id;
    }

    private ProfileDTO getProfileDto() {
        String id = this.getLoginOrDefaultId();
        ProfileDTO profileDTO = this.accountManagerDAO.readProfile(id);
        if (profileDTO == null) {
            String saltedIdentifier = this.getDefaultLoginId().equals(id) ? id : id + "_" + UUID.randomUUID().toString();
            profileDTO = new ProfileDTO(null, id, null, null, null, saltedIdentifier, null, null, false);
        }
        return profileDTO;
    }

    public synchronized ProfileDM getProfileDM() {
        if (this.profileDM == null) {
            ProfileDTO profileDTO = this.getProfileDto();
            this.profileDM = new ProfileDM(this.platform, this.domain, profileDTO);
            this.profileDM.pushToken = this.accountManagerDAO.getPushToken();
            this.profileDM.setUserIdentifier(this.accountManagerDAO.getUserIdentifier());
            if (this.profileDM.localId == null) {
                this.profileDM.createLocal();
            }
        }
        return this.profileDM;
    }

    public void setUserIdentifier(String userIdentifier) {
        this.getProfileDM().setUserIdentifier(userIdentifier);
        this.accountManagerDAO.saveUserIdentifier(userIdentifier);
    }

    @Override
    public void sendFailedApiCalls() {
        this.getProfileDM().sendPushToken();
    }
}

