/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.account.domainmodel;

import com.helpshift.account.dao.ProfileDAO;
import com.helpshift.account.dao.ProfileDTO;
import com.helpshift.account.response.CreateProfileResponse;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.domain.network.TSCorrectedNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.providers.ICampaignsDataProvider;
import java.util.HashMap;
import java.util.Observable;

public class ProfileDM
extends Observable {
    private final Domain domain;
    private final Platform platform;
    private final ProfileDAO profileDAO;
    private final ResponseParser responseParser;
    public Long localId;
    public String serverId;
    public String identifier;
    public String name;
    public String email;
    public String saltedIdentifier;
    public String pushToken;
    public String uid;
    public String did;
    public boolean isPushTokenSynced;
    private String userIdentifier;

    ProfileDM(Platform platform, Domain domain, ProfileDTO profileDTO) {
        this.platform = platform;
        this.domain = domain;
        this.profileDAO = platform.getProfileDAO();
        this.responseParser = platform.getResponseParser();
        this.hydrate(profileDTO);
    }

    void setUserIdentifier(String userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    void createLocal() {
        this.hydrate(this.profileDAO.insertOrUpdateProfile(this.toDTO()));
    }

    private ProfileDTO toDTO() {
        return new ProfileDTO(this.localId, this.identifier, this.serverId, this.name, this.email, this.saltedIdentifier, this.uid, this.did, this.isPushTokenSynced);
    }

    private void hydrate(ProfileDTO profileDTO) {
        this.localId = profileDTO.localId;
        this.serverId = profileDTO.serverId;
        this.identifier = profileDTO.identifier;
        this.name = profileDTO.name;
        this.email = profileDTO.email;
        this.saltedIdentifier = profileDTO.saltedIdentifier;
        this.uid = profileDTO.uid;
        this.did = profileDTO.did;
        this.isPushTokenSynced = profileDTO.isPushTokenSynced;
    }

    public void saveName(String name) {
        this.name = name;
        this.profileDAO.insertOrUpdateProfile(this.toDTO());
    }

    public void saveEmail(String email) {
        this.email = email;
        this.profileDAO.insertOrUpdateProfile(this.toDTO());
    }

    public String getUserIdentifier() {
        if (!this.isDefaultLogin()) {
            return this.identifier;
        }
        return this.userIdentifier;
    }

    public boolean isDefaultLogin() {
        return this.identifier.equals(this.saltedIdentifier);
    }

    public String createProfile(String userName, String userEmail) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("identifier", this.saltedIdentifier);
        data.put("displayname", userName);
        data.put("email", userEmail);
        Network network = this.buildCreateProfileNetwork();
        Response response = network.makeRequest(data);
        CreateProfileResponse createProfileResponse = this.responseParser.parseCreateProfileResponse(response.responseString);
        this.serverId = createProfileResponse.id;
        this.profileDAO.insertOrUpdateProfile(this.toDTO());
        this.sendPushToken();
        return this.serverId;
    }

    private Network buildCreateProfileNetwork() {
        Network network = new POSTNetwork("/profiles/", this.domain, this.platform);
        network = new TSCorrectedNetwork(network, this.platform);
        return new GuardOKNetwork(network);
    }

    private Network buildUpdatePushTokenNetwork() {
        Network network = new POSTNetwork("/update-ua-token/", this.domain, this.platform);
        network = new TSCorrectedNetwork(network, this.platform);
        network = new FailedAPICallNetworkDecorator(network);
        return new GuardOKNetwork(network);
    }

    void sendPushToken() {
        if (!(StringUtils.isEmpty(this.pushToken) || StringUtils.isEmpty(this.serverId) || this.isPushTokenSynced)) {
            this.updatePushTokenInternal();
        }
    }

    void updatePushTokenInternal() {
        block2: {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("profile-id", this.serverId);
            data.put("token", this.pushToken);
            Network request = this.buildUpdatePushTokenNetwork();
            try {
                request.makeRequest(data);
                this.isPushTokenSynced = true;
                this.profileDAO.insertOrUpdateProfile(this.toDTO());
                this.setChanged();
                this.notifyObservers();
            }
            catch (RootAPIException e) {
                if (e.exceptionType == NetworkException.NON_RETRIABLE) break block2;
                throw e;
            }
        }
    }

    public void updateCampaignUidAndDid() {
        ICampaignsDataProvider campaignsDataProvider = this.platform.getCampaignDataProvider();
        boolean shouldUpdateInDB = false;
        if (campaignsDataProvider == null) {
            if (!StringUtils.isEmpty(this.uid)) {
                this.uid = null;
                shouldUpdateInDB = true;
            }
            if (!StringUtils.isEmpty(this.did)) {
                this.did = null;
                shouldUpdateInDB = true;
            }
        } else {
            if (StringUtils.isEmpty(this.uid)) {
                this.uid = campaignsDataProvider.getUserIdentifier();
                shouldUpdateInDB = true;
            }
            if (StringUtils.isEmpty(this.did)) {
                this.did = campaignsDataProvider.getDeviceIdentifier();
                shouldUpdateInDB = true;
            }
        }
        if (shouldUpdateInDB) {
            this.profileDAO.insertOrUpdateProfile(this.toDTO());
        }
    }

    public void setPushToken(String newPushToken) {
        if (StringUtils.isEmpty(this.pushToken) || !this.pushToken.equals(newPushToken)) {
            this.pushToken = newPushToken;
            this.isPushTokenSynced = false;
            this.profileDAO.insertOrUpdateProfile(this.toDTO());
        }
    }
}

