/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.analytics.domainmodel;

import com.helpshift.account.domainmodel.ProfileDM;
import com.helpshift.analytics.AnalyticsEventDAO;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.analytics.dto.AnalyticsEventDTO;
import com.helpshift.common.AutoRetriableDM;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.FailedAPICallNetworkDecorator;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.domain.network.POSTNetwork;
import com.helpshift.common.exception.NetworkException;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Device;
import com.helpshift.common.platform.Jsonifier;
import com.helpshift.common.platform.Platform;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class AnalyticsEventDM
implements AutoRetriableDM {
    private final Domain domain;
    private final Platform platform;
    private final Jsonifier jsonifier;
    private final AnalyticsEventDAO analyticsEventDAO;
    private static final DecimalFormat tsSecFormatter = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
    private List<AnalyticsEventDTO> eventModelList;
    private SDKConfigurationDM sdkConfigurationDM;

    public AnalyticsEventDM(Domain domain, Platform platform) {
        this.domain = domain;
        this.platform = platform;
        this.jsonifier = platform.getJsonifier();
        this.analyticsEventDAO = platform.getAnalyticsEventDAO();
        this.sdkConfigurationDM = domain.getSDKConfigurationDM();
        this.domain.getAutoRetryFailedEventDM().register(AutoRetryFailedEventDM.EventType.ANALYTICS, this);
    }

    private void addEventToStorage(AnalyticsEventDTO eventModel) {
        if (this.eventModelList == null) {
            this.eventModelList = new ArrayList<AnalyticsEventDTO>();
        }
        this.eventModelList.add(eventModel);
    }

    public synchronized void pushEvent(AnalyticsEventType type, Map<String, Object> data) {
        String timestamp = tsSecFormatter.format((double)System.currentTimeMillis() / 1000.0);
        String uuid = UUID.randomUUID().toString();
        this.addEventToStorage(new AnalyticsEventDTO(uuid, type, data, timestamp));
    }

    public synchronized void pushEvent(AnalyticsEventType analyticsEventType, String id) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", id);
        this.pushEvent(analyticsEventType, data);
    }

    public synchronized void pushEvent(AnalyticsEventType analyticsEventType) {
        this.pushEvent(analyticsEventType, (Map<String, Object>)null);
    }

    public void sendEventsToServer(ProfileDM profileDM) {
        List<AnalyticsEventDTO> analyticsEventDTOs = this.getCurrentSessionEventsCopy();
        this.clearAnalyticsEvent();
        this.sendEvents(analyticsEventDTOs, profileDM);
    }

    @Override
    public void sendFailedApiCalls() {
        Map<String, HashMap<String, String>> analyticsMapList = this.analyticsEventDAO.getUnsentAnalytics();
        if (analyticsMapList != null && analyticsMapList.size() > 0) {
            Network network = this.getAnalyticsNetwork();
            for (String key : analyticsMapList.keySet()) {
                try {
                    network.makeRequest((Map<String, String>)analyticsMapList.get(key));
                    this.analyticsEventDAO.removeAnalyticsData(key);
                }
                catch (RootAPIException e) {
                    if (e.exceptionType == NetworkException.NON_RETRIABLE) {
                        this.analyticsEventDAO.removeAnalyticsData(key);
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    private void sendEvents(List<AnalyticsEventDTO> analyticsEventDTOList, ProfileDM profileDM) {
        block3: {
            if (!ListUtils.isEmpty(analyticsEventDTOList)) {
                String data = this.jsonifier.jsonifyAnalyticsDTOList(analyticsEventDTOList);
                HashMap<String, String> analyticsMap = this.buildEventRequestMap(data, profileDM);
                try {
                    this.getAnalyticsNetwork().makeRequest(analyticsMap);
                }
                catch (RootAPIException e) {
                    if (e.exceptionType == NetworkException.NON_RETRIABLE) break block3;
                    String key = UUID.randomUUID().toString();
                    this.analyticsEventDAO.saveUnsentAnalyticsData(key, analyticsMap);
                    this.domain.getAutoRetryFailedEventDM().scheduleRetryTaskForEventType(AutoRetryFailedEventDM.EventType.ANALYTICS, e.getServerStatusCode());
                    throw e;
                }
            }
        }
    }

    private Network getAnalyticsNetwork() {
        Network network = new POSTNetwork("/events/", this.domain, this.platform);
        network = new FailedAPICallNetworkDecorator(network);
        return new GuardOKNetwork(network);
    }

    private HashMap<String, String> buildEventRequestMap(String data, ProfileDM profileDM) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("e", data);
        if (profileDM != null) {
            params.put("id", profileDM.saltedIdentifier);
            params.put("profile-id", profileDM.serverId);
            String userIdentifier = profileDM.getUserIdentifier();
            if (!StringUtils.isEmpty(userIdentifier)) {
                params.put("uid", userIdentifier);
            }
        }
        Device device = this.platform.getDevice();
        params.put("v", device.getSDKVersion());
        params.put("os", device.getOSVersion());
        params.put("av", device.getAppVersion());
        params.put("dm", device.getDeviceModel());
        params.put("s", this.sdkConfigurationDM.getString("sdkType"));
        String pluginVersion = this.sdkConfigurationDM.getString("pluginVersion");
        String runtimeVersion = this.sdkConfigurationDM.getString("runtimeVersion");
        if (!StringUtils.isEmpty(pluginVersion)) {
            params.put("pv", pluginVersion);
        }
        if (!StringUtils.isEmpty(runtimeVersion)) {
            params.put("rv", runtimeVersion);
        }
        params.put("rs", device.getRom());
        String cc = device.getSimCountryIso();
        if (!StringUtils.isEmpty(cc)) {
            params.put("cc", cc);
        }
        params.put("ln", device.getLanguage());
        return params;
    }

    public synchronized void clearAnalyticsEvent() {
        if (this.eventModelList != null) {
            this.eventModelList.clear();
        }
    }

    public synchronized List<AnalyticsEventDTO> getCurrentSessionEventsCopy() {
        ArrayList<AnalyticsEventDTO> copy = new ArrayList<AnalyticsEventDTO>();
        if (this.eventModelList != null) {
            copy.addAll(this.eventModelList);
        }
        return copy;
    }

    public void sendAppStartEvent(ProfileDM profileDM) {
        String uuid = UUID.randomUUID().toString();
        String timestamp = tsSecFormatter.format((double)System.currentTimeMillis() / 1000.0);
        AnalyticsEventDTO analyticsEventDTO = new AnalyticsEventDTO(uuid, AnalyticsEventType.APP_START, null, timestamp);
        this.sendEvents(Collections.singletonList(analyticsEventDTO), profileDM);
    }
}

