/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.android.commons.downloader;

import android.content.Context;
import android.text.TextUtils;
import com.helpshift.android.commons.downloader.DownloadConfig;
import com.helpshift.android.commons.downloader.DownloadRunnable;
import com.helpshift.android.commons.downloader.contracts.DownloaderKeyValueStorage;
import com.helpshift.android.commons.downloader.contracts.OnDownloadFinishListener;
import com.helpshift.android.commons.downloader.contracts.OnProgressChangedListener;
import com.helpshift.util.HSLogger;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;

public class DownloadManager {
    private static final String TAG = "Helpshift_DownloadMngr";
    private static final String KEY_CACHED_DOWNLOADS = "hs-cached-downloads";
    ConcurrentHashMap<String, ConcurrentLinkedQueue<OnDownloadFinishListener>> activeDownloadFinishListeners;
    ConcurrentHashMap<String, ConcurrentLinkedQueue<OnProgressChangedListener>> activeProgressChangeListeners;
    private ThreadPoolExecutor downloadExecutor;
    private DownloaderKeyValueStorage storage;
    private Context context;

    public DownloadManager(Context context, DownloaderKeyValueStorage storage, ThreadPoolExecutor downloadExecutor) {
        this.context = context;
        this.storage = storage;
        this.downloadExecutor = downloadExecutor;
        this.activeDownloadFinishListeners = new ConcurrentHashMap();
        this.activeProgressChangeListeners = new ConcurrentHashMap();
    }

    public void startDownload(String url, final DownloadConfig downloadConfig, OnDownloadFinishListener onDownloadFinishListener, OnProgressChangedListener onProgressChangedListener) {
        HSLogger.d(TAG, "Scheduling download in executor : " + url);
        if (downloadConfig.useCache && !TextUtils.isEmpty((CharSequence)this.getAvailableCacheFile(url))) {
            onDownloadFinishListener.onDownloadFinish(true, url, this.getAvailableCacheFile(url));
            return;
        }
        if (this.activeDownloadFinishListeners.get(url) != null && this.activeProgressChangeListeners.get(url) != null) {
            if (onDownloadFinishListener != null) {
                this.activeDownloadFinishListeners.get(url).add(onDownloadFinishListener);
            }
            if (onProgressChangedListener != null) {
                this.activeProgressChangeListeners.get(url).add(onProgressChangedListener);
            }
            return;
        }
        ConcurrentLinkedQueue<OnDownloadFinishListener> finishListeners = new ConcurrentLinkedQueue<OnDownloadFinishListener>();
        if (onDownloadFinishListener != null) {
            finishListeners.add(onDownloadFinishListener);
        }
        this.activeDownloadFinishListeners.put(url, finishListeners);
        ConcurrentLinkedQueue<OnProgressChangedListener> progressListeners = new ConcurrentLinkedQueue<OnProgressChangedListener>();
        if (onProgressChangedListener != null) {
            progressListeners.add(onProgressChangedListener);
        }
        this.activeProgressChangeListeners.put(url, progressListeners);
        OnDownloadFinishListener finishListener = new OnDownloadFinishListener(){

            @Override
            public void onDownloadFinish(boolean success, String url, Object responseObject) {
                ConcurrentLinkedQueue<OnDownloadFinishListener> downloadFinishListeners;
                if (success && downloadConfig.writeToFile) {
                    DownloadManager.this.addToCache(url, responseObject.toString());
                }
                if ((downloadFinishListeners = DownloadManager.this.activeDownloadFinishListeners.get(url)) != null) {
                    for (OnDownloadFinishListener listener : downloadFinishListeners) {
                        if (listener == null) continue;
                        listener.onDownloadFinish(success, url, responseObject);
                    }
                    DownloadManager.this.activeDownloadFinishListeners.remove(url);
                    DownloadManager.this.activeProgressChangeListeners.remove(url);
                }
            }
        };
        OnProgressChangedListener progressChangedListener = new OnProgressChangedListener(){

            @Override
            public void onProgressChanged(String url, int progress) {
                ConcurrentLinkedQueue<OnProgressChangedListener> progressChangedListeners = DownloadManager.this.activeProgressChangeListeners.get(url);
                if (progressChangedListeners != null) {
                    for (OnProgressChangedListener listener : progressChangedListeners) {
                        if (listener == null) continue;
                        listener.onProgressChanged(url, progress);
                    }
                }
            }
        };
        DownloadRunnable downloadRunnable = new DownloadRunnable(this.context, this.storage, url, downloadConfig, finishListener, progressChangedListener);
        this.downloadExecutor.execute(downloadRunnable);
    }

    void addToCache(String url, String filePath) {
        HashMap<String, String> cachedDownloads = (HashMap<String, String>)this.storage.get(KEY_CACHED_DOWNLOADS);
        if (cachedDownloads == null) {
            cachedDownloads = new HashMap<String, String>();
        }
        cachedDownloads.put(url, filePath);
        this.storage.set(KEY_CACHED_DOWNLOADS, cachedDownloads);
    }

    private String getAvailableCacheFile(String url) {
        String cacheFilePath = null;
        HashMap cachedDownloads = (HashMap)this.storage.get(KEY_CACHED_DOWNLOADS);
        if (cachedDownloads != null && !TextUtils.isEmpty((CharSequence)(cacheFilePath = (String)cachedDownloads.get(url)))) {
            File file = new File(cacheFilePath);
            if (file.exists() && file.canRead()) {
                return cacheFilePath;
            }
            cacheFilePath = null;
        }
        return cacheFilePath;
    }
}

