/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.app;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.helpshift.app.LifecycleListener;
import com.helpshift.common.domain.HSThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;

@TargetApi(value=14)
public class MainLifecycleCallback
implements Application.ActivityLifecycleCallbacks {
    public static final int FOREGROUND = 1;
    public static final int BACKGROUND = 2;
    private static boolean foreground;
    private static boolean isConfigurationChanged;
    final LinkedBlockingDeque<LifecycleListener> lifecycleListeners = new LinkedBlockingDeque();
    private final ExecutorService cachedExecutorService = Executors.newCachedThreadPool(new HSThreadFactory("m-lcycle"));
    AtomicInteger startCount = new AtomicInteger(0);
    AtomicInteger stopCount = new AtomicInteger(0);

    public static boolean isForeground() {
        return foreground;
    }

    private void dispatchLifecycleEvent(final int lifecycleEvent) {
        this.cachedExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                for (LifecycleListener listener : MainLifecycleCallback.this.lifecycleListeners) {
                    switch (lifecycleEvent) {
                        case 1: {
                            listener.onForeground();
                            break;
                        }
                        case 2: {
                            listener.onBackground();
                            break;
                        }
                    }
                }
            }
        });
    }

    public void addLifecycleListener(final LifecycleListener listener) {
        this.lifecycleListeners.addFirst(listener);
        this.cachedExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                if (MainLifecycleCallback.this.startCount.get() == 1) {
                    listener.onForeground();
                    if (MainLifecycleCallback.this.stopCount.get() == 1) {
                        listener.onBackground();
                    }
                }
            }
        });
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
        if (!isConfigurationChanged) {
            if (!foreground) {
                this.dispatchLifecycleEvent(1);
                foreground = true;
            }
            this.startCount.incrementAndGet();
        }
        isConfigurationChanged = false;
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        if (activity != null && activity.isChangingConfigurations()) {
            isConfigurationChanged = true;
        } else {
            isConfigurationChanged = false;
            this.stopCount.incrementAndGet();
            if (this.startCount.get() == this.stopCount.get()) {
                this.dispatchLifecycleEvent(2);
                foreground = false;
            }
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    static {
        isConfigurationChanged = false;
    }
}

