/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.auth.domainmodel;

import com.helpshift.auth.dto.WebSocketAuthData;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.domain.network.GETNetwork;
import com.helpshift.common.domain.network.GuardOKNetwork;
import com.helpshift.common.domain.network.Network;
import com.helpshift.common.exception.RootAPIException;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.Response;
import com.helpshift.common.platform.network.ResponseParser;
import com.helpshift.util.HSLogger;
import java.util.HashMap;
import java.util.Map;

public class WebSocketAuthDM {
    private static final String TAG = "Helpshift_WebSocketAuthDM";
    private final Object fetchSyncObject = new Object();
    private WebSocketAuthData authData;
    private Domain domain;
    private Platform platform;
    private ResponseParser responseParser;

    public WebSocketAuthDM(Domain domain, Platform platform) {
        this.domain = domain;
        this.platform = platform;
        this.responseParser = platform.getResponseParser();
    }

    public WebSocketAuthData getAuthToken() {
        if (this.authData == null) {
            this.fetchNewTokenInternal();
        }
        return this.authData;
    }

    public WebSocketAuthData refreshAuthToken() {
        this.fetchNewTokenInternal();
        return this.authData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchNewTokenInternal() {
        this.authData = null;
        Object object = this.fetchSyncObject;
        synchronized (object) {
            if (this.authData == null) {
                HSLogger.d(TAG, "Fetching auth token");
                Network network = new GETNetwork("/ws-config/", this.domain, this.platform);
                network = new GuardOKNetwork(network);
                try {
                    Response response = network.makeRequest(this.getRequestData());
                    this.authData = this.responseParser.parseAuthToken(response.responseString);
                    HSLogger.d(TAG, "Auth token fetch successful");
                }
                catch (RootAPIException e) {
                    HSLogger.e(TAG, "Exception in fetching auth token", e);
                    this.authData = null;
                }
            }
        }
    }

    private Map<String, String> getRequestData() {
        HashMap<String, String> requestData = new HashMap<String, String>();
        requestData.put("platform-id", this.platform.getAppId());
        return requestData;
    }
}

