/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns;

import android.app.Activity;
import android.app.Application;
import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import com.helpshift.Core;
import com.helpshift.campaigns.activities.ParentActivity;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.delegates.InboxMessageDelegate;
import com.helpshift.campaigns.models.CampaignDetailModel;
import com.helpshift.campaigns.models.PropertyValue;
import com.helpshift.campaigns.network.NetworkManagerFactory;
import com.helpshift.campaigns.observers.CampaignStorageObserver;
import com.helpshift.campaigns.providers.CampaignsDataProvider;
import com.helpshift.campaigns.storage.StorageFactory;
import com.helpshift.campaigns.util.CampaignsNotification;
import com.helpshift.campaigns.util.InAppCampaignsUtil;
import com.helpshift.executors.ActionExecutor;
import com.helpshift.executors.CampaignActionExecutor;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.notifications.NotificationChannelsManager;
import com.helpshift.providers.CrossModuleDataProvider;
import com.helpshift.util.ActivityUtil;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.concurrent.ApiExecutor;
import com.helpshift.util.concurrent.ApiExecutorFactory;
import com.helpshift.util.concurrent.RunnableUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Campaigns
implements Core.ApiProvider,
CampaignStorageObserver {
    private static final String TAG = "Helpshift_Campaigns";
    static InboxMessageDelegate delegate;

    Campaigns() {
    }

    public static Campaigns getInstance() {
        return LazyHolder.INSTANCE;
    }

    public static boolean addProperty(@NonNull String key, @NonNull String value) {
        return Campaigns.addPropertyInternal(key, value);
    }

    public static boolean addProperty(@NonNull String key, @NonNull Integer value) {
        Long longValue = value != null ? Long.valueOf(value.intValue()) : null;
        return Campaigns.addPropertyInternal(key, longValue);
    }

    public static boolean addProperty(@NonNull String key, @NonNull Long value) {
        return Campaigns.addPropertyInternal(key, value);
    }

    public static boolean addProperty(@NonNull String key, @NonNull Boolean value) {
        return Campaigns.addPropertyInternal(key, value);
    }

    public static boolean addProperty(@NonNull String key, @NonNull Date value) {
        return Campaigns.addPropertyInternal(key, value);
    }

    private static boolean addPropertyInternal(final @NonNull String key, final @NonNull Object value) {
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        RunnableUtil.RunnableFuture<Boolean> booleanRunnableFuture = apiExecutor.callAndReturn(new RunnableUtil.ValueRunnable<Boolean>(){

            @Override
            public void run() {
                this.runnableValue = ControllerFactory.getInstance().userController.addProperty(key, new PropertyValue(value));
            }
        });
        return booleanRunnableFuture.get();
    }

    public static String[] addProperties(final @NonNull Map<String, Object> keyValues) {
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        RunnableUtil.RunnableFuture<String[]> stringARunnableFuture = apiExecutor.callAndReturn(new RunnableUtil.ValueRunnable<String[]>(){

            @Override
            public void run() {
                HashMap<String, PropertyValue> properties = new HashMap<String, PropertyValue>();
                for (Map.Entry entry : keyValues.entrySet()) {
                    if (entry.getValue() instanceof Location) continue;
                    PropertyValue value = entry.getValue() instanceof Integer ? new PropertyValue((Integer)entry.getValue()) : new PropertyValue(entry.getValue());
                    properties.put((String)entry.getKey(), value);
                }
                this.runnableValue = ControllerFactory.getInstance().userController.addProperties(properties);
            }
        });
        return stringARunnableFuture.get();
    }

    public static void showInbox(final Activity activity) {
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                HSLogger.d(Campaigns.TAG, "Show Inbox");
                Intent intent = new Intent((Context)activity, ParentActivity.class);
                intent.putExtra("showInFullScreen", (Serializable)ActivityUtil.isFullScreen(activity));
                intent.putExtra("launch_source", 2);
                activity.startActivity(intent);
                ControllerFactory.getInstance().deviceController.resetPoller();
            }
        });
    }

    public static void showMessage(final String messageId, final Activity activity) {
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                HSLogger.d(Campaigns.TAG, "Show message : Id : " + messageId);
                Intent intent = new Intent((Context)activity, ParentActivity.class);
                intent.putExtra("showInFullScreen", (Serializable)ActivityUtil.isFullScreen(activity));
                intent.putExtra("launch_source", 3);
                intent.putExtra("campaignId", messageId);
                activity.startActivity(intent);
            }
        });
    }

    public static int getCountOfUnreadMessages() {
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        RunnableUtil.RunnableFuture<Integer> integerRunnableFuture = apiExecutor.callAndReturn(new RunnableUtil.ValueRunnable<Integer>(){

            @Override
            public void run() {
                int unreadCampaignCount = 0;
                List<CampaignDetailModel> unreadCampaigns = InAppCampaignsUtil.cleanAndGetActiveCampaigns(StorageFactory.getInstance().campaignStorage, false, ControllerFactory.getInstance().userController.getCurrentUser().identifier);
                if (unreadCampaigns != null) {
                    unreadCampaignCount = unreadCampaigns.size();
                }
                this.runnableValue = unreadCampaignCount;
            }
        });
        return integerRunnableFuture.get();
    }

    public static void setInboxMessageDelegate(final InboxMessageDelegate inboxMessageDelegate) {
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                delegate = inboxMessageDelegate;
                if (inboxMessageDelegate != null) {
                    StorageFactory.getInstance().campaignStorage.addObserver(Campaigns.getInstance());
                } else {
                    StorageFactory.getInstance().campaignStorage.removeObserver(Campaigns.getInstance());
                }
            }
        });
    }

    public static void configure(Map config) {
        Object muteNotifications = config.get("muteNotifications");
        if (muteNotifications != null && muteNotifications instanceof Boolean) {
            InfoModelFactory.getInstance().appInfoModel.setMuteNotifications((Boolean)muteNotifications);
        } else {
            InfoModelFactory.getInstance().appInfoModel.setMuteNotifications(false);
        }
    }

    @Override
    public void _preInstall(Application application, String apiKey, String domain, String appId, Map<String, Object> config) {
        HelpshiftContext.setApplicationContext((Context)application);
    }

    @Override
    public void _install(@NonNull Application application, @NonNull String apiKey, @NonNull String domain, @NonNull String appId, @NonNull Map<String, Object> config) {
        Object screenOrientation;
        Object largeNotificationIconResourceId;
        Object campaignsNotificationChannelId;
        Object notificationIconResourceId;
        CrossModuleDataProvider.setCampaignsDataProvider(new CampaignsDataProvider());
        com.helpshift.storage.StorageFactory hsStorageFactory = com.helpshift.storage.StorageFactory.getInstance();
        StorageFactory campaignsStorageFactory = StorageFactory.getInstance();
        InfoModelFactory infoModelFactory = InfoModelFactory.getInstance();
        Object enableInboxPollingObj = config.get("enableInboxPolling");
        boolean enableInboxPolling = enableInboxPollingObj instanceof Boolean ? (Boolean)enableInboxPollingObj : true;
        infoModelFactory.appInfoModel.setEnableInboxPolling(enableInboxPolling);
        com.helpshift.controllers.ControllerFactory controllerFactory = com.helpshift.controllers.ControllerFactory.getInstance();
        ControllerFactory campaignsControllerFactory = ControllerFactory.getInstance();
        NetworkManagerFactory networkManagerFactory = NetworkManagerFactory.getInstance();
        if (InfoModelFactory.getInstance().appInfoModel.isInstalled()) {
            InfoModelFactory.getInstance().sdkInfoModel.setFirstLaunch(false);
        } else {
            InfoModelFactory.getInstance().sdkInfoModel.setFirstLaunch(true);
        }
        InfoModelFactory.getInstance().appInfoModel.install(apiKey, domain, appId);
        Object fontPathObj = config.get("font");
        if (fontPathObj instanceof String) {
            String fontPath = (String)fontPathObj;
            InfoModelFactory.getInstance().appInfoModel.setFontPath(fontPath);
        } else {
            InfoModelFactory.getInstance().appInfoModel.setFontPath(null);
        }
        Object notificationSoundResourceId = config.get("notificationSound");
        if (notificationSoundResourceId != null && notificationSoundResourceId instanceof Integer) {
            InfoModelFactory.getInstance().appInfoModel.setNotificationSoundId((Integer)notificationSoundResourceId);
        }
        if ((notificationIconResourceId = config.get("notificationIcon")) != null && notificationIconResourceId instanceof Integer) {
            InfoModelFactory.getInstance().appInfoModel.setNotificationIconId((Integer)notificationIconResourceId);
        }
        if ((campaignsNotificationChannelId = config.get("campaignsNotificationChannelId")) instanceof String) {
            InfoModelFactory.getInstance().appInfoModel.setCampaignsNotificationChannelId((String)campaignsNotificationChannelId);
        }
        if ((largeNotificationIconResourceId = config.get("largeNotificationIcon")) != null && largeNotificationIconResourceId instanceof Integer) {
            InfoModelFactory.getInstance().appInfoModel.setLargeNotificationIconId((Integer)config.get("largeNotificationIcon"));
        }
        if ((screenOrientation = config.get("screenOrientation")) instanceof Integer) {
            InfoModelFactory.getInstance().appInfoModel.setScreenOrientation((Integer)screenOrientation);
        } else {
            InfoModelFactory.getInstance().appInfoModel.setScreenOrientation(-1);
        }
        Object sdkType = config.get("sdkType");
        if (sdkType != null && sdkType instanceof String) {
            campaignsControllerFactory.deviceController.setDevelopmentPlatform((String)sdkType);
        } else {
            campaignsControllerFactory.deviceController.setDevelopmentPlatform("android");
        }
        Object disableHelpshiftBranding = config.get("disableHelpshiftBranding");
        if (disableHelpshiftBranding != null && disableHelpshiftBranding instanceof Boolean) {
            InfoModelFactory.getInstance().appInfoModel.setDisableHelpshiftBranding((Boolean)disableHelpshiftBranding);
        } else {
            InfoModelFactory.getInstance().appInfoModel.setDisableHelpshiftBranding(false);
        }
        Object disableAnimations = config.get("disableAnimations");
        if (disableAnimations instanceof Boolean) {
            InfoModelFactory.getInstance().appInfoModel.setDisableAnimations((Boolean)disableAnimations);
        } else {
            InfoModelFactory.getInstance().appInfoModel.setDisableAnimations(false);
        }
    }

    @Override
    public void _install(@NonNull Application application, @NonNull String apiKey, @NonNull String domain, @NonNull String appId) {
        this._install(application, apiKey, domain, appId, new HashMap<String, Object>());
    }

    @Override
    public void _setNameAndEmail(String name, String email) {
        ControllerFactory.getInstance().userController.setNameAndEmail(name, email);
    }

    @Override
    public void _registerDeviceToken(@NonNull Context context, @NonNull String deviceToken) {
        ControllerFactory.getInstance().deviceController.setPushToken(deviceToken);
    }

    @Override
    public void _handlePush(Context context, Intent intent) {
        NotificationCompat.Builder notificationBuilder = CampaignsNotification.createNotification(context, intent);
        if (notificationBuilder != null) {
            String campaignId = CampaignsNotification.getCampaignsId(intent);
            Notification notification = notificationBuilder.build();
            NotificationChannelsManager notificationChannelsManager = new NotificationChannelsManager(context);
            notification = notificationChannelsManager.attachChannelId(notification, NotificationChannelsManager.NotificationChannelType.CAMPAIGN);
            ApplicationUtil.showNotification(context, campaignId, notification);
        }
    }

    @Override
    public boolean _login(@NonNull String userId, String name, String email) {
        return ControllerFactory.getInstance().userController.login(userId, name, email);
    }

    @Override
    public boolean _logout() {
        return ControllerFactory.getInstance().userController.logout();
    }

    @Override
    public ActionExecutor _getActionExecutor() {
        return new CampaignActionExecutor();
    }

    @Override
    public void _setSDKLanguage(String locale) {
        InfoModelFactory.getInstance().sdkInfoModel.setSdkLanguage(locale);
    }

    @Override
    public void campaignDetailModelAdded(CampaignDetailModel campaignDetailModel) {
        if (delegate != null) {
            delegate.inboxMessageAdded(campaignDetailModel);
        }
    }

    @Override
    public void campaignIconImageFilePathUpdated(String campaignId) {
        if (delegate != null) {
            delegate.iconImageDownloaded(campaignId);
        }
    }

    @Override
    public void campaignCoverImageFilePathUpdated(String campaignId) {
        if (delegate != null) {
            delegate.coverImageDownloaded(campaignId);
        }
    }

    @Override
    public void campaignDeleted(String campaignId) {
        if (delegate != null) {
            delegate.inboxMessageDeleted(campaignId);
        }
    }

    @Override
    public void campaignRead(String campaignId) {
        if (delegate != null) {
            delegate.inboxMessageMarkedAsRead(campaignId);
        }
    }

    @Override
    public void campaignSeen(String campaignId) {
        if (delegate != null) {
            delegate.inboxMessageMarkedAsSeen(campaignId);
        }
    }

    private static class LazyHolder {
        static final Campaigns INSTANCE = new Campaigns();

        private LazyHolder() {
        }
    }
}

