/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns;

import android.text.TextUtils;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.delegates.InboxMessageDelegate;
import com.helpshift.campaigns.delegates.InboxPushNotificationDelegate;
import com.helpshift.campaigns.models.AnalyticsEvent;
import com.helpshift.campaigns.models.CampaignDetailModel;
import com.helpshift.campaigns.models.InboxMessage;
import com.helpshift.campaigns.observers.CampaignStorageObserver;
import com.helpshift.campaigns.storage.CampaignStorage;
import com.helpshift.campaigns.storage.StorageFactory;
import com.helpshift.campaigns.util.InAppCampaignsUtil;
import java.util.List;

public class Inbox
implements CampaignStorageObserver {
    private CampaignStorage campaignStorage;
    private List<? extends InboxMessage> messages;
    private InboxMessageDelegate messageDelegate;
    private InboxPushNotificationDelegate inboxPushNotificationDelegate;
    private static Inbox instance = null;

    private Inbox() {
        this.campaignStorage = StorageFactory.getInstance().campaignStorage;
        this.messages = this.getAllActiveCampaigns();
        this.campaignStorage.addObserver(this);
        ControllerFactory.getInstance().inboxApi = this;
    }

    private List<? extends InboxMessage> getAllActiveCampaigns() {
        return InAppCampaignsUtil.cleanAndGetActiveCampaigns(this.campaignStorage, ControllerFactory.getInstance().userController.getCurrentUser().identifier);
    }

    public List<? extends InboxMessage> getAllInboxMessages() {
        this.messages = this.getAllActiveCampaigns();
        return this.messages;
    }

    public InboxMessage getInboxMessage(String messageIdentifier) {
        if (TextUtils.isEmpty((CharSequence)messageIdentifier) || this.messages == null) {
            return null;
        }
        InboxMessage messageToReturn = null;
        for (InboxMessage inboxMessage : this.messages) {
            CampaignDetailModel campaignDetailModel = (CampaignDetailModel)inboxMessage;
            if (!messageIdentifier.equals(campaignDetailModel.getIdentifier()) || campaignDetailModel.isExpired()) continue;
            messageToReturn = inboxMessage;
            break;
        }
        return messageToReturn;
    }

    public void markInboxMessageAsRead(String messageIdentifier) {
        if (TextUtils.isEmpty((CharSequence)messageIdentifier) || this.messages == null) {
            return;
        }
        for (InboxMessage inboxMessage : this.messages) {
            CampaignDetailModel campaignDetailModel = (CampaignDetailModel)inboxMessage;
            if (!messageIdentifier.equals(campaignDetailModel.getIdentifier())) continue;
            campaignDetailModel.setReadStatus(true);
            this.campaignStorage.markCampaignAsRead(messageIdentifier);
            ControllerFactory.getInstance().analyticsEventController.recordAnalyticsEvent(AnalyticsEvent.AnalyticsEventType.MARK_AS_READ, messageIdentifier, false);
        }
    }

    public void markInboxMessageAsSeen(String messageIdentifier) {
        if (TextUtils.isEmpty((CharSequence)messageIdentifier) || this.messages == null) {
            return;
        }
        for (InboxMessage inboxMessage : this.messages) {
            CampaignDetailModel campaignDetailModel = (CampaignDetailModel)inboxMessage;
            if (!messageIdentifier.equals(campaignDetailModel.getIdentifier()) || campaignDetailModel.isExpired()) continue;
            campaignDetailModel.setSeenStatus(true);
            this.campaignStorage.markCampaignAsSeen(messageIdentifier);
            ControllerFactory.getInstance().analyticsEventController.recordAnalyticsEvent(AnalyticsEvent.AnalyticsEventType.VIEW, messageIdentifier, false);
        }
    }

    public void deleteInboxMessage(String messageIdentifier) {
        if (TextUtils.isEmpty((CharSequence)messageIdentifier) || this.messages == null) {
            return;
        }
        InboxMessage messageToDelete = null;
        for (InboxMessage inboxMessage : this.messages) {
            CampaignDetailModel campaignDetailModel = (CampaignDetailModel)inboxMessage;
            if (!messageIdentifier.equals(campaignDetailModel.getIdentifier())) continue;
            messageToDelete = inboxMessage;
            break;
        }
        if (messageToDelete != null) {
            this.messages.remove(messageToDelete);
            this.campaignStorage.deleteCampaign(messageIdentifier);
            ControllerFactory.getInstance().analyticsEventController.recordAnalyticsEvent(AnalyticsEvent.AnalyticsEventType.MARK_AS_DELETE, messageIdentifier, false);
        }
    }

    public void setInboxMessageDelegate(InboxMessageDelegate inboxMessageDelegate) {
        if (inboxMessageDelegate != null) {
            this.messageDelegate = inboxMessageDelegate;
        }
    }

    public void setInboxPushNotificationDelegate(InboxPushNotificationDelegate inboxPushNotificationDelegate) {
        if (inboxPushNotificationDelegate != null) {
            this.inboxPushNotificationDelegate = inboxPushNotificationDelegate;
        }
    }

    public InboxPushNotificationDelegate getInboxPushNotificationDelegate() {
        return this.inboxPushNotificationDelegate;
    }

    @Override
    public void campaignDetailModelAdded(CampaignDetailModel campaignDetailModel) {
        this.messages = this.getAllActiveCampaigns();
        if (this.messageDelegate != null) {
            this.messageDelegate.inboxMessageAdded(campaignDetailModel);
        }
    }

    @Override
    public void campaignIconImageFilePathUpdated(String campaignId) {
        this.messages = this.getAllActiveCampaigns();
        if (this.messageDelegate != null) {
            this.messageDelegate.iconImageDownloaded(campaignId);
        }
    }

    @Override
    public void campaignCoverImageFilePathUpdated(String campaignId) {
        this.messages = this.getAllActiveCampaigns();
        if (this.messageDelegate != null) {
            this.messageDelegate.coverImageDownloaded(campaignId);
        }
    }

    @Override
    public void campaignDeleted(String campaignId) {
        this.messages = this.getAllActiveCampaigns();
        if (this.messageDelegate != null) {
            this.messageDelegate.inboxMessageDeleted(campaignId);
        }
    }

    @Override
    public void campaignRead(String campaignId) {
        this.messages = this.getAllActiveCampaigns();
        if (this.messageDelegate != null) {
            this.messageDelegate.inboxMessageMarkedAsRead(campaignId);
        }
    }

    @Override
    public void campaignSeen(String campaignId) {
        this.messages = this.getAllActiveCampaigns();
        if (this.messageDelegate != null) {
            this.messageDelegate.inboxMessageMarkedAsSeen(campaignId);
        }
    }

    public void deallocate() {
        this.campaignStorage.removeObserver(this);
        ControllerFactory.getInstance().inboxApi = null;
        instance = null;
    }

    public static synchronized Inbox getInstance() {
        if (instance == null) {
            instance = new Inbox();
        }
        return instance;
    }
}

