/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.helpshift.CoreInternal;
import com.helpshift.campaigns.Inbox;
import com.helpshift.campaigns.activities.ParentActivity;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.models.AnalyticsEvent;
import com.helpshift.enums.ACTION_TYPE;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSLogger;

public class NotificationActivity
extends Activity {
    private static final String TAG = "Helpshift_NotifAct";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        HSLogger.d(TAG, "Campaign notification clicked");
        Intent intent = this.getIntent();
        String action = intent.getStringExtra("action");
        if (action == null) {
            action = "0";
        }
        ACTION_TYPE action_type = ACTION_TYPE.getEnum(action);
        String data = intent.getStringExtra("data");
        String campaignId = intent.getStringExtra("campaignId");
        boolean isForeground = intent.getBooleanExtra("foregroundStatus", true);
        ApplicationUtil.cancelNotification((Context)this, campaignId, 1);
        if (action_type != ACTION_TYPE.SHOW_INBOX) {
            int type = intent.getIntExtra("type", AnalyticsEvent.AnalyticsEventType.DEFAULT.intValue());
            ControllerFactory.getInstance().analyticsEventController.recordAnalyticsEvent(type, campaignId, false);
        }
        if (isForeground) {
            switch (action_type) {
                case SHOW_INBOX: {
                    Inbox inboxApi = ControllerFactory.getInstance().inboxApi;
                    if (inboxApi != null && inboxApi.getInboxPushNotificationDelegate() != null) {
                        inboxApi.getInboxPushNotificationDelegate().onInboxMessagePushNotificationClicked(campaignId);
                        break;
                    }
                    Intent inboxActivityIntent = new Intent((Context)this, ParentActivity.class);
                    inboxActivityIntent.putExtra("launch_source", 1);
                    inboxActivityIntent.putExtra("campaignId", campaignId);
                    this.startActivity(inboxActivityIntent);
                    break;
                }
                default: {
                    CoreInternal.getActionExecutor().executeAction(this, action_type, data);
                }
            }
        }
        this.finish();
    }
}

