/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.adapters;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.support.v7.widget.RecyclerView;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.campaigns.presenters.CampaignListPresenter;
import com.helpshift.util.Styles;
import com.helpshift.util.TimeUtil;
import java.util.HashMap;

public class CampaignListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private View.OnClickListener onClickListener;
    private int menuItemPosition;
    private CampaignListPresenter presenter;

    public CampaignListAdapter(CampaignListPresenter presenter, View.OnClickListener onClickListener) {
        this.presenter = presenter;
        this.onClickListener = onClickListener;
        this.menuItemPosition = -1;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        RelativeLayout campaignItem = (RelativeLayout)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.hs__campaign_recycler_view_item, parent, false);
        campaignItem.setOnClickListener(this.onClickListener);
        return new ViewHolder(campaignItem, this.presenter);
    }

    public void onBindViewHolder(final ViewHolder holder, int position) {
        holder.title.setText((CharSequence)this.presenter.getTitle(position));
        holder.body.setText((CharSequence)this.presenter.getBody(position));
        HashMap<String, Object> iconImageObject = this.presenter.getIconImage(position);
        boolean isDefault = iconImageObject.containsKey("default");
        Bitmap imageBitmap = (Bitmap)iconImageObject.get("bitmap");
        holder.icon.setImageBitmap(imageBitmap);
        if (!isDefault) {
            holder.icon.setColorFilter(Styles.getColor(this.context, R.attr.hs__inboxIconBackgroundColor), PorterDuff.Mode.DST_IN);
        } else {
            holder.icon.setColorFilter(Styles.getColor(this.context, R.attr.hs__inboxIconBackgroundColor), PorterDuff.Mode.SRC_OUT);
        }
        holder.date.setText((CharSequence)TimeUtil.getSinceText(this.presenter.getTimestamp(position)));
        if (!this.presenter.getReadStatus(position) && !this.presenter.getSeenStatus(position)) {
            holder.title.setTextColor(Styles.getColor(this.context, R.attr.hs__inboxTitleUnreadTextColor));
            holder.title.setTypeface(holder.title.getTypeface(), 1);
            holder.date.setTextColor(Styles.getColor(this.context, R.attr.hs__inboxTimeStampUnreadTextColor));
            holder.date.setTypeface(holder.date.getTypeface(), 1);
        } else {
            holder.title.setTextColor(Styles.getColor(this.context, R.attr.hs__inboxTitleTextColor));
            holder.title.setTypeface(holder.title.getTypeface(), 0);
            holder.date.setTextColor(Styles.getColor(this.context, R.attr.hs__inboxTimeStampTextColor));
            holder.date.setTypeface(holder.date.getTypeface(), 0);
        }
        holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                CampaignListAdapter.this.setMenuItemPosition(holder.getAdapterPosition());
                return false;
            }
        });
        holder.itemView.setTag((Object)this.presenter.getCampaignId(position));
    }

    public void onViewRecycled(ViewHolder holder) {
        holder.itemView.setOnLongClickListener(null);
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
    }

    public void removeItem(int position, boolean withUndo) {
        this.presenter.deleteRow(position, withUndo);
        this.notifyItemRemoved(position);
    }

    public void markCampaignAsRead(int position) {
        this.presenter.markCampaignAsRead(position);
        this.notifyItemChanged(position);
    }

    public int getItemCount() {
        return this.presenter.getCountOfCampaigns();
    }

    public int getMenuItemPosition() {
        return this.menuItemPosition;
    }

    public void setMenuItemPosition(int menuItemPosition) {
        this.menuItemPosition = menuItemPosition;
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnCreateContextMenuListener {
        TextView title;
        TextView body;
        TextView date;
        ImageView icon;
        private CampaignListPresenter presenter;

        public ViewHolder(RelativeLayout campaignItem, CampaignListPresenter presenter) {
            super((View)campaignItem);
            this.title = (TextView)campaignItem.findViewById(R.id.campaign_title);
            this.body = (TextView)campaignItem.findViewById(R.id.campaign_body);
            this.date = (TextView)campaignItem.findViewById(R.id.campaign_time);
            this.icon = (ImageView)campaignItem.findViewById(R.id.campaign_icon);
            campaignItem.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
            this.presenter = presenter;
        }

        public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
            menu.add(0, R.id.delete_campaign, 0, R.string.hs__cam_delete);
            if (!this.presenter.getReadStatus(this.getAdapterPosition()) && !this.presenter.getSeenStatus(this.getAdapterPosition())) {
                menu.add(0, R.id.mark_campaign_as_read, 0, R.string.hs__cam_mark_as_read);
            }
        }
    }
}

