/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.callbacks;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.view.View;
import com.helpshift.R;
import com.helpshift.campaigns.adapters.CampaignListAdapter;
import com.helpshift.campaigns.fragments.CampaignListFragment;
import com.helpshift.util.Styles;

public class CampaignListItemTouchHelperCallback
extends ItemTouchHelper.SimpleCallback {
    private Drawable deleteBackground;
    private Drawable deleteIcon;
    private int deleteIconIntrinsicWidth;
    private int deleteIconIntrinsicHeight;
    private CampaignListFragment campaignListFragment;

    public CampaignListItemTouchHelperCallback(Context context, CampaignListFragment campaignListFragment) {
        super(0, 16);
        this.campaignListFragment = campaignListFragment;
        this.deleteBackground = new ColorDrawable(Styles.getColor(context, R.attr.hs__inboxSwipeToDeleteBackgroundColor));
        this.deleteIcon = ResourcesCompat.getDrawable((Resources)context.getResources(), (int)R.drawable.hs__cam_delete_icon, null);
        Styles.setColorFilter(context, this.deleteIcon, R.attr.hs__inboxSwipeToDeleteIconColor);
        this.deleteIconIntrinsicWidth = this.deleteIcon.getIntrinsicWidth();
        this.deleteIconIntrinsicHeight = this.deleteIcon.getIntrinsicWidth();
    }

    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
        return false;
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        int itemPosition = viewHolder.getAdapterPosition();
        if (direction == 16) {
            this.campaignListFragment.removeItem(itemPosition, true);
        }
    }

    public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        View itemView = viewHolder.itemView;
        if (dX < 0.0f) {
            this.deleteBackground.setBounds(itemView.getRight() + (int)dX, itemView.getTop(), itemView.getRight(), itemView.getBottom());
            this.deleteBackground.draw(c);
            int topPosition = itemView.getTop();
            int rightPosition = itemView.getRight();
            int itemHeight = itemView.getBottom() - topPosition;
            int deleteIconLeft = rightPosition - 16 - this.deleteIconIntrinsicWidth;
            int deleteIconRight = rightPosition - 16;
            int deleteIconTop = topPosition + (itemHeight - this.deleteIconIntrinsicHeight) / 2;
            int deleteIconBottom = deleteIconTop + this.deleteIconIntrinsicHeight;
            this.deleteIcon.setBounds(deleteIconLeft, deleteIconTop, deleteIconRight, deleteIconBottom);
            this.deleteIcon.draw(c);
        }
    }

    public int getSwipeDirs(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        if (viewHolder instanceof CampaignListAdapter.ViewHolder && viewHolder.getAdapterPosition() == this.campaignListFragment.getMenuItemPosition()) {
            return 0;
        }
        return super.getSwipeDirs(recyclerView, viewHolder);
    }
}

