/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.controllers;

import android.text.TextUtils;
import com.helpshift.app.LifecycleListener;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.models.AnalyticsEvent;
import com.helpshift.controllers.SyncController;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.request.Request;
import com.helpshift.network.response.JsonArrayResponseParser;
import com.helpshift.network.response.Response;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.concurrent.DispatchQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;

public class AnalyticsEventController
implements NetworkDataProvider,
LifecycleListener {
    private static final String TAG = "Helpshift_AnalyticsCnt";
    KeyValueStorage storage;
    DispatchQueue workerQueue;
    public final SyncController syncController;
    private static final String KEY_ANALYTICS_EVENTS = "kAnalyticsEvents";
    private static final String KEY_RECORDED_EVENTS_MAP = "kRecordedEventsMap";

    protected AnalyticsEventController(KeyValueStorage storage, DispatchQueue queue, SyncController syncController) {
        this.storage = storage;
        this.workerQueue = queue;
        this.syncController = syncController;
        HelpshiftContext.getMainLifecycleCallback().addLifecycleListener(this);
    }

    public void recordAnalyticsEvent(Integer type, String campaignId, Boolean goalCompletion) {
        if (TextUtils.isEmpty((CharSequence)campaignId)) {
            HSLogger.d(TAG, "Encountered empty campaign id for analytics record");
            return;
        }
        AnalyticsEvent analyticsEvent = new AnalyticsEvent(type, campaignId, goalCompletion);
        if (!this.isAnalyticsEventRecorded(type, campaignId)) {
            this.addEventToStorage(analyticsEvent);
        }
    }

    private void addEventToStorage(final AnalyticsEvent newEvent) {
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                AnalyticsEventController.this.addToRecordedEventsMap(newEvent.type, newEvent.campaignId);
                ArrayList<AnalyticsEvent> events = (ArrayList<AnalyticsEvent>)AnalyticsEventController.this.storage.get(AnalyticsEventController.KEY_ANALYTICS_EVENTS);
                if (events == null) {
                    events = new ArrayList<AnalyticsEvent>();
                }
                events.add(newEvent);
                AnalyticsEventController.this.storage.set(AnalyticsEventController.KEY_ANALYTICS_EVENTS, events);
                AnalyticsEventController.this.syncController.incrementDataChangeCount("data_type_analytics_event", 1);
            }
        });
    }

    private boolean isAnalyticsEventRecorded(Integer type, String cid) {
        List recordedEventTypes;
        HashMap<String, List<Integer>> recordedEventsMap = this.getRecordedEventsMap();
        return recordedEventsMap != null && recordedEventsMap.containsKey(cid) && (recordedEventTypes = (List)recordedEventsMap.get(cid)).contains(type);
    }

    void addToRecordedEventsMap(Integer type, String cid) {
        List<Integer> recordedEventTypes;
        HashMap<String, List<Integer>> recordedEventsMap = this.getRecordedEventsMap();
        if (recordedEventsMap == null) {
            recordedEventsMap = new HashMap();
        }
        if ((recordedEventTypes = recordedEventsMap.get(cid)) == null) {
            recordedEventTypes = new ArrayList<Integer>();
        }
        recordedEventTypes.add(type);
        recordedEventsMap.put(cid, recordedEventTypes);
        this.storage.set(KEY_RECORDED_EVENTS_MAP, recordedEventsMap);
    }

    void removeAnalyticsEventsFromStorage(final String[] eventIds) {
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                ArrayList events = (ArrayList)AnalyticsEventController.this.storage.get(AnalyticsEventController.KEY_ANALYTICS_EVENTS);
                AnalyticsEventController.this.storage.removeKey(AnalyticsEventController.KEY_ANALYTICS_EVENTS);
                ArrayList<String> eventIdsList = new ArrayList<String>(Arrays.asList(eventIds));
                ArrayList<AnalyticsEvent> newEvents = new ArrayList<AnalyticsEvent>();
                for (AnalyticsEvent event : events) {
                    if (eventIdsList.contains(event.eventId)) continue;
                    newEvents.add(event);
                }
                if (newEvents.size() > 0) {
                    AnalyticsEventController.this.storage.set(AnalyticsEventController.KEY_ANALYTICS_EVENTS, newEvents);
                }
            }
        });
    }

    private HashMap<String, List<Integer>> getRecordedEventsMap() {
        return (HashMap)this.storage.get(KEY_RECORDED_EVENTS_MAP);
    }

    ArrayList<AnalyticsEvent> getAnalyticsEventsFromStorage() {
        return (ArrayList)this.storage.get(KEY_ANALYTICS_EVENTS);
    }

    @Override
    public Request getRequest() {
        Request newRequest = null;
        ArrayList<AnalyticsEvent> events = this.getAnalyticsEventsFromStorage();
        if (events != null && events.size() > 0) {
            final AnalyticsEventController controller = this;
            ArrayList<HashMap> eventsToSend = new ArrayList<HashMap>();
            ArrayList<String> eventIds = new ArrayList<String>();
            for (AnalyticsEvent event : events) {
                HashMap eventData = event.toData();
                eventsToSend.add(eventData);
                eventIds.add(event.eventId);
            }
            JSONArray eventsJson = HSJSONUtils.fromListOfMaps(eventsToSend);
            HashMap<String, String> apiData = new HashMap<String, String>();
            apiData.put("e", eventsJson.toString());
            apiData.put("sv", "6.3.0");
            apiData.put("v", "1.1.0");
            HashMap<String, Object> deviceInfo = ControllerFactory.getInstance().deviceController.getDeviceInfoForPushAnalytics();
            for (String key : deviceInfo.keySet()) {
                apiData.put(key, deviceInfo.get(key).toString());
            }
            final String[] eventIdsArray = eventIds.toArray(new String[eventIds.size()]);
            Response.Listener<JSONArray> successListener = new Response.Listener<JSONArray>(){

                @Override
                public void onResponse(JSONArray response, Integer requestId) {
                    controller.workerQueue.dispatchAsync(new Runnable(){

                        @Override
                        public void run() {
                            controller.removeAnalyticsEventsFromStorage(eventIdsArray);
                            controller.syncController.dataSynced("data_type_analytics_event", false);
                        }
                    });
                }
            };
            Response.ErrorListener errorListener = new Response.ErrorListener(){

                @Override
                public void onErrorResponse(NetworkError error, Integer requestId) {
                    controller.syncController.dataSyncFailed("data_type_analytics_event", error);
                }
            };
            newRequest = new Request(1, "/ma/ae/", apiData, successListener, errorListener, new JsonArrayResponseParser());
        }
        return newRequest;
    }

    @Override
    public Request getRequestWithFullData() {
        return null;
    }

    @Override
    public void setBatchSize(Integer batchSize) {
    }

    @Override
    public void onForeground() {
    }

    @Override
    public void onBackground() {
        ArrayList<AnalyticsEvent> events = this.getAnalyticsEventsFromStorage();
        if (events != null && events.size() > 0) {
            this.syncController.setDataChangeCount("data_type_analytics_event", events.size());
        }
    }
}

