/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.controllers;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.helpshift.app.LifecycleListener;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.controllers.SwitchUserController;
import com.helpshift.campaigns.models.DeviceModel;
import com.helpshift.campaigns.network.NetworkManagerFactory;
import com.helpshift.campaigns.poller.CampaignsPoller;
import com.helpshift.campaigns.util.constants.DeviceProperties;
import com.helpshift.campaigns.util.constants.SyncStatus;
import com.helpshift.controllers.DataSyncCoordinator;
import com.helpshift.controllers.SyncController;
import com.helpshift.model.AppInfoModel;
import com.helpshift.model.SdkInfoModel;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.request.Request;
import com.helpshift.network.response.JsonArrayResponseParser;
import com.helpshift.network.response.Response;
import com.helpshift.specifications.DailyFrequencyBasedSyncSpecification;
import com.helpshift.specifications.DecayingIntervalSyncSpecification;
import com.helpshift.specifications.SyncSpecification;
import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DeviceController
implements NetworkDataProvider,
LifecycleListener {
    private static final String TAG = "HelpshiftDebug";
    public final SyncController syncController;
    private SwitchUserController switchUserController;
    public final DeviceModel deviceModel;
    private DataSyncCoordinator dataSyncCoordinator;
    private SyncSpecification syncSpecification;
    private CampaignsPoller campaignsPoller;
    private SdkInfoModel sdkInfoModel;
    private AppInfoModel appInfoModel;

    protected DeviceController(DataSyncCoordinator dataSyncCoordinator, SyncController syncController, SwitchUserController switchUserController, DeviceModel deviceModel, SyncSpecification syncSpecification, SdkInfoModel sdkInfoModel, AppInfoModel appInfoModel) {
        this.dataSyncCoordinator = dataSyncCoordinator;
        this.deviceModel = deviceModel;
        this.syncController = syncController;
        this.syncSpecification = syncSpecification;
        this.switchUserController = switchUserController;
        this.sdkInfoModel = sdkInfoModel;
        this.appInfoModel = appInfoModel;
        HelpshiftContext.getMainLifecycleCallback().addLifecycleListener(this);
        HashMap<String, ArrayList> syncingProperties = this.deviceModel.getSyncingPropertiesUnsafe();
        ArrayList<String> syncingList = new ArrayList<String>();
        syncingList.addAll(syncingProperties.keySet());
        this.deviceModel.setSyncStatus(SyncStatus.UNSYNCED, syncingList);
    }

    @Override
    public Request getRequest() {
        final DeviceController deviceController = this;
        HashMap<String, ArrayList> unSyncedProperties = this.deviceModel.getUnsyncedProperties();
        final String uid = ControllerFactory.getInstance().userController.getCurrentUser().identifier;
        final ArrayList<String> unSyncedList = new ArrayList<String>(unSyncedProperties.keySet());
        Response.Listener<JSONArray> successListener = new Response.Listener<JSONArray>(){

            @Override
            public void onResponse(JSONArray response, Integer requestId) {
                DeviceController.this.handlePropertySyncSuccess(deviceController, unSyncedList, uid, false);
            }
        };
        Response.ErrorListener errorListener = new Response.ErrorListener(){

            @Override
            public void onErrorResponse(NetworkError error, Integer requestId) {
                DeviceController.this.handlePropertySyncFailure(deviceController, unSyncedList, error);
            }
        };
        return this.makeRequestForProperties(unSyncedProperties, successListener, errorListener, uid);
    }

    @Override
    @Nullable
    public Request getRequestWithFullData() {
        HashMap<String, ArrayList> syncedAndUnSyncedProperties = this.deviceModel.getSyncedAndUnSyncedProperties();
        if (syncedAndUnSyncedProperties.size() == 0) {
            return null;
        }
        final ArrayList<String> unSyncedPropertyKeys = new ArrayList<String>(this.deviceModel.getUnsyncedProperties().keySet());
        final ArrayList<String> syncedAndUnSyncedPropertyKeys = new ArrayList<String>(syncedAndUnSyncedProperties.keySet());
        final String uid = ControllerFactory.getInstance().userController.getCurrentUser().identifier;
        final DeviceController deviceController = this;
        Response.Listener<JSONArray> successListener = new Response.Listener<JSONArray>(){

            @Override
            public void onResponse(JSONArray response, Integer requestId) {
                DeviceController.this.handlePropertySyncSuccess(deviceController, syncedAndUnSyncedPropertyKeys, uid, true);
            }
        };
        Response.ErrorListener errorListener = new Response.ErrorListener(){

            @Override
            public void onErrorResponse(NetworkError error, Integer requestId) {
                syncedAndUnSyncedPropertyKeys.removeAll(unSyncedPropertyKeys);
                deviceController.deviceModel.checkAndMarkPropertiesAsSynced(syncedAndUnSyncedPropertyKeys);
                DeviceController.this.handlePropertySyncFailure(deviceController, unSyncedPropertyKeys, error);
            }
        };
        return this.makeRequestForProperties(syncedAndUnSyncedProperties, successListener, errorListener, uid);
    }

    private Request makeRequestForProperties(Map<String, ArrayList> syncingList, Response.Listener<JSONArray> successListener, Response.ErrorListener errorListener, String uid) {
        if (syncingList.size() == 0) {
            return null;
        }
        JSONObject propertiesJson = HSJSONUtils.fromNestedMap(syncingList);
        HashMap<String, String> apiData = new HashMap<String, String>();
        apiData.put("did", this.deviceModel.getIdentifier());
        apiData.put("uid", uid);
        apiData.put("p", propertiesJson.toString());
        this.deviceModel.setSyncStatus(SyncStatus.SYNCING, new ArrayList<String>(syncingList.keySet()));
        return new Request(1, "/ma/dp/", apiData, successListener, errorListener, new JsonArrayResponseParser());
    }

    void handlePropertySyncSuccess(DeviceController deviceController, ArrayList<String> syncingList, String uid, boolean isFullSync) {
        deviceController.sdkInfoModel.setDevicePropertiesSyncImmediately(false);
        deviceController.syncController.dataSynced("data_type_device", isFullSync);
        deviceController.deviceModel.checkAndMarkPropertiesAsSynced(syncingList);
        deviceController.syncController.setDataChangeCount("data_type_device", this.deviceModel.getUnsyncedProperties().size());
        if (!deviceController.dataSyncCoordinator.isFirstDeviceSyncComplete()) {
            deviceController.dataSyncCoordinator.firstDeviceSyncComplete();
            deviceController.switchUserController.doneSwitch(uid);
            String userIdSyncedWithBackend = deviceController.sdkInfoModel.getUserIdSyncedWithBackend();
            if (!TextUtils.isEmpty((CharSequence)userIdSyncedWithBackend) && !userIdSyncedWithBackend.equals(uid)) {
                deviceController.switchUserController.requestSwitch(uid, userIdSyncedWithBackend);
            }
            deviceController.syncSpecification = new DailyFrequencyBasedSyncSpecification(4, "data_type_device");
            deviceController.syncController.addSpecification(this.syncSpecification);
            deviceController.syncController.addSyncListeners(NetworkManagerFactory.getInstance().devicePropertiesNetworkManager);
        }
    }

    void handlePropertySyncFailure(DeviceController deviceController, ArrayList<String> unSyncedList, NetworkError error) {
        deviceController.deviceModel.setSyncStatus(SyncStatus.UNSYNCED, unSyncedList);
        if (!deviceController.dataSyncCoordinator.isFirstDeviceSyncComplete() && deviceController.syncSpecification instanceof DecayingIntervalSyncSpecification) {
            ((DecayingIntervalSyncSpecification)deviceController.syncSpecification).decayElapsedTimeThreshold();
        }
        deviceController.syncController.dataSyncFailed("data_type_device", error);
    }

    public HashMap<String, Object> getDeviceInfoForPushAnalytics() {
        Object appVersion;
        Object dm;
        Object osVersion;
        String did;
        Object language;
        Object countryCode;
        HashMap<String, Object> deviceInfo = new HashMap<String, Object>();
        Object platform = this.deviceModel.getPropertyValue(DeviceProperties.DeviceKeys.PLATFORM);
        if (platform != null) {
            deviceInfo.put("p", platform);
        }
        if ((countryCode = this.deviceModel.getPropertyValue(DeviceProperties.DeviceKeys.COUNTRY)) != null) {
            deviceInfo.put("cc", countryCode);
        }
        if ((language = this.deviceModel.getPropertyValue(DeviceProperties.DeviceKeys.LANGUAGE)) != null) {
            deviceInfo.put("ln", language);
        }
        if ((did = this.deviceModel.getIdentifier()) != null) {
            deviceInfo.put("did", did);
        }
        if ((osVersion = this.deviceModel.getPropertyValue(DeviceProperties.DeviceKeys.OS)) != null) {
            deviceInfo.put("osv", osVersion);
        }
        if ((dm = this.deviceModel.getPropertyValue(DeviceProperties.DeviceKeys.MODEL)) != null) {
            deviceInfo.put("dm", dm);
        }
        if ((appVersion = this.deviceModel.getPropertyValue(DeviceProperties.DeviceKeys.APP_VERSION)) != null) {
            deviceInfo.put("av", appVersion);
        }
        return deviceInfo;
    }

    @Override
    public void setBatchSize(Integer batchSize) {
    }

    public void setPushToken(String pushToken) {
        this.deviceModel.setPushToken(pushToken);
        this.syncController.incrementDataChangeCount("data_type_device", 1);
    }

    public void setDevelopmentPlatform(String developmentPlatform) {
        this.deviceModel.setDevelopmentPlatform(developmentPlatform);
    }

    @Override
    public void onForeground() {
        this.deviceModel.rescanDevice();
        HashMap<String, ArrayList> unSynced = this.deviceModel.getUnsyncedProperties();
        if (unSynced.size() > 0) {
            this.syncController.setDataChangeCount("data_type_device", unSynced.size());
        }
        Boolean isPollingEnabledForInbox = this.appInfoModel.enableInboxPolling;
        boolean isPollingStarted = false;
        if (isPollingEnabledForInbox != null && isPollingEnabledForInbox.booleanValue()) {
            if (this.campaignsPoller == null) {
                this.campaignsPoller = new CampaignsPoller(NetworkManagerFactory.getInstance().inboxNetworkManager);
                this.campaignsPoller.start();
            } else {
                this.resetPoller();
            }
            isPollingStarted = true;
        }
        Boolean isFirstLaunch = this.sdkInfoModel.getFirstLaunch();
        Boolean isOneCampaignFetchSuccessfull = this.sdkInfoModel.getOneCampaignFetchSuccessful();
        if (!isPollingStarted && (isFirstLaunch != null && isFirstLaunch.booleanValue() || isOneCampaignFetchSuccessfull != null && !isOneCampaignFetchSuccessfull.booleanValue())) {
            try {
                NetworkManagerFactory.getInstance().inboxNetworkManager.fetchCampaigns();
            }
            catch (Exception e) {
                HSLogger.d(TAG, "Exception while fetching campaigns", e);
            }
        }
    }

    @Override
    public void onBackground() {
        this.sdkInfoModel.setFirstLaunch(false);
    }

    public void resetPoller() {
        if (this.campaignsPoller != null) {
            this.campaignsPoller.shutdown();
            this.campaignsPoller = new CampaignsPoller(NetworkManagerFactory.getInstance().inboxNetworkManager);
            this.campaignsPoller.start();
        }
    }
}

