/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.controllers;

import android.text.TextUtils;
import com.helpshift.app.LifecycleListener;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.controllers.UserController;
import com.helpshift.campaigns.downloader.CampaignDownloader;
import com.helpshift.campaigns.models.AnalyticsEvent;
import com.helpshift.campaigns.models.CampaignDetailModel;
import com.helpshift.campaigns.models.CampaignSyncModel;
import com.helpshift.campaigns.observers.CampaignDownloadObserver;
import com.helpshift.campaigns.storage.CampaignStorage;
import com.helpshift.campaigns.storage.CampaignSyncModelStorage;
import com.helpshift.campaigns.util.InAppCampaignsUtil;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.request.Request;
import com.helpshift.network.response.JsonObjectResponseParser;
import com.helpshift.network.response.Response;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InboxSyncController
implements CampaignDownloadObserver,
LifecycleListener,
NetworkDataProvider {
    private static final String TAG = "Helpshift_ISControl";
    CampaignSyncModelStorage syncModelStorage;
    private CampaignStorage campaignStorage;
    private UserController userController;
    private CampaignDownloader campaignDownloader;
    KeyValueStorage keyValueStorage;
    private static final String CURSOR_KEY_PREFIX = "hs__campaigns_inbox_cursor";

    public InboxSyncController(CampaignStorage campaignStorage, CampaignSyncModelStorage syncModelStorage, UserController userController, KeyValueStorage keyValueStorage) {
        this.campaignStorage = campaignStorage;
        this.syncModelStorage = syncModelStorage;
        this.userController = userController;
        this.keyValueStorage = keyValueStorage;
        this.campaignDownloader = new CampaignDownloader(this);
        this.syncModelStorage.addObserver(this.campaignDownloader);
        this.campaignStorage.addObserver(this.campaignDownloader);
        this.syncModelStorage.cleanUpSyncingModels(userController.getCurrentUser().identifier);
        HelpshiftContext.getMainLifecycleCallback().addLifecycleListener(this);
    }

    @Override
    public void campaignDownloadStarted(String cid) {
        this.syncModelStorage.markCampaignAsSyncing(cid, this.userController.getCurrentUser().identifier);
    }

    @Override
    public void campaignDownloadCompleted(CampaignSyncModel syncModel, String responseObj) {
        try {
            JSONObject campaignObject = new JSONObject(responseObj);
            CampaignDetailModel campaignDetailModel = new CampaignDetailModel(syncModel.campaignId, campaignObject, syncModel.timeStamp, syncModel.expiryTimeStamp);
            this.syncModelStorage.markCampaignAsSynced(syncModel.campaignId, this.userController.getCurrentUser().identifier);
            this.campaignStorage.addCampaign(campaignDetailModel);
            ControllerFactory.getInstance().analyticsEventController.recordAnalyticsEvent(AnalyticsEvent.AnalyticsEventType.DELIVERY, syncModel.campaignId, false);
        }
        catch (JSONException e) {
            HSLogger.d(TAG, "Exception while parsing json string of campaign detail object", e);
        }
    }

    @Override
    public void campaignDownloadFailed(String cid) {
        HSLogger.d(TAG, "Campaign download failed : " + cid);
        this.syncModelStorage.markCampaignAsUnSynced(cid, this.userController.getCurrentUser().identifier);
    }

    @Override
    public void iconImageDownloadCompleted(String campaignId, String iconImageFilePath) {
        HSLogger.d(TAG, "Campaign icon image download complete : " + campaignId);
        this.campaignStorage.updateCampaignWithIconImageFilePath(campaignId, iconImageFilePath);
    }

    @Override
    public void iconImageDownloadFailed(String campaignId) {
        HSLogger.d(TAG, "Campaign icon download failed : " + campaignId);
    }

    @Override
    public void coverImageDownloadCompleted(String campaignId, String coverImageFilePath) {
        HSLogger.d(TAG, "Campaign cover image download complete : " + campaignId + ", File path : " + coverImageFilePath);
        this.campaignStorage.updateCampaignWIthCoverImageFilePath(campaignId, coverImageFilePath);
    }

    @Override
    public void coverImageDownloadFailed(String campaignId) {
        HSLogger.d(TAG, "Campaign cover image download failed : " + campaignId);
    }

    public void resetCorruptImageDownloadRetryCount(String imageUrl) {
        this.campaignDownloader.enableCorruptImageRetry(imageUrl);
    }

    @Override
    public void onForeground() {
        List<CampaignSyncModel> unsyncedCampaigns = this.syncModelStorage.getAllUnsyncedCampaigns(this.userController.getCurrentUser().identifier);
        for (CampaignSyncModel campaignSyncModel : unsyncedCampaigns) {
            HSLogger.d(TAG, "Starting unsynced campaign download");
            this.campaignDownloader.startCampaignDownload(campaignSyncModel);
        }
    }

    @Override
    public void onBackground() {
    }

    public void startIconImageDownload(String iconImageUrl, String campaignId) {
        HSLogger.d(TAG, "Campaign icon image download start : " + campaignId + ", URL : " + iconImageUrl);
        this.campaignDownloader.startIconImageDownload(iconImageUrl, campaignId);
    }

    public void startCoverImageDownload(String coverImageUrl, String campaignId) {
        HSLogger.d(TAG, "Campaign cover image download start : " + campaignId + ", URL : " + coverImageUrl);
        this.campaignDownloader.startCoverImageDownload(coverImageUrl, campaignId);
    }

    @Override
    public Request getRequest() {
        HashMap<String, String> apiData = new HashMap<String, String>();
        apiData.put("did", ControllerFactory.getInstance().deviceController.deviceModel.getIdentifier());
        final String uid = ControllerFactory.getInstance().userController.getCurrentUser().identifier;
        apiData.put("uid", uid);
        String cursor = (String)this.keyValueStorage.get(CURSOR_KEY_PREFIX + uid);
        if (!TextUtils.isEmpty((CharSequence)cursor)) {
            apiData.put("cursor", cursor);
        }
        Response.Listener<JSONObject> successListener = new Response.Listener<JSONObject>(){

            @Override
            public void onResponse(JSONObject response, Integer requestId) {
                JSONArray creativeArray;
                InfoModelFactory.getInstance().sdkInfoModel.setOneCampaignFetchSuccessful(true);
                String cursor = response.optString("cursor", "");
                if (!TextUtils.isEmpty((CharSequence)cursor)) {
                    InboxSyncController.this.keyValueStorage.set(InboxSyncController.CURSOR_KEY_PREFIX + uid, (Serializable)((Object)cursor));
                }
                if ((creativeArray = response.optJSONArray("campaigns")) == null) {
                    return;
                }
                for (int i = 0; i < creativeArray.length(); ++i) {
                    JSONObject creativeJson = creativeArray.optJSONObject(i);
                    if (creativeJson == null) continue;
                    try {
                        String changeSetId = creativeJson.optString("cid", "");
                        String campaignId = InAppCampaignsUtil.getCampaignIdForLoggedInUser(changeSetId);
                        InfoModelFactory.getInstance().sdkInfoModel.setChangeSetId(changeSetId, campaignId);
                        creativeJson.put("cid", (Object)campaignId);
                        CampaignSyncModel syncModel = new CampaignSyncModel(creativeJson);
                        InboxSyncController.this.syncModelStorage.addCampaign(syncModel, uid);
                        continue;
                    }
                    catch (JSONException e) {
                        HSLogger.d(InboxSyncController.TAG, "Error while parsing creative");
                    }
                }
            }
        };
        Response.ErrorListener errorListener = new Response.ErrorListener(){

            @Override
            public void onErrorResponse(NetworkError error, Integer requestId) {
            }
        };
        return new Request(0, "/ma/inbox/", apiData, successListener, errorListener, new JsonObjectResponseParser());
    }

    @Override
    public Request getRequestWithFullData() {
        return null;
    }

    @Override
    public void setBatchSize(Integer batchSize) {
    }
}

