/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.controllers;

import android.text.TextUtils;
import com.helpshift.app.LifecycleListener;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.controllers.DataSyncCoordinator;
import com.helpshift.controllers.SyncController;
import com.helpshift.model.SdkInfoModel;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.request.Request;
import com.helpshift.network.response.JsonArrayResponseParser;
import com.helpshift.network.response.Response;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.io.Serializable;
import java.util.HashMap;
import org.json.JSONArray;

public class SwitchUserController
implements NetworkDataProvider,
LifecycleListener {
    private static final String TAG = "Helpshift_SUControl";
    private static final String PREV_USER = "__hs_switch_prev_user";
    private static final String CURRENT_USER = "__hs_switch_current_user";
    public final SyncController syncController;
    private DataSyncCoordinator dataSyncCoordinator;
    SdkInfoModel sdkInfoModel;
    String currentUser = "";
    private String prevUser = "";
    private KeyValueStorage storage;

    protected SwitchUserController(DataSyncCoordinator dataSyncCoordinator, SyncController syncController, KeyValueStorage keyValueStorage, SdkInfoModel sdkInfoModel) {
        this.syncController = syncController;
        this.sdkInfoModel = sdkInfoModel;
        HelpshiftContext.getMainLifecycleCallback().addLifecycleListener(this);
        this.dataSyncCoordinator = dataSyncCoordinator;
        this.storage = keyValueStorage;
        Object prevUserFromStorage = this.storage.get(PREV_USER);
        Object currentUserFromStorage = this.storage.get(CURRENT_USER);
        if (prevUserFromStorage != null && prevUserFromStorage instanceof String) {
            this.prevUser = (String)prevUserFromStorage;
        }
        if (currentUserFromStorage != null && currentUserFromStorage instanceof String) {
            this.currentUser = (String)currentUserFromStorage;
        }
    }

    public void doneSwitch(String userId) {
        HSLogger.d(TAG, "Switch user done : Id : " + userId);
        this.prevUser = "";
        this.currentUser = "";
        this.storage.set(PREV_USER, (Serializable)((Object)this.prevUser));
        this.storage.set(CURRENT_USER, (Serializable)((Object)this.currentUser));
        this.dataSyncCoordinator.switchUserComplete(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void requestSwitch(String userId, String prevUserId) {
        SwitchUserController switchUserController = this;
        synchronized (switchUserController) {
            HSLogger.d(TAG, "Requesting switch user : New Id : " + userId + ", Old Id : " + prevUserId);
            if (TextUtils.isEmpty((CharSequence)userId)) return;
            if (TextUtils.isEmpty((CharSequence)prevUserId)) return;
            if (!TextUtils.isEmpty((CharSequence)this.prevUser) && !TextUtils.isEmpty((CharSequence)this.currentUser)) {
                if (this.prevUser.equals(userId)) {
                    this.doneSwitch(prevUserId);
                    return;
                }
                this.currentUser = userId;
            } else {
                this.currentUser = userId;
                this.prevUser = prevUserId;
            }
            this.storage.set(PREV_USER, (Serializable)((Object)this.prevUser));
            this.storage.set(CURRENT_USER, (Serializable)((Object)this.currentUser));
            this.syncController.incrementDataChangeCount("data_type_switch_user", 1);
            this.dataSyncCoordinator.switchUserPending(this.currentUser);
            return;
        }
    }

    @Override
    public Request getRequest() {
        final SwitchUserController controller = this;
        if (!(TextUtils.isEmpty((CharSequence)this.prevUser) || TextUtils.isEmpty((CharSequence)this.currentUser) || this.currentUser.equals(this.prevUser))) {
            String did = ControllerFactory.getInstance().deviceController.deviceModel.getIdentifier();
            HashMap<String, String> apiData = new HashMap<String, String>();
            apiData.put("did", did);
            apiData.put("uid", this.currentUser);
            apiData.put("prev-uid", this.prevUser);
            return new Request(1, "/ma/su/", apiData, new Response.Listener<JSONArray>(){

                @Override
                public void onResponse(JSONArray response, Integer requestId) {
                    controller.syncController.dataSynced("data_type_switch_user", false);
                    controller.sdkInfoModel.setUserIdSyncedWithBackend(SwitchUserController.this.currentUser);
                    controller.doneSwitch(SwitchUserController.this.currentUser);
                }
            }, new Response.ErrorListener(){

                @Override
                public void onErrorResponse(NetworkError error, Integer requestId) {
                    controller.syncController.dataSyncFailed("data_type_switch_user", error);
                }
            }, new JsonArrayResponseParser());
        }
        return null;
    }

    @Override
    public Request getRequestWithFullData() {
        return null;
    }

    @Override
    public void setBatchSize(Integer batchSize) {
    }

    @Override
    public void onForeground() {
    }

    @Override
    public void onBackground() {
        if (!TextUtils.isEmpty((CharSequence)this.currentUser) && !TextUtils.isEmpty((CharSequence)this.prevUser)) {
            this.syncController.setDataChangeCount("data_type_switch_user", 1);
        }
    }
}

