/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.controllers;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.helpshift.campaigns.controllers.SessionController;
import com.helpshift.campaigns.controllers.SwitchUserController;
import com.helpshift.campaigns.models.PropertyValue;
import com.helpshift.campaigns.models.UserModel;
import com.helpshift.campaigns.network.NetworkManagerFactory;
import com.helpshift.campaigns.storage.PropertyStorage;
import com.helpshift.campaigns.util.constants.SyncStatus;
import com.helpshift.controllers.SyncController;
import com.helpshift.model.SdkInfoModel;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.request.Request;
import com.helpshift.network.response.JsonArrayResponseParser;
import com.helpshift.network.response.Response;
import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HSPattern;
import com.helpshift.util.SchemaUtil;
import com.helpshift.util.concurrent.DispatchQueue;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserController
implements NetworkDataProvider {
    private static final String TAG = "Helpshift_UserControl";
    public final SyncController syncController;
    private SessionController sessionController;
    private SwitchUserController switchUserController;
    UserModel currentUser;
    private DispatchQueue workerQueue;
    private PropertyStorage storage;
    private Integer batchSize;
    SdkInfoModel sdkInfoModel;

    protected UserController(SyncController syncController, SessionController sessionController, SwitchUserController switchUserController, DispatchQueue queue, PropertyStorage storage, Integer batchSize, SdkInfoModel infoModel) {
        this.workerQueue = queue;
        this.batchSize = batchSize;
        this.sdkInfoModel = infoModel;
        this.sessionController = sessionController;
        this.switchUserController = switchUserController;
        this.storage = storage;
        String currentId = this.sdkInfoModel.getCurrentLoggedInId();
        if (TextUtils.isEmpty((CharSequence)currentId)) {
            currentId = this.sdkInfoModel.getDeviceId();
        }
        if (TextUtils.isEmpty((CharSequence)currentId)) {
            throw new IllegalArgumentException("Found no valid ID in user controller constructor.");
        }
        this.initializeForIdentifier(currentId);
        this.syncController = syncController;
    }

    @Override
    public void setBatchSize(Integer newBatchSize) {
        this.batchSize = newBatchSize;
    }

    public UserModel getCurrentUser() {
        return this.currentUser;
    }

    private void initializeForIdentifier(String identifier) {
        if (!TextUtils.isEmpty((CharSequence)identifier)) {
            String previousLogin = null;
            if (this.currentUser != null) {
                previousLogin = this.currentUser.identifier;
            }
            if (this.currentUser == null || !identifier.equals(previousLogin)) {
                this.storage.initStorage(identifier);
                this.currentUser = new UserModel(identifier, this.storage);
                this.sdkInfoModel.setCurrentLoggedInId(identifier);
            }
            HashMap<String, PropertyValue> syncingProperties = this.getSyncingPropertiesUnsafe();
            String[] syncingKeys = syncingProperties.keySet().toArray(new String[syncingProperties.keySet().size()]);
            ArrayList<String> syncingList = new ArrayList<String>(Arrays.asList(syncingKeys));
            this.getCurrentUser().setSyncStatus(SyncStatus.UNSYNCED, syncingList);
        }
    }

    void switchToUser(String userId, String oldUserId) {
        if (!oldUserId.equals(userId)) {
            boolean isSessionActive = this.sessionController.isSessionActive();
            if (isSessionActive) {
                this.sessionController.endSession();
            }
            this.initializeForIdentifier(userId);
            if (isSessionActive) {
                this.sessionController.startSession();
            }
            this.switchUserController.requestSwitch(userId, oldUserId);
        }
    }

    public boolean logout() {
        final UserController controller = this;
        if (!controller.currentUser.identifier.equals(controller.sdkInfoModel.getDeviceId())) {
            this.workerQueue.dispatchAsync(new Runnable(){

                @Override
                public void run() {
                    String currentLogin = controller.currentUser.identifier;
                    controller.switchToUser(UserController.this.sdkInfoModel.getDeviceId(), currentLogin);
                }
            });
        }
        return true;
    }

    public boolean login(final String identifier, final String name, final String email) {
        final UserController controller = this;
        String[] invalidLogins = new String[]{null, "", "null"};
        if (Arrays.asList(invalidLogins).contains(identifier)) {
            this.logout();
            return false;
        }
        this.workerQueue.dispatchSync(new Runnable(){

            @Override
            public void run() {
                String currentLogin = controller.currentUser.identifier;
                controller.switchToUser(identifier, currentLogin);
                controller.setNameAndEmail(name, email);
                try {
                    NetworkManagerFactory.getInstance().inboxNetworkManager.fetchCampaigns();
                }
                catch (Exception e) {
                    HSLogger.d(UserController.TAG, "Exception while fetching campaigns after login", e);
                }
            }
        });
        return true;
    }

    Integer getSizeOfUserProperties() {
        return this.getSizeOfPropertiesMap(this.getAllPropertiesUnsafe());
    }

    Integer getSizeOfPropertiesMap(HashMap<String, PropertyValue> inputProperties) {
        Integer currentSize = 0;
        if (inputProperties != null && inputProperties.size() > 0) {
            HashMap<String, ArrayList> jsonRepresentation = new HashMap<String, ArrayList>();
            for (Map.Entry<String, PropertyValue> entry : inputProperties.entrySet()) {
                PropertyValue value = entry.getValue();
                ArrayList valueInfo = value.getValueInfo();
                jsonRepresentation.put(entry.getKey(), valueInfo);
            }
            JSONObject propertiesJson = new JSONObject(jsonRepresentation);
            try {
                currentSize = propertiesJson.toString().getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException e) {
                HSLogger.d(TAG, "Exception while getting property size : ", e);
            }
        }
        return currentSize;
    }

    public boolean addProperty(final String key, final PropertyValue value) {
        final UserController controller = this;
        final boolean isValidKey = SchemaUtil.validatePropertyKey(key);
        if (!isValidKey) {
            HSLogger.d(TAG, "Invalid property : Key : " + key + ", Value : " + value);
        }
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                if (isValidKey) {
                    HashMap<String, PropertyValue> propertyValueHashMap = new HashMap<String, PropertyValue>();
                    propertyValueHashMap.put(key, value);
                    Integer inputSize = controller.getSizeOfPropertiesMap(propertyValueHashMap);
                    if (controller.getSizeOfUserProperties() + inputSize <= 102400) {
                        HSLogger.d(UserController.TAG, "Add property : Key " + key + ", Value : " + value.toString());
                        if (controller.getCurrentUser().addProperty(key, value)) {
                            controller.syncController.incrementDataChangeCount("data_type_user", 1);
                        }
                    } else {
                        HSLogger.d(UserController.TAG, "Property size exceeds the maximum allowed size : Key : " + key);
                    }
                }
            }
        });
        return isValidKey;
    }

    public String[] addProperties(HashMap<String, PropertyValue> propertyValueHashMap) {
        final UserController controller = this;
        final HashMap<String, PropertyValue> acceptableProperties = new HashMap<String, PropertyValue>();
        for (Map.Entry<String, PropertyValue> entry : propertyValueHashMap.entrySet()) {
            if (SchemaUtil.validatePropertyKey(entry.getKey())) {
                acceptableProperties.put(entry.getKey(), entry.getValue());
                continue;
            }
            HSLogger.d(TAG, "Invalid property : Key : " + entry.getKey() + ", Value : " + entry.getValue());
        }
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                if (acceptableProperties.size() > 0) {
                    Integer inputSize = controller.getSizeOfPropertiesMap(acceptableProperties);
                    if (controller.getSizeOfUserProperties() + inputSize <= 102400) {
                        HSLogger.d(UserController.TAG, "Add properties : " + acceptableProperties.toString());
                        ArrayList<String> addToDb = controller.getCurrentUser().addProperties(acceptableProperties);
                        int addToDbCount = addToDb.size();
                        controller.syncController.incrementDataChangeCount("data_type_user", addToDbCount);
                    } else {
                        HSLogger.d(UserController.TAG, "Properties size exceeds the maximum allowed size");
                    }
                }
            }
        });
        return acceptableProperties.keySet().toArray(new String[acceptableProperties.size()]);
    }

    public HashMap<String, PropertyValue> getUnsyncedProperties() {
        UserController controller = this;
        HashMap<String, PropertyValue> properties = new HashMap<String, PropertyValue>();
        properties.putAll(controller.getCurrentUser().getUnsyncedProperties());
        return properties;
    }

    public HashMap<String, PropertyValue> getSyncingPropertiesUnsafe() {
        return this.getCurrentUser().getSyncingProperties();
    }

    private HashMap<String, PropertyValue> getAllPropertiesUnsafe() {
        return this.getCurrentUser().getAllProperties();
    }

    private HashMap<String, ArrayList> batchProperties(HashMap<String, PropertyValue> inputProperties, Integer batchSize) {
        HashMap<String, ArrayList> batchedProperties = new HashMap<String, ArrayList>();
        Integer currentSize = 0;
        Integer batchSizeInBytes = batchSize * 1024 * 1024;
        for (Map.Entry<String, PropertyValue> entry : inputProperties.entrySet()) {
            PropertyValue value = entry.getValue();
            ArrayList valueInfo = value.getValueInfo();
            JSONArray valueJson = new JSONArray((Collection)valueInfo);
            try {
                int jsonLength = valueJson.toString().getBytes("UTF-8").length;
                if (currentSize + jsonLength > batchSizeInBytes) break;
                batchedProperties.put(entry.getKey(), valueInfo);
                currentSize = currentSize + jsonLength;
            }
            catch (UnsupportedEncodingException e) {
                HSLogger.d(TAG, "Exception in batching : ", e);
            }
        }
        return batchedProperties;
    }

    @Override
    @Nullable
    public Request getRequest() {
        HashMap<String, ArrayList> unsyncedProperties = this.batchProperties(this.getUnsyncedProperties(), this.batchSize);
        final ArrayList<String> unSyncedList = new ArrayList<String>(unsyncedProperties.keySet());
        final UserController userController = this;
        Response.Listener successListener = new Response.Listener(){

            public void onResponse(Object response, Integer requestId) {
                UserController.this.handlePropertySyncSuccess(userController, unSyncedList, false);
            }
        };
        Response.ErrorListener errorListener = new Response.ErrorListener(){

            @Override
            public void onErrorResponse(NetworkError error, Integer requestId) {
                UserController.this.handlePropertySyncFailure(userController, unSyncedList, error);
            }
        };
        return this.makeRequestForProperties(unsyncedProperties, successListener, errorListener);
    }

    @Override
    @Nullable
    public Request getRequestWithFullData() {
        HashMap<String, PropertyValue> syncedAndUnSyncedProperties = this.getCurrentUser().getSyncedAndUnSyncedProperties();
        HashMap<String, ArrayList> batchProperties = this.batchProperties(syncedAndUnSyncedProperties, this.batchSize);
        if (batchProperties.size() == 0) {
            return null;
        }
        final ArrayList<String> unSyncedPropertyKeys = new ArrayList<String>(this.getUnsyncedProperties().keySet());
        final ArrayList<String> batchPropertyKeys = new ArrayList<String>(batchProperties.keySet());
        final UserController userController = this;
        Response.Listener<JSONArray> successListener = new Response.Listener<JSONArray>(){

            @Override
            public void onResponse(JSONArray response, Integer requestId) {
                UserController.this.handlePropertySyncSuccess(userController, batchPropertyKeys, true);
            }
        };
        Response.ErrorListener errorListener = new Response.ErrorListener(){

            @Override
            public void onErrorResponse(NetworkError error, Integer requestId) {
                batchPropertyKeys.removeAll(unSyncedPropertyKeys);
                userController.getCurrentUser().checkAndMarkPropertiesAsSynced(batchPropertyKeys);
                UserController.this.handlePropertySyncFailure(userController, unSyncedPropertyKeys, error);
            }
        };
        return this.makeRequestForProperties(batchProperties, successListener, errorListener);
    }

    void handlePropertySyncSuccess(UserController userController, ArrayList<String> syncingList, boolean isFullSync) {
        userController.syncController.dataSynced("data_type_user", isFullSync);
        userController.getCurrentUser().checkAndMarkPropertiesAsSynced(syncingList);
        userController.syncController.setDataChangeCount("data_type_user", this.getUnsyncedProperties().size());
    }

    void handlePropertySyncFailure(UserController userController, ArrayList<String> unSyncedList, NetworkError error) {
        userController.getCurrentUser().setSyncStatus(SyncStatus.UNSYNCED, unSyncedList);
        userController.syncController.dataSyncFailed("data_type_user", error);
    }

    private Request makeRequestForProperties(Map<String, ArrayList> syncingList, Response.Listener<JSONArray> successListener, Response.ErrorListener errorListener) {
        if (syncingList.size() == 0) {
            return null;
        }
        JSONObject propertiesJson = HSJSONUtils.fromNestedMap(syncingList);
        HashMap<String, String> apiData = new HashMap<String, String>();
        apiData.put("did", this.sdkInfoModel.getDeviceId());
        apiData.put("uid", this.getCurrentUser().identifier);
        apiData.put("p", propertiesJson.toString());
        this.getCurrentUser().setSyncStatus(SyncStatus.SYNCING, new ArrayList<String>(syncingList.keySet()));
        return new Request(1, "/ma/up/", apiData, successListener, errorListener, new JsonArrayResponseParser());
    }

    public void setNameAndEmail(String name, String email) {
        String validName = null;
        String validEmail = null;
        if (name != null) {
            validName = name.trim();
        }
        if (email != null) {
            validEmail = email.trim();
        }
        HashMap<String, PropertyValue> userProperties = new HashMap<String, PropertyValue>();
        if (!TextUtils.isEmpty((CharSequence)validName) && HSPattern.isValidName(validName)) {
            PropertyValue nameProperty = new PropertyValue(validName);
            userProperties.put("name", nameProperty);
        }
        if (!TextUtils.isEmpty((CharSequence)validEmail) && HSPattern.isValidEmail(validEmail)) {
            PropertyValue emailProperty = new PropertyValue(validEmail);
            userProperties.put("email", emailProperty);
        }
        this.addProperties(userProperties);
        this.currentUser.setNameAndEmail(validName, validEmail);
    }
}

